<?php 
if ( ! function_exists( 'codemasterwptheme_setup') ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which runs
 * before the init hook. The init hook is too late for some features, such as indicating
 * support post thumbnails.
 */
function codemasterwptheme_setup() {
    /**
     * Make theme available for translation.
     */
   	load_theme_textdomain( 'codemaster' );

    /**
     * Add default posts and comments RSS feed links to <head>.
     */
    add_theme_support( 'automatic-feed-links');

    add_theme_support( 'custom-header' );
        $defaults = array(
        'default-color'          => 'ffffff',
        'default-image'          => '',
        'default-repeat'         => 'repeat',
        'default-position-x'     => 'left',
        'default-position-y'     => 'top',
        'default-size'           => 'auto',
        'default-attachment'     => 'scroll',
        'wp-head-callback'       => '_custom_background_cb',
        'admin-head-callback'    => '',
        'admin-preview-callback' => ''
    );
    add_theme_support( 'custom-background', $defaults);
    // Load regular editor styles into the new block-based editor.
    add_theme_support( 'editor-styles' );
     // Load default block styles.
    add_theme_support( 'wp-block-styles' );
    add_theme_support( 'title-tag' );
    add_theme_support('custom-logo', array(
        'width' => 100,
        'height' => 100,
        'flex-height' => true,
		'flex-width'  => true,
    ));
    add_theme_support( 'html5', array( 'search-form', 'comment-form', 'comment-list', 'gallery', 'caption', 'script', 'style' ) );
    set_post_thumbnail_size( 1200, 9999 );
    add_image_size( 'codemaster-custom-image-size', 830, 400, true );
    add_image_size( 'codemaster-post-image-size', 356, 281, true );
    /**
     * Enable support for post thumbnails and featured images.
     */
    add_theme_support( 'post-thumbnails' );
 
    /**
     * Add support for two custom navigation menus.
     */
    // This theme uses wp_nav_menu() in one location.
        register_nav_menus( array(
            'primary' => esc_html__( 'Primary', 'codemaster'),
            'secondary' => esc_html__( 'Secondary', 'codemaster'),
        ) );
     // Support editor style.
    add_editor_style ( 'style.css' );
    /**
     * Enable support for the following post formats:
     * aside, gallery, quote, image, and video
     */
    add_theme_support( 'post-formats', array( 'aside', 'image', 'gallery', 'video', 'audio', 'quote', 'link', 'status') );
    // Gutenberg.
    add_theme_support( 'editor-styles' );
    add_theme_support( 'align-wide' );
    add_theme_support( 'responsive-embeds' );
    // for woocommerce website
    add_theme_support( 'woocommerce' );
}
endif; // myfirsttheme_setup
add_action( 'after_setup_theme', 'codemasterwptheme_setup' );

if ( ! function_exists( 'codemasterwptheme_widgets_init') ) :
function codemasterwptheme_widgets_init() {
    
    register_sidebar(
        array(
            'name'          => esc_html__( 'Blog Sidebar', 'codemaster' ),
            'id'            => 'sidebar-1',
            'description'   => esc_html__( 'Add widgets here to appear in your blog.', 'codemaster' ),
            'before_widget' => '<section id="%1$s" class="widget %2$s">',
            'after_widget'  => '</section>',
            'before_title'  => '<h2 class="widget-title">',
            'after_title'   => '</h2>',
        )
    );

	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer First', 'codemaster' ),
			'id'            => 'sidebar-2',
			'description'   => esc_html__( 'Add widgets here to appear in your footer.', 'codemaster' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
    register_sidebar(
        array(
            'name'          => esc_html__( 'Footer Second', 'codemaster' ),
            'id'            => 'sidebar-3',
            'description'   => esc_html__( 'Add widgets here to appear in your footer.', 'codemaster' ),
            'before_widget' => '<section id="%1$s" class="widget %2$s">',
            'after_widget'  => '</section>',
            'before_title'  => '<h2 class="widget-title">',
            'after_title'   => '</h2>',
        )
    );
    register_sidebar(
        array(
            'name'          => esc_html__( 'Footer Third', 'codemaster' ),
            'id'            => 'sidebar-4',
            'description'   => esc_html__( 'Add widgets here to appear in your footer.', 'codemaster' ),
            'before_widget' => '<section id="%1$s" class="widget %2$s">',
            'after_widget'  => '</section>',
            'before_title'  => '<h2 class="widget-title">',
            'after_title'   => '</h2>',
        )
    );
    register_sidebar(
        array(
            'name'          => esc_html__( 'Footer Fourth', 'codemaster' ),
            'id'            => 'sidebar-5',
            'description'   => esc_html__( 'Add widgets here to appear in your footer.', 'codemaster' ),
            'before_widget' => '<section id="%1$s" class="widget %2$s">',
            'after_widget'  => '</section>',
            'before_title'  => '<h2 class="widget-title">',
            'after_title'   => '</h2>',
        )
    );
}
endif;
add_action( 'widgets_init', 'codemasterwptheme_widgets_init' );

if ( ! function_exists( 'codemasterwptheme_enqueue_style' ) && ! is_admin() ) :
function codemasterwptheme_enqueue_style() {
    $theme_version = wp_get_theme()->get( 'Version' );
    wp_enqueue_style( 'codemaster-style', get_stylesheet_uri(), array(), $theme_version );
    wp_style_add_data( 'codemaster-style', 'rtl', 'replace' );
    wp_enqueue_style( 'bts-css',  get_template_directory_uri() .'/assets/css/bootstrap.min.css?v=5.0', false );
    wp_enqueue_style( 'codemaster-css',  get_template_directory_uri() .'/assets/css/codemaster-style.css', array(), $theme_version, false );
    wp_enqueue_style( 'icofont-css',  get_template_directory_uri() .'/icofont/icofont.min.css', false );
}
endif; 
if ( ! function_exists( 'codemasterwptheme_enqueue_script' ) && ! is_admin() ) :
function codemasterwptheme_enqueue_script() {
    wp_enqueue_script( 'codemaster-custom-js', get_template_directory_uri() .'/assets/js/frontend.js',  array ( 'jquery' ), '1.1.5', true );
    wp_enqueue_script( 'bts-js', get_template_directory_uri() .'/assets/js/bootstrap.bundle.min.js', false );
    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
    }
}
endif;  
add_action( 'wp_enqueue_scripts', 'codemasterwptheme_enqueue_style' );
add_action( 'wp_enqueue_scripts', 'codemasterwptheme_enqueue_script' );

/* Standalone Functions.*/
require get_template_directory() . '/inc/extras.php';
/* Theme Option Functions*/
require get_template_directory() . '/inc/theme-options.php';

// add calss in header menu in anchor tag
if ( ! function_exists( 'add_link_atts') ) :
function add_link_atts($atts) {
  $atts['class'] = "nav-link";
  return $atts;
}
endif;
add_filter( 'nav_menu_link_attributes', 'add_link_atts');

if ( ! function_exists( 'wp_body_open' ) ) {
    function wp_body_open() {
        do_action( 'wp_body_open' );
    }
}
// Block Library CSS from WordPress 5.0
add_filter( 'should_load_separate_core_block_assets', '__return_true' );

if ( function_exists( 'register_block_style' ) ) {
    register_block_style(
        'core/quote',
        array(
            'name'         => 'blue-quote',
            'label'        => __( 'Blue Quote', 'codemaster' ),
            'is_default'   => true,
            'inline_style' => '.wp-block-quote.is-style-blue-quote { color: blue; }',
        )
    );
}
if ( ! function_exists( 'codemasterwpdocs_register_block_patterns') ) :
function codemasterwpdocs_register_block_patterns() {
        register_block_pattern(
            'wpdocs/my-codemaster',
            array(
                'title'         => __( 'My First Block Pattern', 'codemaster' ),
                'description'   => _x( 'This is my first block pattern', 'Block pattern description', 'codemaster' ),
                'content'       => '<!-- wp:paragraph --><p>A single paragraph block style</p><!-- /wp:paragraph -->',
                'categories'    => array( 'text' ),
                'keywords'      => array( 'cmt', 'data', 'codemaster' ),
                'viewportWidth' => 800,
            )
        );
}
endif;
add_action( 'init', 'codemasterwpdocs_register_block_patterns' );

if ( ! function_exists( 'codemastertheme_setup_theme_supported_features') ) :
function codemastertheme_setup_theme_supported_features() {
    add_theme_support( 'editor-color-palette', array(
        array(
            'name'  => esc_attr__( 'strong magenta', 'codemaster' ),
            'slug'  => 'strong-magenta',
            'color' => '#a156b4',
        ),
        array(
            'name'  => esc_attr__( 'light grayish magenta', 'codemaster' ),
            'slug'  => 'light-grayish-magenta',
            'color' => '#d0a5db',
        ),
        array(
            'name'  => esc_attr__( 'very light gray', 'codemaster' ),
            'slug'  => 'very-light-gray',
            'color' => '#eee',
        ),
        array(
            'name'  => esc_attr__( 'very dark gray', 'codemaster' ),
            'slug'  => 'very-dark-gray',
            'color' => '#444',
        ),
    ) );
}
endif;
add_action( 'after_setup_theme', 'codemastertheme_setup_theme_supported_features' );

if ( ! function_exists( 'codemaster_skip_link_focus_fix') ) :
function codemaster_skip_link_focus_fix() {
	?>
	<script>
	/(trident|msie)/i.test(navigator.userAgent)&&document.getElementById&&window.addEventListener&&window.addEventListener("hashchange",function(){var t,e=location.hash.substring(1);/^[A-z0-9_-]+$/.test(e)&&(t=document.getElementById(e))&&(/^(?:a|select|input|button|textarea)$/i.test(t.tagName)||(t.tabIndex=-1),t.focus())},!1);
	</script>
<?php
}
endif;
add_action( 'wp_print_footer_scripts', 'codemaster_skip_link_focus_fix' );

// add classes to wp_list_pages in header menu
if ( ! function_exists( 'codemaster_wp_list_pages_filter') ) :
function codemaster_wp_list_pages_filter($output) {
   $output = str_replace('page_item', 'page_item nav-item', $output);
   $output = str_replace('current_page_parent', 'current_page_parent menu-item-has-children', $output);
   $output = str_replace('nav-links_has_children', 'nav-links_has_children menu-item-has-children', $output);
   $output = str_replace('<a ', '<a class="nav-link"', $output);
   $output = str_replace('<ul ', '<ul class="sub-menu"', $output);
  return $output;
}
endif;
add_filter('wp_list_pages', 'codemaster_wp_list_pages_filter');