<?php 
/**
 * The template for displaying the footer.
 *
 * @package codemaster
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

// Get Social link on theme setting page
$user_id = '1';
$codemaster_themeopt_facebook =  get_user_meta( $user_id, 'codemaster_themeopt_facebook', true ); 
$codemaster_themeopt_twitter =  get_user_meta( $user_id, 'codemaster_themeopt_twitter', true ); 
$codemaster_themeopt_instagram =  get_user_meta( $user_id, 'codemaster_themeopt_instagram', true ); 
$codemaster_themeopt_linkedin =  get_user_meta( $user_id, 'codemaster_themeopt_linkedin', true ); 
$codemaster_themeopt_youtube =  get_user_meta( $user_id, 'codemaster_themeopt_youtube', true );
$codemaster_themeopt_pinterest =  get_user_meta( $user_id, 'codemaster_themeopt_pinterest', true );
?>
</main>
<!-- **************** MAIN CONTENT END **************** -->
<footer role="contentinfo" class="bg-light site-footer pt-3" itemscope="" itemtype="https://schema.org/WPFooter">
  <div class="footerblock1">
    <div class="container text-md-start mt-5">
      <!-- Grid row -->
      <div class="row mt-3">
        <!-- Grid column -->
        <div class="col-md-3 col-lg-4 col-xl-3 mb-4">
          <!-- Content -->
          <?php if ( is_active_sidebar( 'sidebar-2' ) ) { ?>
            <div class="sidebar">
                <?php dynamic_sidebar('sidebar-2' ); ?>
            </div>
        <?php } ?>
        </div>
        <!-- Grid column -->
        <!-- Grid column -->
        <div class="col-md-2 col-lg-2 col-xl-2 mx-auto mb-4">
          <!-- Links -->
         <?php if ( is_active_sidebar( 'sidebar-3' ) ) { ?>
            <div class="sidebar">
                <?php dynamic_sidebar('sidebar-3' ); ?>
            </div>
        <?php } ?>
        </div>
        <!-- Grid column -->
        <!-- Grid column -->
        <div class="col-md-3 col-lg-2 col-xl-2 mx-auto mb-4">
          <!-- Links -->
         <?php if ( is_active_sidebar( 'sidebar-4' ) ) { ?>
            <div class="sidebar">
                <?php dynamic_sidebar('sidebar-4' ); ?>
            </div>
        <?php } ?>
        </div>
        <!-- Grid column -->
        <!-- Grid column -->
        <div class="col-md-4 col-lg-3 col-xl-3 mb-md-0 mb-4">
          <!-- Links -->
          <?php if ( is_active_sidebar( 'sidebar-5' ) ) { ?>
            <div class="sidebar">
                <?php dynamic_sidebar('sidebar-5' ); ?>
            </div>
          <?php } ?>
         
        </div>
        <!-- Grid column -->
      </div>
      <!-- Grid row -->
    </div>
  </div>
  <hr>
  <div class="footerblock2 bg-light py-4">
   <div class="container">
       <div class="row">
         <div class="col-md-6">
          <div class="site-info-copyright">
            &copy; <?php echo date('Y'); ?> <a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php  bloginfo( 'name' ); ?></a>
                <a class="text-decoration-none" href="<?php echo esc_url( __( 'https://www.rankwebdevelopers.com/', 'codemaster' ) ); ?>">
                <?php
                _e( 'Codemaster Theme', 'codemaster' );
                ?>
               </a>
           </div>
       </div>
       <div class="col-md-6 d-md-flex align-items-center justify-content-end">
         <ul class="list-inline">
            <?php if(!empty($codemaster_themeopt_facebook)) { ?> 
            <li class="list-inline-item"><a href="<?php echo esc_url($codemaster_themeopt_facebook); ?>" Title="Facebook"><i class="icofont-facebook"></i></a></li>
            <?php }?>
           <?php if(!empty($codemaster_themeopt_twitter)) { ?> 
            <li class="list-inline-item"><a href="<?php echo esc_url($codemaster_themeopt_twitter); ?>" Title="Twitter"><i class="icofont-twitter"></i></a></li>
            <?php }?>
            <?php if(!empty($codemaster_themeopt_instagram)) { ?> 
            <li class="list-inline-item"><a href="<?php echo esc_url($codemaster_themeopt_instagram); ?>" Title="Instagram"><i class="icofont-instagram"></i></a></li>
            <?php }?>
            <?php if(!empty($codemaster_themeopt_linkedin)) { ?> 
            <li class="list-inline-item"><a href="<?php echo esc_url($codemaster_themeopt_linkedin); ?>" Title="Linkedin"><i class="icofont-linkedin"></i></a></li>
            <?php }?>
             <?php if(!empty($codemaster_themeopt_youtube)) { ?> 
            <li class="list-inline-item"><a href="<?php echo esc_url($codemaster_themeopt_youtube); ?>" Title="Youtube"><i class="icofont-youtube-play"></i></a></li>
            <?php }?>
            <?php if(!empty($codemaster_themeopt_pinterest)) { ?> 
            <li class="list-inline-item"><a href="<?php echo esc_url($codemaster_themeopt_pinterest); ?>" Title="Pinterest"><i class="icofont-pinterest"></i></a></li>
            <?php }?>
        </ul>
       </div>
       </div>
    </div>
  </div>
</footer>
<a href="#" id="page-scroll-top" class="ct-scroll-top off"><i class="icofont-arrow-up"></i></a>
<div class="popupsearchform">
    <div id="myOverlay" class="overlay">
      <span class="closebtn" onclick="closeSearch()" title="Close Overlay">×</span>
      <div class="overlay-content">
        <form method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>">
          <input type="search" placeholder="Search.." name="s">
          <button type="submit"><i class="icofont-search"></i></button>
        </form>
      </div>
    </div>
</div>
<?php wp_footer(); ?>
</body>
</html>