<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
get_header(); ?>
<section class="pagecontent">
	<div class="ranking_page_banner">
	  	<div class="container">
	   <header class="page-header text-white">
		  <?php
		  the_archive_title( '<h1 class="page-title">', '</h1>' );
		  the_archive_description( '<div class="archive-description">', '</div>' );
		  ?>
	  </header>
	  <div class="doemaster-breadcrum">
	       <?php  if (function_exists('codemaster_breadcrumbs'))  codemaster_breadcrumbs();  ?>
	   </div>
	  </div>
	</div>
</section>
<section class="singlepage py-5">
  <div class="container">
  <div class="row content-row gx-5">
   <div class="content-area content-has-sidebar float-left col-xl-8 col-lg-8 col-md-12 col-sm-12">
  <div class="archive-site-content">
    <?php
    if ( have_posts() ) :
      while ( have_posts() ) :
        the_post();
        ?>
        <article <?php post_class(); ?>>
		  <div class="border rounded post-thumbnail-responsive">
			<?php if(has_post_thumbnail()){ the_post_thumbnail( 'codemaster-custom-image-size' ); } else {
                echo '<img alt="Image not found" src="' . esc_url(get_stylesheet_directory_uri()). '/assets/images/not-found.webp" />';
                }  ?>
			</div>
          <header class="entry-header">
			<?php sanitize_title(the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '">', '</a></h2>' )); ?>
          </header><!-- entry-header -->
          <div class="entry-content">
            <?php wp_strip_all_tags(the_content( esc_html__( 'Continue reading &rarr;', 'codemaster' ) )); ?>
          </div><!-- entry-content -->
        </article><!-- #post-## -->
        <?php
          endwhile;
    	  the_posts_navigation();
        else :
          get_template_part( 'content-none' );
        endif;
    	?>
	</div><!-- site-content -->
   </div>
   <aside id="secondary" role="complementary" class="widget-area widget-has-sidebar sidebar-codemaster col-xl-4 col-lg-4 col-md-12 col-sm-12 mb-4">
		  <div class="sidebar-fixed-inner sticky-top">
		    <?php get_sidebar(); ?>
	     </div>
	</aside>
  </div>
  </div>
</section>
<?php get_footer(); ?>