<?php
/**
* The template for displaying the 404 template in the codemaster theme.
*/
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
get_header(); ?>
<div class="page-404">
	<div id="container text-center text-md-start mt-5">
		<div id="content" role="main">
		    <div class="mx-auto" style="max-width: 620px;">
			<div id="post-0" class="post error404 not-found">
			    <h2 class="display-1"><?php _e( '404', 'codemaster' ); ?></h2>
				<h1 class="entry-title text-muted"><?php _e( 'Not Found', 'codemaster' ); ?></h1>
				<div class="entry-content">
					<p><?php _e( 'Apologies, but the page you requested could not be found. Perhaps searching will help.', 'codemaster' ); ?></p>
					<?php get_search_form(); ?>
				</div><!-- .entry-content -->
			</div><!-- #post-0 -->
			</div>
		</div><!-- #content -->
	</div><!-- #container -->
</div>
<?php get_footer(); ?>