<?php get_header(); ?>
	
	<?php if (have_posts()) : ?>
	
	<div class="archive-box">
		
		<?php
			if ( is_day() ) :
				esc_html_e( '<span>Daily Archives</span>', 'clickright-lite' );
				/* translators: date day */
				printf( esc_html__( '<h1>%s</h1>', 'clickright-lite' ), get_the_date() );

			elseif ( is_month() ) :
				esc_html_e( '<span>Monthly Archives</span>', 'clickright-lite' );
				/* translators: date month */
				printf( esc_html__( '<h1>%s</h1>', 'clickright-lite' ), get_the_date( _x( 'F Y', 'monthly archives date format', 'clickright-lite' ) ) );

			elseif ( is_year() ) :
				esc_html_e( '<span>Yearly Archives</span>', 'clickright-lite' );
				/* translators: date year */
				printf( esc_html__( '<h1>%s</h1>', 'clickright-lite' ), get_the_date( _x( 'Y', 'yearly archives date format', 'clickright-lite' ) ) );

			else :
				esc_html_e( '<h1>Archives</h1>', 'clickright-lite' );

			endif;
		?>
		
	</div>
	
	<div class="container cl_sidebar">
	
	<div id="main">
	
		<ul class="clickright-lite-grid">
	
		<?php while (have_posts()) : the_post(); ?>
							
			<?php get_template_part('template-parts/content'); ?>
				
		<?php endwhile; ?>
		
		</ul>
		
		<?php
		the_posts_pagination( array(
            'prev_text' => '<div class="older">' . __( 'Previous page', 'clickright-lite' ) . '</div>',
            'next_text' => '<div class="newer">' . __( 'Next page', 'clickright-lite' ) . '</div>',
        ) );
		?>
		
		<?php endif; ?>
		
	</div>
	
<?php get_sidebar(); ?>
<?php get_footer(); ?>