<?php
/**
 * Template part for displaying single post
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package clearex
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class('clearex-post-article'); ?>>
	<?php clearex_post_thumbnail(); ?>
	<div class="clearex-post-content-wrapper single-page">
	<header class="entry-header">
		<?php
			the_title( '<h1 class="entry-title">', '</h1>' );
		if ( 'post' === get_post_type() ) :
			?>
			<div class="entry-meta">
				<?php
				clearex_posted_on();
				clearex_posted_by();
				?>
			</div><!-- .entry-meta -->
		<?php endif; ?>
	</header><!-- .entry-header -->

	<div class="entry-content">
		<?php 
			the_content();
		
		wp_link_pages( array(
			'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'clearex' ),
			'after'  => '</div>',
		) );
		?>
	</div><!-- .entry-content -->

	<footer class="entry-footer">
		<?php clearex_entry_footer(); ?>
	</footer><!-- .entry-footer -->
	</div>
</article><!-- #post-<?php the_ID(); ?> -->
