<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package clearex
 */
$thumbnail_id = get_post_thumbnail_id( get_the_ID());
$thumbnail_alt = get_post_meta($thumbnail_id, '_wp_attachment_image_alt', true);
?>

<article id="post-<?php the_ID(); ?>" <?php post_class('clearex-post-article'); ?>>

	<div class="clearex-post-thumbnail-wrapper">
			<a class="post-thumbnail" href="<?php the_permalink(); ?>" aria-hidden="true" tabindex="-1">
			<?php if(Clearex_get_attachments()):?>
			<img src="<?php echo Clearex_get_attachments()?>" alt="<?php esc_attr($thumbnail_alt);?>">
			<?php endif;?>
			</a>
		</div>
	<div class="clearex-post-content-wrapper">
	<header class="entry-header">
		<?php
		if ( is_singular() ) :
			the_title( '<h1 class="entry-title">', '</h1>' );
		else :
			the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
		endif;

		if ( 'post' === get_post_type() ) :
			?>
			<div class="entry-meta">
				<?php
				clearex_posted_on();
				clearex_posted_by();
				?>
			</div><!-- .entry-meta -->
		<?php endif; ?>
	</header><!-- .entry-header -->

	<div class="entry-content">
		<?php
		if(!is_singular( )):
			the_excerpt();
			printf("<a href='%s' class='readmore-btn'>%s</a>",esc_url(get_the_permalink()), esc_html__('Read More','clearex'));
			?>
		<?php else:
			the_content( sprintf(
			wp_kses(
				/* translators: %s: Name of current post. Only visible to screen readers */
				__( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'clearex' ),
				array(
					'span' => array(
						'class' => array(),
					),
				)
			),
			get_the_title()
		) );
		endif;	
		
		wp_link_pages( array(
			'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'clearex' ),
			'after'  => '</div>',
		) );
		?>
	</div><!-- .entry-content -->

	<footer class="entry-footer">
		<?php clearex_entry_footer(); ?>
	</footer><!-- .entry-footer -->
	</div>
</article><!-- #post-<?php the_ID(); ?> -->
