<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package clearex
 */

get_header();
?>

	<section id="primary" class="content-area col-dblock clerex-page-content archives-page <?php do_action( 'clearex_get_primary_content_width')?>">
		<main id="main" class="site-main">

		<?php if ( have_posts() ) : ?>

			<header class="search-page-header">
				<h1 class="search-page-title">
					<?php
					/* translators: %s: search query. */
					printf( esc_html__( 'Search Results for: %s', 'clearex' ), '<span>' . get_search_query() . '</span>' );
					?>
				</h1>
			</header><!-- .page-header -->

			<?php
			/* Start the Loop */
			while ( have_posts() ) :
				the_post();

				/**
				 * Run the loop for the search to output the results.
				 * If you want to overload this in a child theme then include a file
				 * called content-search.php and that will be used instead.
				 */
				do_action( 'clarex_get_blog_layout' );

			endwhile;

			clearex_pagination();

		else :

			get_template_part( 'template-parts/content', 'none' );

		endif;
		?>

		</main><!-- #main -->
	</section><!-- #primary -->

<?php
get_sidebar();
get_footer();
