<?php
/**
 * Custom template tags for this theme
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package clearex
 */

if ( ! function_exists( 'clearex_posted_on' ) ) :
	/**
	 * Prints HTML with meta information for the current post-date/time.
	 */
	function clearex_posted_on() {
		$time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
		if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
			$time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time><time class="updated" datetime="%3$s">%4$s</time>';
		}

		$time_string = sprintf( $time_string,
			esc_attr( get_the_date( DATE_W3C ) ),
			esc_html( get_the_date() ),
			esc_attr( get_the_modified_date( DATE_W3C ) ),
			esc_html( get_the_modified_date() )
		);

		$posted_on = sprintf(
			/* translators: %s: post date. */
			esc_html_x( 'Posted on %s', 'post date', 'clearex' ),
			'<a href="' . esc_url( get_permalink() ) . '" rel="bookmark">' . $time_string . '</a>'
		);

		echo '<span class="posted-on">' . $posted_on . '</span>'; // WPCS: XSS OK.

	}
endif;

if ( ! function_exists( 'clearex_posted_by' ) ) :
	/**
	 * Prints HTML with meta information for the current author.
	 */
	function clearex_posted_by() {
		$byline = sprintf(
			/* translators: %s: post author. */
			esc_html_x( ' by %s', 'post author', 'clearex' ),
			'<span class="author vcard"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( get_the_author() ) . '</a></span>'
		);

		echo '<span class="byline"> ' . $byline . '</span>'; // WPCS: XSS OK.

	}
endif;

if ( ! function_exists( 'clearex_entry_footer' ) ) :
	/**
	 * Prints HTML with meta information for the categories, tags and comments.
	 */
	function clearex_entry_footer() {
		// Hide category and tag text for pages.
		if ( 'post' === get_post_type() ) {
			/* translators: used between list items, there is a space after the comma */
			$categories_list = get_the_category_list( esc_html__( ', ', 'clearex' ) );
			if ( $categories_list ) {
				/* translators: 1: list of categories. */
				printf( '<span class="cat-links">' . esc_html__( 'Posted in %1$s', 'clearex' ) . '</span>', $categories_list ); // WPCS: XSS OK.
			}

			/* translators: used between list items, there is a space after the comma */
			$tags_list = get_the_tag_list( '', esc_html_x( ', ', 'list item separator', 'clearex' ) );
			if ( $tags_list ) {
				/* translators: 1: list of tags. */
				printf( '<span class="tags-links">' . esc_html__( 'Tagged %1$s', 'clearex' ) . '</span>', $tags_list ); // WPCS: XSS OK.
			}
		}

		if ( ! is_single() && ! post_password_required() && ( comments_open() || get_comments_number() ) ) {
			echo '<span class="comments-link">';
			comments_popup_link(
				sprintf(
					wp_kses(
						/* translators: %s: post title */
						__( 'Leave a Comment<span class="screen-reader-text"> on %s</span>', 'clearex' ),
						array(
							'span' => array(
								'class' => array(),
							),
						)
					),
					get_the_title()
				)
			);
			echo '</span>';
		}

		edit_post_link(
			sprintf(
				wp_kses(
					/* translators: %s: Name of current post. Only visible to screen readers */
					__( 'Edit <span class="screen-reader-text">%s</span>', 'clearex' ),
					array(
						'span' => array(
							'class' => array(),
						),
					)
				),
				get_the_title()
			),
			'<span class="edit-link">',
			'</span>'
		);
	}
endif;

if ( ! function_exists( 'clearex_post_thumbnail' ) ) :
	/**
	 * Displays an optional post thumbnail.
	 *
	 * Wraps the post thumbnail in an anchor element on index views, or a div
	 * element when on single views.
	 */
	function clearex_post_thumbnail() {
		if ( post_password_required() || is_attachment() || ! has_post_thumbnail() ) {
			return;
		}

		if ( is_singular() ) :
			?>

			<div class="clerex-post-thumbnail-single-post">
				<div class="post-thumbnail">
					<?php the_post_thumbnail('clearex-post-thumb'); ?>
				</div><!-- .post-thumbnail -->
			</div>

		<?php else : ?>

		<div class="clearex-post-thumbnail-wrapper">
			<a class="post-thumbnail" href="<?php the_permalink(); ?>" aria-hidden="true" tabindex="-1">
				<?php
				the_post_thumbnail( 'clearex-post-thumb', array(
					'alt' => the_title_attribute( array(
						'echo' => false,
					) ),
				) );
				?>
			</a>
		</div>

		<?php
		endif; // End is_singular().
	}
endif;
/*
 * Pagination Function. Implements core paginate_links function.
 */
if(!function_exists('clearex_pagination')):
	function clearex_pagination() {
		global $wp_query;
		$big = 12345678;
		$page_format = paginate_links( array(
			'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
			'format' => '?paged=%#%',
			'current' => max( 1, get_query_var('paged') ),
			'total' => $wp_query->max_num_pages,
			'type'  => 'array'
		) );
		if( is_array($page_format) ) {
					$paged = ( get_query_var('paged') == 0 ) ? 1 : get_query_var('paged');
					echo '<div class="pagination"><div class="clearex-pagination-wrapper"><ul>';
					echo '<li><span>'. esc_html($paged) . esc_html__(' of ','clearex') . esc_html($wp_query->max_num_pages) .'</span></li>';
					foreach ( $page_format as $page ) {
							echo "<li>".wp_kses_post($page)."</li>";
					}
				echo '</ul></div></div>';
		}
	}
endif;
/**
 * Clearex Related Post 
 * @pakage Clerex
 * */
if(!function_exists('Clearex_related_post')):
	function Clearex_related_post(){
		global $post;

		$taxonomy = 'cat';
		$numberRelated = 6;
		$args = array();
		if( $taxonomy == 'tag' ){

			$tags = wp_get_post_tags( $post->ID);
			$arr_tags = array();
			foreach( $tags as $tag ){
				array_push( $arr_tags , $tag->term_id );
			}
			if( ! empty($arr_tags)){
				$args = array(
					'tag__in' => $arr_tags,
					'post__not_in' => array($post->ID),
					'post_per_page' => $numberRelated
				);
			}
		}else{
			$args = array(
				'cateogry__in' => wp_get_post_categories( $post->ID ),
				'posts_per_page' => $numberRelated,
				'post__not_in' => array($post->ID)
			);
		}

		if( !empty($args) ){
			$posts = get_posts($args);
			if($posts):
				$thumbnail_id = get_post_thumbnail_id( $post->ID );
				$thumbnail_alt = get_post_meta($thumbnail_id, '_wp_attachment_image_alt', true);
				?>
				<div class="clearex-related-post">
					<div class="header-area">
						<h3 class="title"><?php echo esc_html__( 'Related Post', 'clearex')?></h3>
					</div>
						<div class="col-lg-12 remove-col-padding">
							<div class="related-post-wrapper">
								<div class="row">
								<?php foreach($posts as $post): ?>
									<div class="col-lg-4">
										<div class="single-related-post">
											<?php if(has_post_thumbnail( $post->ID )):?>
											<div class="thumb">
												<a href="<?php the_permalink( $post->ID )?>"><img src="<?php the_post_thumbnail_url( 'clearex-related-thumb' )?>" alt="<?php esc_attr($thumbnail_alt)?>"></a>
											</div>
											<?php else:?>
											<div class="thumb">
												<a href="<?php the_permalink( $post->ID )?>"><img src="<?php echo esc_url( get_template_directory_uri() )?>/assets/img/noimage.jpg" alt="<?php esc_attr($thumbnail_alt)?>"></a>
											</div>
											<?php endif?>
											<div class="content">
												<a href="<?php the_permalink( $post->ID )?>"><h4 class="title"><?php the_title($post->ID);?></h4></a>
											</div>
										</div>
									</div>
								<?php endforeach; wp_reset_query()?>
								</div>
							</div>
						</div>
					</div>
			<?php endif;	
		}
	}
endif;	

if(!function_exists('clearex_comment')):
	function clearex_comment($comment, $args, $depth){
//		$GLOBALS['comment'] = $comment;

		if( 'pingback' == $comment->comment_type || 'trackback' == $comment->comment_type ):?>
		<li>
			<div class="comment-body">
				<?php esc_html_e('Pingback:','clearex')?> <?php comment_author_link()?><?php  edit_comment_link( __('Edit','clearex'), '<span class="edit-link">', '</span>' ) ?>
			</div>
		<?php else:?>
			<li id="comment-<?php comment_ID();?>" <?php comment_class( empty ( $args['has_children']) ? '' : 'parent' ) ?> >
			<article id="div-comment-<?php comment_ID() ?>" class="comment-body row">
				<footer class="comment-meta">
					<div class="comment-author vcard "><!-- comment-author --> 
						<?php if(0 != $args['avatar_size']) echo get_avatar( $comment, 80 ) ?>
					</div> <!-- //.comment-author --> 
					<div class="comment-metadata"><!-- comment metadata --> 
						<?php printf('%s',sprintf('<cite class="fn">%s</cite>',esc_url(get_comment_author_link())))?>
						<a href="<?php echo esc_url( get_comment_link( $comment->comment_ID ) ) ?>">
							<time datetime="<?php comment_time('c');?>">
								<?php get_comment_date('M j Y') ?>
							</time>
						</a>
					</div><!-- //.comment metadata --> 
					<?php if( '0' == $comment->comment_approved ):?>
					<span class="comment-awaitiong-moderation"><?php esc_html_e('Your Comment is Awaiting Moderation','clearex')?></span>
					<?php endif;?>
				</footer>
				<div class="comment-content">
					<?php comment_text(); ?>
					<?php 
						comment_reply_link( array_merge($args,array(
							'add_below' => 'div-comment',
							'depth' => $depth,
							'max_depth' => $args['max_depth'],
							'before' => '<div class="reply">',
							'after' => '</div>'
						)));
					?>
					<?php edit_comment_link( __('edit','clearex'), '<span class="edit-link">', '</span>' );?>
				</div>
			</article>
		<?php endif;	
	}
endif;	