<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package clearex
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function clearex_body_classes( $classes ) {
	// Adds a class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$classes[] = 'hfeed';
	}

	// Adds a class of no-sidebar when there is no sidebar present.
	if ( ! is_active_sidebar( 'sidebar-1' ) ) {
		$classes[] = 'no-sidebar';
	}

	return $classes;
}
add_filter( 'body_class', 'clearex_body_classes' );

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
function clearex_pingback_header() {
	if ( is_singular() && pings_open() ) {
		echo '<link rel="pingback" href="', esc_url( get_bloginfo( 'pingback_url' ) ), '">';
	}
}
add_action( 'wp_head', 'clearex_pingback_header' );
/**
 * get content for supportbar left content from customzier option
 * **/
if(!function_exists('clearex_get_left_content')):
	function clearex_get_left_content(){
		$content_markup = '<ul>';
		for($i = 1; $i <= 3; $i++):
			
			if(get_theme_mod('clearex_social_left_content_'.$i) != 'none' && get_theme_mod('clearex_social_left_content_'.$i) != '' && get_theme_mod( 'clearex_social_left_content_url_'.$i ) != '' && get_theme_mod( 'clearex_social_left_content_text_'.$i )):
				if(get_theme_mod('clearex_social_left_content_'.$i) == 'phone'){
					$content_markup .= '<li><a href="tel:'. esc_attr( Clearex_phone_number(get_theme_mod('clearex_social_left_content_url_'.$i)) ).'"><i class="fas fa-phone"></i> '.esc_html(get_theme_mod( 'clearex_social_left_content_text_'.$i )).'</a></li>';
				}elseif(get_theme_mod('clearex_social_left_content_'.$i) == 'email'){
					$content_markup .= '<li><a href="mailto:'.esc_attr(get_theme_mod('clearex_social_left_content_url_'.$i)).'"><i class="fas fa-envelope"></i> '.esc_html(get_theme_mod( 'clearex_social_left_content_text_'.$i )).'</a></li>';
				}else{
					$content_markup .= '<li><i class="fas fa-map-marker-alt"></i> '.esc_html(get_theme_mod( 'clearex_social_left_content_text_'.$i )).'</li>';
				}
			endif;    
		endfor;    
		$content_markup .= '</ul>';
		return $content_markup ;
	}
endif;	

/**
 * clearex get footer copyright text
 * **/
if (!function_exists('Clearex_footer_text')){
	function Clearex_footer_text(){
		$copyright_text = get_theme_mod('clearex_custom_footer_setting');
		if( $copyright_text == '' ){
			return '&copy; '. date('Y'). __(' All Right Reserved By ','clearex').get_bloginfo('name');
		}else{
			return esc_html($copyright_text);
		}
	}
}

/***
 * clearex get video post format 
 * */
if(!function_exists('Clearex_get_embedded_media')){
	function Clearex_get_embedded_media($type = array()){
		$content = do_shortcode( apply_filters( 'the_content', get_the_content() ));
		$embed = get_media_embedded_in_content($content,$type);
		$output = '';
		if(in_array('audio',$type)){
			if(!empty($embed)){
				$output .= str_replace('?visual=true','?visual=false',$embed[0]);
			}
			
		}else{
			if(!empty($embed)){
				$output .= $embed[0];
			}
		}
		return $output;
	}
}

/***
 * clearex get attachment for gallery format
 * */
if(!function_exists('Clearex_get_attachments')){
	function Clearex_get_attachments($num = 1){
	  $output = '';
    if (has_post_thumbnail() && $num == 1):
		$output = esc_url(wp_get_attachment_url(get_post_thumbnail_id(get_the_ID())));
	else:
        $attachments = get_posts(array(
            'post_type' => 'attachment',
            'posts_per_page' => $num,
            'post_parent' => get_the_ID(),
        ));
    if ($attachments && $num == 1):
            foreach ($attachments as $attachment):
				$thumb = wp_get_attachment_image_src($attachment->ID,'clearex-post-thumb');
				$output = esc_url($thumb[0]);
	endforeach; 
	elseif ($attachments && $num > 1):
            $output = $attachments;
    endif;
    wp_reset_postdata();
    endif;
    return $output;
	}
}

/***
 * clearex get images for gallery post slider
 * */

function clearex_get_bs_slides( $attachments)
{
	$output = array();
	if(is_array($attachments)){
		$count = count($attachments) - 1;
		for ($i = 0; $i <= $count; ++$i):
			$active = ($i == 0 ? ' active' : '');
		$n = ($i == $count ? 0 : $i + 1);
		$nextImg = esc_url(wp_get_attachment_thumb_url($attachments[$n]->ID));
		$p = ($i == 0 ? $count : $i - 1);
		$prevImg = esc_url(wp_get_attachment_thumb_url($attachments[$p]->ID));
		$output[$i] = array(
				'class' => $active,
				'url' => esc_url(wp_get_attachment_url($attachments[$i]->ID)),
				'next_img' => $nextImg,
				'prev_img' => $prevImg,
				'caption' => $attachments[$i]->post_excerpt,
			);
		endfor;
	}
    
    return $output;
}
/***
 * clearex get link post format url
 * */

 if(!function_exists('Clearex_grab_url')){
	 function Clearex_grab_url(){
		if(!preg_match('/<a\s[^>]*?href=[\'"](.+?)[\'"]/i',get_the_content(),$links)){
			return false;
		}
		return esc_url_raw($links[1] );
	 }
 }
 /**
  * This function is responsible blog layout 
  **/

if( !function_exists('clearex_get_blog_layout') ){
	function clearex_get_blog_layout(){
		$location = 'template-parts/content';
		if(get_theme_mod( 'clearex_blog_layout' )){
			$layout = esc_attr(get_theme_mod( 'clearex_blog_layout' ));
			if( $layout == 'clearex'){
				get_template_part( $location , get_post_format());
			}else{
				get_template_part( $location, 'grid');
			}
		}else{
			get_template_part( $location, get_post_format());
		}
	}
	add_action('clarex_get_blog_layout','clearex_get_blog_layout');
}

/**
 * Filter the excerpt length to 300 characters.
 *
 * @param int $length Excerpt length.
 * @return int (Maybe) modified excerpt length.
 */
if (!function_exists('clearex_excerpt_length')){
	function clearex_excerpt_length( $length ) {
		return 100;
	}
	add_filter( 'excerpt_length', 'clearex_excerpt_length');
}



