<?php
/**
 * Clearex custom recent post item
 * **/
class Clearex_recent_post_widget extends WP_Widget 
{
    public function __construct(){
        parent::__construct(
            'clearex_recent_post',
	        esc_html__( 'Clearex Recent Posts with Thumbnails','clearex' ),
            array( 'description' => esc_html__('Display your recent posts, with a thumbnail.','clearex') )
        );
    }
    public function widget($args, $instance){
        if(isset($instance['title'])):
            $title = apply_filters( 'widget_title', $instance['title'] );
            $no_of_posts = apply_filters( 'no_of_posts', $instance['no_of_posts'] );
        else:
            $title = esc_html__('Recent Posts','clearex');
            $no_of_posts = 5;
        endif;
        echo wp_kses_post($args['before_widget']);
        if( ! empty($title) ){
            echo wp_kses_post($args['before_title'] ). esc_html($title) . wp_kses_post($args['after_title']);
        }        

        //WP_Query argument
        $qargs = array(
            'post_type' => 'post',
            'posts_per_page' => $no_of_posts,
            'offset' => 0,
            'ignore_sticky_posts' => 1
        );
        $recent_articles = new WP_Query($qargs);
        //have to write code for displing query data
        if($recent_articles->have_posts() ):?>
        <ul class="recent_post_wrapper">
        <?php  while($recent_articles->have_posts()): $recent_articles->the_post();?>
           <li class="recent-post-item">
                <?php if(has_post_thumbnail()): ?>
                    <div class="thumb">
                        <a href="<?php the_permalink()?>">
                            <img src="<?php the_post_thumbnail_url( 'thumbnail' ) ?>" alt="<?php the_title_attribute()?>">
                        </a>
                    </div>
                <?php else: ?>
                <div class="thumb">
                        <a href="<?php  the_permalink() ?>">
                            <img src="<?php echo esc_url(get_template_directory_uri()) .'/assets/img/noimage-80x80.jpg' ?>" alt="<?php the_title_attribute()?>">
                        </a>
                    </div>
                <?php endif; ?>
                <div class="content">
                    <a href="<?php the_permalink() ?>"><h4 class="title"><?php the_title();?></h4></a>
                    <span class="meta-date"><?php the_time('M j,Y')?></span>
                </div>
           </li>
        <?php
        endwhile;
        else:
            esc_html__(' Oops, there are no posts.','clearex')
            ?>

            <?php endif;?>
        </ul>
        <?php 
        echo wp_kses_post($args['after_widget']);
    }
    public function form($instance){
        //have to create form instance
        if(!empty($instance) && $instance['title']){
            $title =apply_filters( 'widget_title', $instance['title'] );
        }else{
            $title = esc_html__('Recent Posts','clearex');
        }
        if(!empty($instance) && $instance['no_of_posts']){
            $no_of_posts = apply_filters( 'no_of_posts', $instance['no_of_posts'] );
        }else{
            $no_of_posts = esc_html__('5','clearex');
        }
        ?>
        <p>

            <label for="<?php echo esc_attr($this->get_field_id('title'));?>"><?php esc_html_e('Title:','clearex');?></label>
            <input type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id('title'))?>" name="<?php echo esc_attr($this->get_field_name('title'));?>" value="<?php echo esc_attr( $title ) ?>" >

            <label for="<?php echo esc_attr($this->get_field_id('no_of_posts'))?>"><?php esc_html_e('No Of Posts','clearex');?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'no_of_posts' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'no_of_posts' )); ?>" type="text" value="<?php echo esc_attr( $no_of_posts ); ?>" />
        
        </p>
        <?php
    }
    public function update($new_instance,$old_instance){
        $instance = array();
        $instance['title'] = ( !empty($new_instance['title']) ? sanitize_text_field($new_instance['title']) : '' );
        $instance['no_of_posts'] = (!empty($new_instance['no_of_posts']) ? absint($new_instance['no_of_posts']) : '');
        if ( is_numeric($new_instance['no_of_posts']) == false ) {
			$instance['no_of_posts'] = $old_instance['no_of_posts'];
			}
		return $instance;
    }
}
/**
 * Clearex Recent post widget register
 * **/
if(!function_exists('clearex_register_recent_posts_widget')){

    function clearex_register_recent_posts_widget(){
        register_widget( 'Clearex_recent_post_widget' );
    }
    
    add_action( 'widgets_init','clearex_register_recent_posts_widget' );

}