<?php

/**
 * header social icon setting for customizer
 * */

 if(!function_exists('Clearex_social_icon_sets')):
    function Clearex_social_icon_sets($customizer){
        $customizer->add_section('clearex_social_icons_set',array(
            'title' => esc_html__('Social Icons','clearex'),
            'priority' => 90,
            'panel' => 'clearex_header_panel'
        ));

        $social_list = array(
            'none' => esc_html__('-','clearex'),
            'facebook-f' => esc_html__('Facebook','clearex'),
            'twitter' => esc_html__('Twitter','clearex'),
            'linkedin-in' => esc_html__('Linkedin','clearex'),
            'instagram' => esc_html__('Instagram','clearex'),
            'gitlab' => esc_html__('Gitlab','clearex'),
            'google-plus-g' => esc_html__('Google Plus','clearex'),
            'pinterest-p' => esc_html__('pinterest','clearex'),
            'vimeo-v' => esc_html__('Viemo','clearex'),
            'youtube' => esc_html__('Youtube','clearex'),
            'behance' => esc_html__('Behance','clearex'),
            'dribbble' => esc_html__('Dribbble','clearex'),
            'github' => esc_html__('Github','clearex'),
            'skype' => esc_html__('Skype','clearex'),
            'tumblr' => esc_html__('Tumblr','clearex'),
        );
        $social_value_list = array(
            'none',
            'facebook-f',
            'twitter',
            'linkedin-in',
            'instagram',
            'gitlab',
            'google-plus-g',
            'pinterest-p',
            'vimeo-v',
            'youtube',
            'behance',
            'dribbble',
            'github',
            'skype',
            'tumblr'
        );
        for( $i = 1; $i <= count($social_list) - 8; $i++ ):

            $customizer->add_setting('clearex_social_icon_'.$i,array(
                'sanitize_callback' => 'clearex_social_icon_sanitize',
                'default' => 'none'
            ));
            $customizer->add_control('clearex_social_icon_'.$i,array(
                'label' => esc_html__('Social Icon ','clearex').$i,
                'section' => 'clearex_social_icons_set',
                'settings' => 'clearex_social_icon_'.$i,
                'type' => 'select',
                'choices' =>$social_list
            ));
            $customizer->add_setting('clearex_social_url_'.$i ,array(
                'default' => '',
                'sanitize_callback' => 'esc_url_raw'
            ));
            $customizer->add_control('clearex_social_url_'.$i , array(
                'label' => esc_html__('Social Url ','clearex').$i,
                'section' => 'clearex_social_icons_set',
                'settings' => 'clearex_social_url_'.$i,
                'type' => 'url'
            ));

        endfor;
        
        function clearex_social_icon_sanitize($value){
            if(in_array($value,array('none','facebook-f','twitter','linkedin-in','instagram','gitlab','google-plus-g','pinterest-p','vimeo-v','youtube','behance','dribbble','github','skype','tumblr'))){
                return $value;
            }else{
                return '';
            }
        }
    }
    add_action( 'customize_register', 'Clearex_social_icon_sets' );
 endif;    