<?php
/**
 * clearex Theme Customizer
 *
 * @package clearex
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function clearex_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial( 'blogname', array(
			'selector'        => '.site-title a',
			'render_callback' => 'clearex_customize_partial_blogname',
		) );
		$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
			'selector'        => '.site-description',
			'render_callback' => 'clearex_customize_partial_blogdescription',
		) );
	}
}
add_action( 'customize_register', 'clearex_customize_register' );

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function clearex_customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function clearex_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

/**
 * load individual panel and section for customizer
 **/
require_once get_theme_file_path('/inc/modules/customizer/_sanitize.php') ;
require_once get_theme_file_path('/inc/modules/customizer/_layouts.php');
require_once get_theme_file_path('/inc/modules/customizer/header.php') ;
require_once get_theme_file_path('/inc/modules/customizer/header-image.php') ;
require_once get_theme_file_path('/inc/modules/customizer/social.php');
require_once get_theme_file_path('/inc/modules/customizer/footer.php');


/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function clearex_customize_preview_js() {
	wp_enqueue_script( 'clearex-customizer', get_template_directory_uri() . '/js/customizer.js', array( 'customize-preview' ), '20151215', true );
}
add_action( 'customize_preview_init', 'clearex_customize_preview_js' );
