<?php

/**
* register header area customize option in customizer
* @pakage Clearex
*/

if (!function_exists('clearex_header_customizer_register')) :

  function clearex_header_customizer_register($customizer){
    $customizer->get_section('header_image')->panel = 'clearex_header_panel';

    $customizer->add_panel('clearex_header_panel',array(
        'title' => esc_html__('Header Settings','clearex'),
        'priority' => 10,
        'capability' => 'edit_theme_options'
    ));
    $customizer->add_section('title_tagline',array(
      'title' => esc_html__('Title, Tagline & Logo','clearex'),
      'panel' => 'clearex_header_panel',
      'priority' => 30
    ));
   
    /**
    * Replace header title color with separate title and description color
    * Overide Traverl-site-title-color
    */

    $customizer->add_setting('clearex_header_titlecolor',array(
      'default' => '#eee',
      'sanitize_callback' => 'sanitize_hex_color'
    ));
    $customizer->add_control(
      new WP_Customize_Color_Control(
        $customizer,
        'clearex_header_titlecolor',
        array(
          'label' => esc_html__('Site Title Color','clearex'),
          'section' => 'colors',
          'settings' => 'clearex_header_titlecolor',
          'type' => 'color',
        )));
        $customizer->add_setting('clearex_header_bg_color',array(
          'default' => '#eee',
          'sanitize_callback' => 'sanitize_hex_color'
        ));
      $customizer->add_control(
          new WP_Customize_Color_Control(
          $customizer,
          'clearex_header_bg_color',
          array(
          'label' => esc_html__('Header Background Color','clearex'),
          'section' => 'colors',
          'settings' => 'clearex_header_bg_color',
          'type' => 'color',
      )));

        $customizer->add_setting('clearex_tagline_color',array(
          'default' => '#bfbfbf',
          'sanitize_callback' => 'sanitize_hex_color'
        ));
        $customizer->add_control(
          new WP_Customize_Color_Control(
            $customizer,
            'clearex_tagline_color',
            array(
              'label' => esc_html__('Site Tagline Color','clearex'),
              'section' => 'colors',
              'settings' => 'clearex_tagline_color',
              'type' => 'color'
            )));
        /**
        * Extra settings options for logo area
        */
         $customizer->add_setting('clearex_hide_title_tagline',array(
           'sanitize_callback' => 'clearex_sanitize_checkbox'
         ));
         $customizer->add_control('clearex_hide_title_tagline',array(
           'label' => esc_html__('Hide Title and Tagline','clearex'),
           'section' => 'title_tagline',
           'settings' => 'clearex_hide_title_tagline',
           'type' => 'checkbox'
         ));
         $customizer->add_setting('clearex_logo_below_title_tagline',array(
           'sanitize_callback' => 'clearex_sanitize_checkbox'
         ));
         $customizer->add_control('clearex_logo_below_title_tagline',array(
           'label' => esc_html__('Show Title and Tagline Below Logo','clearex'),
           'section'=>'title_tagline',
           'settings'=>'clearex_logo_below_title_tagline',
           'type' => 'checkbox',
           'active_callback' => 'clearex_title_tagline_visible'
         ));
         function clearex_title_tagline_visible($control){
           $option = $control->manager->get_setting('clearex_hide_title_tagline');
           return $option->value() == false;
        }
        /**
         * support bar area customizer options register
         * */

        
        $customizer->add_section('clearex_support_bar_area',array(
          'title' => esc_html__('Supoort Bar Settings','clearex'),
          'prority' => 40,
          'panel' => 'clearex_header_panel'
        ));
        $customizer->add_setting('clearex_support_bar',array(
          'sanitaize_callback' => 'Clearex_sanitize_checkbox'
        ));
        $customizer->add_control('clearex_support_bar',array(
          'label' => esc_html__('Enable Support Bar','clearex'),
          'section' => 'clearex_support_bar_area',
          'settings' => 'clearex_support_bar',
          'type' => 'checkbox'
        ));
        /**
         * support bar left content options
         * **/
	  $support_list = array(
		  'none' => esc_html__('-','clearex'),
		  'phone' => esc_html__('Phone Number With Icon','clearex'),
		  'email' => esc_html__('Email With Icon','clearex'),
		  'location' => esc_html__('Location With Icon','clearex')
	  );

              $customizer->add_setting('clearex_social_left_content_1',array(
                'sanitize_callback' => 'clearex_social_sanitize',
                'default' => 'none'
              ));
              
              $customizer->add_control('clearex_social_left_content_1',array(
                'label' => esc_html__('Social Left Content 1' ,'clearex'),
                'settings' => 'clearex_social_left_content_1',
                'section' => 'clearex_support_bar_area',
                'type' => 'select',
                'choices' => $support_list,
                'active_callback' => 'Clearex_supporbar_callback'
              ));
              $customizer->add_setting('clearex_social_left_content_text_1',array(
                'sanitize_callback' => 'wp_filter_nohtml_kses'
              ));
              $customizer->add_control('clearex_social_left_content_text_1',array(
                'label' => esc_html__('Left Content Text 1','clearex'),
                'section' => 'clearex_support_bar_area',
                'settings' => 'clearex_social_left_content_text_1',
                'type' => 'text',
                'active_callback' => 'Clearex_supporbar_callback'
              ));
              $customizer->add_setting('clearex_social_left_content_url_1',array(
                'sanitize_callback' => 'wp_filter_nohtml_kses'
              ));
              $customizer->add_control('clearex_social_left_content_url_1',array(
                'label' => esc_html__('Left Content Url 1','clearex'),
                'section' => 'clearex_support_bar_area',
                'settings' => 'clearex_social_left_content_url_1',
                'type' => 'text',
                'active_callback' => 'Clearex_supporbar_callback'
              ));

              //2
              $customizer->add_setting('clearex_social_left_content_2',array(
                'sanitize_callback' => 'clearex_social_sanitize',
                'default' => 'none'
              ));

              $customizer->add_control('clearex_social_left_content_2',array(
                'label' => esc_html__('Social Left Content 2' ,'clearex'),
                'settings' => 'clearex_social_left_content_2',
                'section' => 'clearex_support_bar_area',
                'type' => 'select',
                'choices' => $support_list,
                'active_callback' => 'Clearex_supporbar_callback'
              ));
              $customizer->add_setting('clearex_social_left_content_text_2',array(
                'sanitize_callback' => 'wp_filter_nohtml_kses'
              ));
              $customizer->add_control('clearex_social_left_content_text_2',array(
                'label' => esc_html__('Left Content Text 2','clearex'),
                'section' => 'clearex_support_bar_area',
                'settings' => 'clearex_social_left_content_text_2',
                'type' => 'text',
                'active_callback' => 'Clearex_supporbar_callback'
              ));
              $customizer->add_setting('clearex_social_left_content_url_2',array(
                'sanitize_callback' => 'wp_filter_nohtml_kses'
              ));
              $customizer->add_control('clearex_social_left_content_url_2',array(
                'label' => esc_html__('Left Content Url 2','clearex'),
                'section' => 'clearex_support_bar_area',
                'settings' => 'clearex_social_left_content_url_2',
                'type' => 'text',
                'active_callback' => 'Clearex_supporbar_callback'
              ));

              //3

              $customizer->add_setting('clearex_social_left_content_3',array(
                'sanitize_callback' => 'clearex_social_sanitize',
                'default' => 'none'
              ));

              $customizer->add_control('clearex_social_left_content_3',array(
                'label' => esc_html__('Social Left Content 3' ,'clearex'),
                'settings' => 'clearex_social_left_content_3',
                'section' => 'clearex_support_bar_area',
                'type' => 'select',
                'choices' => $support_list,
                'active_callback' => 'Clearex_supporbar_callback'
              ));
              $customizer->add_setting('clearex_social_left_content_text_3',array(
                'sanitize_callback' => 'wp_filter_nohtml_kses'
              ));
              $customizer->add_control('clearex_social_left_content_text_3',array(
                'label' => esc_html__('Left Content Text 3','clearex'),
                'section' => 'clearex_support_bar_area',
                'settings' => 'clearex_social_left_content_text_3',
                'type' => 'text',
                'active_callback' => 'Clearex_supporbar_callback'
              ));
              $customizer->add_setting('clearex_social_left_content_url_3',array(
                'sanitize_callback' => 'wp_filter_nohtml_kses'
              ));
              $customizer->add_control('clearex_social_left_content_url_3',array(
                'label' => esc_html__('Left Content Url 3','clearex'),
                'section' => 'clearex_support_bar_area',
                'settings' => 'clearex_social_left_content_url_3',
                'type' => 'text',
                'active_callback' => 'Clearex_supporbar_callback'
              ));

         
        function Clearex_supporbar_callback($control){
          $option = $control->manager->get_setting('clearex_support_bar');
          return $option->value() == true;
        }
        function clearex_social_sanitize($value){
          if(in_array($value,array('phone','email','location','text'))){
            return $value;
          }else{
            return '';
          }
        }
        /**
         * customize options register for supporbar search field
         * */
        $customizer->add_setting('clearex_support_search',array(
          'sanitaize_callback' =>'Clearex_sanitize_checkbox'
        ));
        $customizer->add_control('clearex_support_search',array(
          'label' => esc_html__('Enable Seach Form','clearex'),
          'settings' => 'clearex_support_search',
          'section' => 'clearex_support_bar_area',
          'type' => 'checkbox',
          'active_callback' => 'Clearex_supporbar_callback'
        ));

        $customizer->add_setting('clearex_search_width',array(
          'sanitize_callback' => 'Clearex_search_width_sanitize',
          'default' => 4
        ));
        function Clearex_search_width_sanitize($value){
          if(in_array($value,array(3,4,5,6))){
            return $value;
          }else{
            return '';
          }
        }
        $customizer->add_control('clearex_search_width',array(
          'label' => esc_html__('Search Form With','clearex'),
          'section' => 'clearex_support_bar_area',
          'settings' => 'clearex_search_width',
          'active_callback' => 'Clearex_search_width_callback',
          'type' => 'range',
          'input_attrs' => array(
            'min' => 3,
            'max' => 6,
            'step' => 1
          )
          ));

          function Clearex_search_width_callback($control){
            $options = $control->manager->get_setting('clearex_support_search');
            return $options->value() == true;
          }

  }
  add_action('customize_register','clearex_header_customizer_register');


endif;

