<?php
//Settings for Header Image
function clearex_customize_register_header_img( $wp_customize ) {
$wp_customize->add_setting( 'clearex_header_img_style' , array(
    'default'     => 'cover',
    'sanitize_callback' => 'clearex_sanitize_header_img_style'
) );

/* Sanitization Function */
function clearex_sanitize_himg_style( $input ) {
    if (in_array( $input, array('contain','cover') ) )
        return $input;
    else
        return '';
}

$wp_customize->add_control(
    'clearex_header_img_style', array(
    'label' => __('Header Image Arrangement','clearex'),
    'section' => 'header_image',
    'settings' => 'clearex_header_img_style',
    'type' => 'select',
    'choices' => array(
        'contain' => esc_html__('Contain','clearex'),
        'cover' => esc_html__('Cover Completely (Recommended)','clearex'),
    )
) );

$wp_customize->add_setting( 'clearex_header_img_align' , array(
    'default'     => 'center',
    'sanitize_callback' => 'clearex_sanitize_header_img_align'
) );

/* Sanitization Function */
function clearex_sanitize_himg_align( $input ) {
    if (in_array( $input, array('center','left','right') ) )
        return $input;
    else
        return '';
}

$wp_customize->add_control(
    'clearex_header_img_align', array(
    'label' => esc_html__('Header Image Alignment','clearex'),
    'section' => 'header_image',
    'settings' => 'clearex_header_img_align',
    'type' => 'select',
    'choices' => array(
        'center' => esc_html__('Center','clearex'),
        'left' => esc_html__('Left','clearex'),
        'right' => esc_html__('Right','clearex'),
    )
) );

$wp_customize->add_setting( 'clearex_header_img_repeat' , array(
    'sanitize_callback' => 'clearex_sanitize_checkbox'
) );

$wp_customize->add_control(
    'clearex_header_img_repeat', array(
    'label' => esc_html__('Repeat Header Image','clearex'),
    'section' => 'header_image',
    'settings' => 'clearex_header_img_repeat',
    'type' => 'checkbox',
) );

}
add_action( 'customize_register', 'clearex_customize_register_header_img' );