<?php
/**
 * Clearex footer customizer options
 * @pakage Clearex
 * */

 if(!function_exists('Clearex_Footer_options')):
    function Clearex_Footer_options($customizer){

        /**
      * Register custom footer text section and controls
      */
      $customizer->add_panel('clearex_footer_panel',array(
        'title' => esc_html__('Footer Settings','clearex'),
        'priority' => 40,
        'capability' => 'edit_theme_options'
      ));
        $customizer->add_section('custom_footer_text_section',array(
            'title' => esc_html__('Custom Footer Text','clearex'),
            'priority' => 90,
            'panel' => 'clearex_footer_panel',
            'description' => esc_html__('Enter footer copyright text form here','clearex')
        ));
        $customizer->add_setting('clearex_custom_footer_setting',array(
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $customizer->add_control('clearex_custom_footer_setting',array(
            'label' => esc_html__('Custom Footer Text','clearex'),
            'section' => 'custom_footer_text_section',
            'setting' => 'clearex_custom_footer_setting',
            'type' => 'text'
        ));
    }
    add_action( 'customize_register','Clearex_Footer_options' );
 endif;