<?php

/***
 * layout related customizer options
 * @pakage clearex
*/

if (!function_exists('Clearex_Customize_Layout')):
function Clearex_Customize_Layout($customizer){
    $customizer->get_section('colors')->panel = 'clearex_layout_design_panel';
    $customizer->get_section('background_image')->panel = 'clearex_layout_design_panel';

    $customizer->add_panel(
        'clearex_layout_design_panel',array(
        'title' => esc_html__('Layout & Design','clearex'),
        'priority' => 30,
        'capability' => 'edit_theme_options'
    ));
    $customizer->add_section('clearex_blog_design_section',array(
      'title' => esc_html__('Blog Layout','clearex'),
      'priority' => 0,
      'panel' => 'clearex_layout_design_panel'
     ));
     $customizer->add_setting('clearex_blog_layout',array(
       'sanitize_callback' => 'clearex_blog_sanitize',
       'default' => 'clearex'
     ));
    function clearex_blog_sanitize($value){
       if (in_array($value,array('clearex','clearex-grid'))){
         return $value;
      } else {
        return '';
      }
    }
    $customizer->add_control('clearex_blog_layout',array(
      'label' => esc_html__('Blog Layout','clearex'),
      'settings' => 'clearex_blog_layout',
      'section' => 'clearex_blog_design_section',
      'type' => 'select',
      'choices' => array(
        'clearex' => esc_html__('Clearex Theme Layout','clearex'),
        'clearex-grid' => esc_html__('Clearex Grid Layout','clearex')
      )));
      $customizer->add_setting('disabled_realated_post',array(
        'sanitaize_callback' => 'clearex_sanitize_checkbox'
      ));
      $customizer->add_control('disabled_realated_post',array(
        'label' => esc_html__('Disabled Related Post','clearex'),
        'settings' => 'disabled_realated_post',
        'section' => 'clearex_blog_design_section',
        'type' => 'checkbox',
        'default' => true
      ));
      $customizer->add_setting('disabled_post_navigation',array(
        'sanitaize_callback' => 'clearex_sanitize_checkbox'
      ));
      $customizer->add_control('disabled_post_navigation',array(
        'label' => esc_html__('Disabled Post Navigation','clearex'),
        'settings' => 'disabled_post_navigation',
        'section' => 'clearex_blog_design_section',
        'type' => 'checkbox',
        'default' => false
      ));
      /**
      * sidebar layout section register
      */
      $customizer->add_section('sidebar_layout_section',array(
        'title' => esc_html__('Sidebar Layout','clearex'),
        'priority' => 0,
        'panel' => 'clearex_layout_design_panel'
      ));
      $customizer->add_setting('disabled_sidebar_setting',array(
        'sanitaize_callback' => 'clearex_sanitize_checkbox'
      ));
      $customizer->add_control('disabled_sidebar_setting',array(
        'label' => esc_html__('Disabled Sidebar Everywhere','clearex'),
        'settings' => 'disabled_sidebar_setting',
        'section' => 'sidebar_layout_section',
        'type' => 'checkbox',
        'default' => false
      ));
    $customizer->add_setting('disabled_sidebar_frontpage',array(
        'sanitize_callback' => 'clearex_sanitize_checkbox'
      ));

      $customizer->add_control('disabled_sidebar_frontpage',array(
        'label' => esc_html__('Disabled Sidebar In Front Page','clearex'),
        'section' => 'sidebar_layout_section',
        'settings' => 'disabled_sidebar_frontpage',
        'type' => 'checkbox',
        'default' => false
      ));
      $customizer->add_setting('disabled_sidebar_home',array(
        'sanitize_callback' => 'clearex_sanitize_checkbox'
      ));

      $customizer->add_control('disabled_sidebar_home',array(
        'label' => esc_html__('Disabled Sidebar In Home/Blog','clearex'),
        'section' => 'sidebar_layout_section',
        'settings' => 'disabled_sidebar_home',
        'type' => 'checkbox',
        'default' => false
      ));

      $customizer->add_setting('clearex_sidebar_width',array(
        'default' => 4,
        'sanitize_callback' => 'clearex_sidebar_width_sanitize'
      ));
      $customizer->add_control('clearex_sidebar_width',array(
        'label' => esc_html__('Sidebar Width','clearex'),
        'description' => __('Min:25%, Default:33%,Max:40%','clearex'),
        'section' => 'sidebar_layout_section',
        'settings' => 'clearex_sidebar_width',
        'type' => 'range',
        'active_callback' => 'clearex_sidebar_width_active_callback',
        'input_attrs' => array(
            'min' => 3,
            'max' => 5,
            'step' => 1,
            'class' => 'sidebar-width-range',
            'style' =>'color:#0a0'
          ),
      ));

      function clearex_sidebar_width_active_callback($control){
        $options = $control->manager->get_setting('disabled_sidebar_setting');
        return $options->value() == false;
      }
      
}   
add_action( 'customize_register', 'Clearex_Customize_Layout' );
endif;    


