<?php

if ( ! function_exists( 'clearex_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function clearex_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on clearex, use a find and replace
		 * to change 'clearex' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'clearex', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );
		/*
         * Enable support for Post Formats.
         * See http://codex.wordpress.org/Post_Formats
         */
        add_theme_support( 'post-formats', array(
            'aside', 'image', 'video', 'quote', 'link','audio','gallery'
        ) );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus( array(
			'menu-1' => esc_html__( 'Primary', 'clearex' ),
		) );

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support( 'html5', array(
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		// Set up the WordPress core custom background feature.
		add_theme_support( 'custom-background', apply_filters( 'clearex_custom_background_args', array(
			'default-color' => 'ffffff',
			'default-image' => '',
		) ) );

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support( 'custom-logo', array(
			'height'      => 200,
			'width'       => 400,
			'flex-width'  => true,
			'flex-height' => true,
		) );
		/**
		 * add image size for post thumanail
		 */
		add_image_size( 'clearex-post-thumb', 728,350,true);
		add_image_size( 'clearex-related-thumb', 350,250,true);
	}
endif;
add_action( 'after_setup_theme', 'clearex_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function clearex_content_width() {
	// This variable is intended to be overruled from themes.
	// Open WPCS issue: {@link https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/issues/1043}.
	// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
	$GLOBALS['content_width'] = apply_filters( 'clearex_content_width', 640 );
}
add_action( 'after_setup_theme', 'clearex_content_width', 0 );
/**
 *  get Clearex serach form width
 * **/
if(!function_exists('Clearex_seach_form_width')):
	function Clearex_seach_form_width(){
		$get_width = esc_attr(get_theme_mod('clearex_search_width',4));
		$class = 'col-lg-'.$get_width;
		echo esc_attr($class);
	}
	add_action( 'clearex_get_support_search_width', 'Clearex_seach_form_width' );
endif;	
/**
 * get Clerex support bar left content width
*/
if(!function_exists('Clearex_left_content_width')):

	function Clearex_left_content_width(){
		$get_search_width = esc_attr(get_theme_mod( 'clearex_search_width', 4 ));
		$class = 'col-lg-'. (12 - $get_search_width);
		echo esc_attr($class);
	}
	add_action( 'clearex_get_left_content_width', 'Clearex_left_content_width');

endif;

/**
 * add filter for adding class menu li
 * 
 * */
if(!function_exists('Clearex_add_classes_on_li')):

	function Clearex_add_classes_on_li($classes, $item, $args)
	{
		$classes[] = 'nav-item';

		return $classes;
	}
	add_filter('nav_menu_css_class', 'Clearex_add_classes_on_li', 1, 3);

endif;	

/**
 * add filter for adding class menu anchor tag
 * 
 * */
if(!function_exists('Clearex_add_classes_on_a')):

	function Clearex_add_classes_on_a($ulclass)
	{
		return preg_replace('/<a /', '<a class="nav-link"', $ulclass);
	}
	add_filter('wp_nav_menu', 'Clearex_add_classes_on_a');

endif;

/**
 * remove plus sign form phone number
*/
if(!function_exists('Clearex_phone_number')):

	function Clearex_phone_number($number){
		$value = preg_replace('/[\+]/','',$number);
		return str_replace(' ','',$value);
	}	

endif;



/**
 * get primary content width
 * */
if(!function_exists('Clearex_primar_content_width')):
	function Clearex_primar_content_width(){
		$get_sidebar_width = esc_attr(get_theme_mod('clearex_sidebar_width',4));
		$class = 'col-lg-'.( 12 - $get_sidebar_width );
		if(!Clearex_load_sidebar()){
			$class = 'col-lg-12';
		}
		echo esc_attr($class);
	}
	add_action( 'clearex_get_primary_content_width', 'Clearex_primar_content_width');
endif;	
/**
 * get sidebar content width
 * */
if(!function_exists('Clearex_sidebar_content_width')):

	function Clearex_sidebar_content_width(){
		$get_sidebar_width = esc_attr(get_theme_mod( 'clearex_sidebar_width', 4 ));
		$class = 'col-lg-'.$get_sidebar_width;
		echo esc_attr( $class);
	}
	add_action( 'get_clearex_sidebar_content_width', 'Clearex_sidebar_content_width' );
endif;	

/**
 * function to check sidebar is enabled or not in current page
 * */
if(!function_exists('Clearex_load_sidebar')):

	function Clearex_load_sidebar(){

		$enabled_sidebar = true;

		if(get_theme_mod('disabled_sidebar_setting')){
			$enabled_sidebar = false;
		}elseif(get_theme_mod('disabled_sidebar_frontpage') && is_front_page()){
			$enabled_sidebar = false;
		}elseif(get_theme_mod('disabled_sidebar_home') && is_home()){
			$enabled_sidebar = false;
		}

		return $enabled_sidebar;
	}

endif;	