<?php
/**
 * This file is reponsible for registering the theme assets
 * */

/**
 * Enqueue scripts and styles.
 */
function clearex_scripts() {
	wp_enqueue_style( 'clearex-style', get_stylesheet_uri() );
	wp_enqueue_style( 'clearex-fonts', '//fonts.googleapis.com/css?family=Open+Sans:400,600|Roboto:400,500,700' );
	wp_enqueue_style( 'bootstrap-css', get_template_directory_uri() .'/assets/css/bootstrap.css', null,'4.0.0','all');
	wp_enqueue_style( 'fontawesome-css', get_template_directory_uri() .'/assets/css/fontawesome-all.css', null,'5.0.8','all');
	wp_enqueue_style( 'animate-css', get_template_directory_uri() .'/assets/css/animate.css', null,'3.6.0','all');
	wp_enqueue_style( 'owl-carusel-css', get_template_directory_uri() .'/assets/css/owl.carousel.css', null,'2.0.0','all');
	wp_enqueue_style( 'slick-nav-css', get_template_directory_uri() .'/assets/css/slicknav.css', null,'1.0.10','all');
	wp_enqueue_style( 'clearex-main-css', get_template_directory_uri() .'/assets/css/main.css', null,'1.0.0','all');

	wp_enqueue_script( 'clearex-navigation', get_template_directory_uri() . '/js/navigation.js', array(), '20151215', true );
	wp_enqueue_script( 'clearex-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix.js', array(), '20151215', true );
	wp_enqueue_script( 'owl-carusel-js', get_template_directory_uri() . '/assets/js/owl.carousel.js', array('jquery'), '2.0.0', true );
	wp_enqueue_script( 'popper-js', get_template_directory_uri() . '/assets/js/popper.js', array('jquery'), '1.0.0', true );
	wp_enqueue_script( 'bootstrap-js', get_template_directory_uri() . '/assets/js/bootstrap.js', array('jquery','popper'), '4.0.0', true );
	wp_enqueue_script( 'slick-nav-js', get_template_directory_uri() . '/assets/js/jquery.slicknav.js', array('jquery'), '1.0.10', true );
	wp_enqueue_script( 'main-js', get_template_directory_uri() . '/assets/js/main.js', array('jquery'), '4.0.0', true );


	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'clearex_scripts' );
/**
 * Registers an editor stylesheet for the theme.
 */
function clearex_theme_add_editor_styles() {
    add_editor_style( 'custom-editor-style.css' );
}
add_action( 'admin_init', 'clearex_theme_add_editor_styles' );
