<?php
/**
 * Sample implementation of the Custom Header feature
 *
 * You can add an optional custom header image to header.php like so ...
 *
	<?php the_header_image_tag(); ?>
 *
 * @link https://developer.wordpress.org/themes/functionality/custom-headers/
 *
 * @package clearex
 */

/**
 * Set up the WordPress core custom header feature.
 *
 * @uses clearex_header_style()
 */
function clearex_custom_header_setup() {
	add_theme_support( 'custom-header', apply_filters( 'clearex_custom_header_args', array(
		'default-image'          => get_template_directory_uri() .'/assets/img/header-bg.jpg',
		'default-text-color'     => '#ff0',
		'header-text'           => false,
		'width'                  => 1000,
		'height'                 => 250,
		'flex-height'            => true,
		'wp-head-callback'       => 'clearex_header_style',
		'admin-head-callback'    => 'clearex_admin_header_style',
		'admin-preview-callback' => 'clearex_admin_header_image',
	) ) );
	register_default_headers( array(
            'default-image'    => array(
                'url'            => '%s/assets/img/header-bg.jpg',
                'thumbnail_url'    => '%s/assets/img/header-bg.jpg',
                'description'    => esc_html__('Default Header Image', 'clearex')
            )
        )
    );
}
add_action( 'after_setup_theme', 'clearex_custom_header_setup' );

if ( ! function_exists( 'clearex_header_style' ) ) :
/**
 * Styles the header image and text displayed on the blog
 *
 * @see clearex_custom_header_setup().
 */
function clearex_header_style() {
	?>
	<style>
	#masthead {
			background-image: url(<?php header_image(); ?>);
			background-size: <?php echo esc_attr(get_theme_mod('clearex_header_img_style','cover')); ?>;
			background-position-x: <?php echo esc_attr(get_theme_mod('clearex_header_img_align','center')); ?>;
			background-repeat: <?php echo  esc_attr(get_theme_mod('clearex_header_img_repeat')) ? "repeat" : "no-repeat" ?>;
			background-color:#eeeeee;
		}
	</style>	
	<?php
}
endif; // clearex_header_style

if ( ! function_exists( 'clearex_admin_header_style' ) ) :
/**
 * Styles the header image displayed on the Appearance > Header admin panel.
 *
 * @see clearex_custom_header_setup().
 */
function clearex_admin_header_style() {
?>
	<style type="text/css">
		.appearance_page_custom-header #headimg {
			border: none;
		}
		#headimg h1,
		#desc {
		}
		#headimg h1 {
		}
		#headimg h1 a {
		}
		#desc {
		}
		#headimg img {
		}
	</style>
<?php
}
endif; // clearex_admin_header_style

if ( ! function_exists( 'clearex_admin_header_image' ) ) :
/**
 * Custom header image markup displayed on the Appearance > Header admin panel.
 *
 * @see clearex_custom_header_setup().
 */
function clearex_admin_header_image() {
	$style = sprintf( ' style="color:#%s;"', get_header_textcolor() );
?>
	<div id="headimg">
		<h1 class="displaying-header-text"><a id="name"<?php echo esc_attr($style); ?> onclick="return false;" href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php bloginfo( 'name' ); ?></a></h1>
		<div class="displaying-header-text" id="desc"<?php echo  esc_attr($style); ?>><?php bloginfo( 'description' ); ?></div>
		<?php if ( get_header_image() ) : ?>
		<img src="<?php esc_url(header_image()); ?>" alt="">
		<?php endif; ?>
	</div>
<?php
}
endif; // clearex_admin_header_image
