<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package clearex
 */

get_header();
?>

	<div id="primary" class="content-area ">
		<main id="main" class="site-main">

			<section class="error-404 not-found">
				<header class="page-header error-page-header-area">
					<div class="row justify-content-center">
						<div class="col-lg-10 text-center" >
							<h1 class="page-title"><?php esc_html_e( 'Oops! That page can&rsquo;t be found.', 'clearex' ); ?></h1>
							<p><?php esc_html_e( 'It looks like nothing was found at this location. Maybe try one of the links below or a search?', 'clearex' ); ?></p>

							<?php
							get_search_form();
							?>
						</div>
					</div>
				</header><!-- .page-header -->

				<div class="page-content">
					<div class="row">
						<div class="col-lg-4">
							<div class="widget-area margin-top-40">
								<?php the_widget( 'WP_Widget_Recent_Posts' ); ?>
							</div>
						</div>
						<div class="col-lg-4">
							<div class="widget-area margin-top-40">
								<div class="widget widget_categories">
									<h2 class="widget-title"><?php esc_html_e( 'Most Used Categories', 'clearex' ); ?></h2>
									<ul>
										<?php
										wp_list_categories( array(
											'orderby'    => 'count',
											'order'      => 'DESC',
											'show_count' => 1,
											'title_li'   => '',
											'number'     => 10,
										) );
										?>
									</ul>
								</div><!-- .widget -->
							</div>
						</div>
						<div class="col-lg-4">
							<div class="widget-area margin-top-40">
								<?php the_widget( 'WP_Widget_Tag_Cloud' ); ?>
							</div>
						</div>
					</div>
				</div><!-- .page-content -->
			</section><!-- .error-404 -->

		</main><!-- #main -->
	</div><!-- #primary -->

<?php
get_footer();
