<?php
    /**
     * ReduxFramework Sample Config File
     * For full documentation, please visit: http://docs.reduxframework.com/
     */

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }


    // This is your option name where all the Redux data is stored.
    $opt_name = "cleaninganything_opt";

    /**
     * ---> SET ARGUMENTS
     * All the possible arguments for Redux.
     * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
     * */

    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
        // TYPICAL -> Change these values as you need/desire
        'opt_name'             => $opt_name,
        // This is where your data is stored in the database and also becomes your global variable name.
        'display_name'         => $theme->get( 'Name' ),
        // Name that appears at the top of your panel
        'display_version'      => $theme->get( 'Version' ),
        // Version that appears at the top of your panel
        'menu_type'            => 'submenu',
        //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
        'allow_sub_menu'       => true,
        // Show the sections below the admin menu item or not
        'menu_title'           => esc_html__( 'Theme Options', 'cleaninganything' ),
        'page_title'           => esc_html__( 'Theme Options', 'cleaninganything' ),
        // You will need to generate a Google API key to use this feature.
        // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
        'google_api_key'       => '',
        // Set it you want google fonts to update weekly. A google_api_key value is required.
        'google_update_weekly' => false,
        // Must be defined to add google fonts to the typography module
        'async_typography'     => true,
        // Use a asynchronous font on the front end or font string
        //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
        'admin_bar'            => true,
        // Show the panel pages on the admin bar
        'admin_bar_icon'       => 'dashicons-portfolio',
        // Choose an icon for the admin bar menu
        'admin_bar_priority'   => 50,
        // Choose an priority for the admin bar menu
        'global_variable'      => '',
        // Set a different name for your global variable other than the opt_name
        'dev_mode'             => false,
        // Show the time the page took to load, etc
        'update_notice'        => false,
        // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
        'customizer'           => false,
        // Enable basic customizer support
        //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
        //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field

        // OPTIONAL -> Give you extra features
        'page_priority'        => null,
        // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
        'page_parent'          => 'themes.php',
        // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
        'page_permissions'     => 'manage_options',
        // Permissions needed to access the options panel.
        'menu_icon'            => '',
        // Specify a custom URL to an icon
        'last_tab'             => '',
        // Force your panel to always open to a specific tab (by id)
        'page_icon'            => 'icon-themes',
        // Icon displayed in the admin panel next to your menu_title
        'page_slug'            => '',
        // Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
        'save_defaults'        => true,
        // On load save the defaults to DB before user clicks save or not
        'default_show'         => false,
        // If true, shows the default value next to each field that is not the default value.
        'default_mark'         => '',
        // What to print by the field's title if the value shown is default. Suggested: *
        'show_import_export'   => true,
        // Shows the Import/Export panel when not used as a field.

        // CAREFUL -> These options are for advanced use only
        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
        'output_tag'           => true,
        // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
        // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

        // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
        'database'             => '',
        // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
        'use_cdn'              => true,
        // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

        // HINTS
        'hints'                => array(
            'icon'          => 'el el-question-sign',
            'icon_position' => 'right',
            'icon_color'    => 'lightgray',
            'icon_size'     => 'normal',
            'tip_style'     => array(
                'color'   => 'red',
                'shadow'  => true,
                'rounded' => false,
                'style'   => '',
            ),
            'tip_position'  => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect'    => array(
                'show' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'mouseover',
                ),
                'hide' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'click mouseleave',
                ),
            ),
        )
    );

    Redux::setArgs( $opt_name, $args );

    /*
     * ---> END ARGUMENTS
     */



    /*
     *
     * ---> START SECTIONS
     *
     */

    /*

        As of Redux 3.5+, there is an extensive API. This API can be used in a mix/match mode allowing for


     */


    // -> START Basic Fields
    Redux::setSection( $opt_name, array(
        'title'     => esc_html__('General', 'cleaninganything'),
        'id'        => 'main_logo_id',
        'desc'      => esc_html__('Welcome Our Theme Option', 'cleaninganything'),
        'customizer_width' => '400px',
        'icon'      => 'el-icon-cog',
    ) );


/*========================
cleaninganything Typography FIELD
=========================*/
    Redux::setSection( $opt_name, array(
         'title'     => esc_html__('Typography Area', 'cleaninganything'),
        'id'         => 'cleaninganything_tyfo_page',  
        'icon'       => 'el-icon-picture',
        'fields'    => array(				
			
				array(
					'id'          => 'cleaninganything_body_typography',
					'type'        => 'typography', 
					'title'       => esc_html__('Body Typography Style', 'cleaninganything'),
					'google'      => true, 
					'font-backup' => true,
					'line-height'   => false,
					'output'      => array('
						body,p						
					'),
					'units'       =>'px',
					'subtitle'    => esc_html__('Typography option with each property can be called individually.', 'cleaninganything'),
					'default'     => array(
						'color'       => '', 
						'font-style'  => '', 
						'font-family' => '', 
						'google'      => true,
						'font-size'   => '',						
					),
				),
				array(
					'id'          => 'cleaninganything_heading_all_typography',
					'type'        => 'typography', 
					'title'       => esc_html__('Headibg Typography Style', 'cleaninganything'),
					'google'      => true, 
					'font-backup' => true,
					'line-height'   => false,
					'font-style'  => false, 					
					'output'      => array('
						h1, h2, h3, h4, h5, h6					
					'),
					'units'       =>'px',
					'subtitle'    => esc_html__('Typography option with each property can be called individually.', 'cleaninganything'),
					'default'     => array(
						'color'       => '', 
						'font-family' => '', 
						'google'      => true,
						'font-size'   => '',						
					),
				),
				
				array(
					'id'          => 'cleaninganything_heading_typographyh1',
					'type'        => 'typography', 
					'title'       => esc_html__('Heading Typography H1', 'cleaninganything'),
					'google'      => true, 
					'font-backup' => true,
					'line-height'   => false,
					'font-style'  => false, 					
					'output'      => array('
						h1				
					'),
					'units'       =>'px',
					'subtitle'    => esc_html__('Typography option with each property can be called individually.', 'cleaninganything'),
					'default'     => array(
						'color'       => '', 
						'font-family' => '', 
						'google'      => true,
						'font-size'   => '',						
					),
				),
				array(
					'id'          => 'cleaninganything_heading_typographyh2',
					'type'        => 'typography', 
					'title'       => esc_html__('Heading Typography H2', 'cleaninganything'),
					'google'      => true, 
					'font-backup' => true,
					'line-height'   => false,
					'font-style'  => false, 					
					'output'      => array('
						h2				
					'),
					'units'       =>'px',
					'subtitle'    => esc_html__('Typography option with each property can be called individually.', 'cleaninganything'),
					'default'     => array(
						'color'       => '', 
						'font-family' => '', 
						'google'      => true,
						'font-size'   => '',						
					),
				),
				array(
					'id'          => 'cleaninganything_heading_typographyh3',
					'type'        => 'typography', 
					'title'       => esc_html__('Heading Typography H3', 'cleaninganything'),
					'google'      => true, 
					'font-backup' => true,
					'line-height'   => false,
					'font-style'  => false, 					
					'output'      => array('
						h3			
					'),
					'units'       =>'px',
					'subtitle'    => esc_html__('Typography option with each property can be called individually.', 'cleaninganything'),
					'default'     => array(
						'color'       => '', 
						'font-family' => '', 
						'google'      => true,
						'font-size'   => '',						
					),
				),
				array(
					'id'          => 'cleaninganything_heading_typographyh4',
					'type'        => 'typography', 
					'title'       => esc_html__('Heading Typography H4', 'cleaninganything'),
					'google'      => true, 
					'font-backup' => true,
					'line-height'   => false,
					'font-style'  => false, 					
					'output'      => array('
						h4				
					'),
					'units'       =>'px',
					'subtitle'    => esc_html__('Typography option with each property can be called individually.', 'cleaninganything'),
					'default'     => array(
						'color'       => '', 
						'font-family' => '', 
						'google'      => true,
						'font-size'   => '',						
					),
				),
				array(
					'id'          => 'cleaninganything_heading_typographyh5',
					'type'        => 'typography', 
					'title'       => esc_html__('Heading Typography H5', 'cleaninganything'),
					'google'      => true, 
					'font-backup' => true,
					'line-height'   => false,
					'font-style'  => false, 					
					'output'      => array('
						h5					
					'),
					'units'       =>'px',
					'subtitle'    => esc_html__('Typography option with each property can be called individually.', 'cleaninganything'),
					'default'     => array(
						'color'       => '', 
						'font-family' => '', 
						'google'      => true,
						'font-size'   => '',						
					),
				),
				array(
					'id'          => 'cleaninganything_heading_typographyh6',
					'type'        => 'typography', 
					'title'       => esc_html__('Heading Typography H6', 'cleaninganything'),
					'google'      => true, 
					'font-backup' => true,
					'line-height'   => false,
					'font-style'  => false, 					
					'output'      => array('
						h6					
					'),
					'units'       =>'px',
					'subtitle'    => esc_html__('Typography option with each property can be called individually.', 'cleaninganything'),
					'default'     => array(
						'color'       => '', 
						'font-family' => '', 
						'google'      => true,
						'font-size'   => '',						
					),
				),					
				

				
								
            ),
    ) );
	
/*========================
END cleaninganything Typography FIELD
=========================*/
	
	//total header area
     Redux::setSection( $opt_name, array(
        'title'     => esc_html__('Header area', 'cleaninganything'),
        'id'        => 'cleaninganything_header_area',
        'desc'      => esc_html__('Header options', 'cleaninganything'),
        'icon'      => 'el-icon-tasks',      
        'fields'    => array(
		
             array(
                    'id'        => 'cleaninganything_header_display_none_hide',
					'desc'      => esc_html__('All Menu OFF/ON section', 'cleaninganything'),					
                    'type'      => 'switch',
                    'title'     => esc_html__('All Header Hide', 'cleaninganything'),
                    'default'   => false,
                ),
             array(
                    'id'        => 'cleaninganything_header_posi_top',
					'desc'      => esc_html__('All Menu Position  OFF/ON section', 'cleaninganything'),
                    'type'      => 'switch',
                    'title'     => esc_html__('All Header absolute', 'cleaninganything'),
                    'default'   => false,
                ),
				array(
                    'id'        => 'cleaninganything_header_posi_top2',
					'desc'      => esc_html__('Top 2 and Main Menu Position  OFF/ON section', 'cleaninganything'),
                    'type'      => 'switch',
                    'title'     => esc_html__('Top 2 and Main Menu Header absolute', 'cleaninganything'),
                    'default'   => false,
                ),				
				array(
                    'id'        => 'cleaninganything_header_posi_top3',
					'desc'      => esc_html__('Main Menu Position  OFF/ON section', 'cleaninganything'),
                    'type'      => 'switch',
                    'title'     => esc_html__('Main Header absolute', 'cleaninganything'),
                    'default'   => false,
                ),					
             array(
                    'id'        => 'cleaninganything_header_display_social_hide',
					'desc'      => esc_html__('Body Social icon OFF/ON section', 'cleaninganything'),					
                    'type'      => 'switch',
                    'title'     => esc_html__('Body Social ON/OFF', 'cleaninganything'),
                    'default'   => false,
                ),						

				
            )
        ));	
	
     //Header Top 1
    Redux::setSection( $opt_name, array(
        'title'     => esc_html__('Header Top Section 1', 'cleaninganything'),
        'id'        => 'cleaninganything_header_top',
        'desc'      => esc_html__('Insert header top info', 'cleaninganything'),
		'icon'		=> 'el el-circle-arrow-right',
        'subsection' => true,     
        'fields'    => array(
             array(
                    'id'        => 'cleaninganything_header_top_hide',
					'desc'      => esc_html__('If you ON this section. It will show header top style 1 everywhere. But If you want to show header top style 1 your choose page and post. That time, Please don\'t ON the option. For this go to your page or post below, there you can see a Top Menu 1 OFF/ON option. Please select OFF/ON from there.', 'cleaninganything'),
                    'type'      => 'switch',
                    'title'     => esc_html__('Header Top', 'cleaninganything'),
                    'default'   => false,
                ),
                array(
                    'id'        => 'cleaninganything_box_layout',
                    'type'      => 'select',
                    'title'     => esc_html__('Select Top 1 Header layout', 'cleaninganything'),
                    'customizer_only'   => false,
                    'options'   => array(
                        'htops_box' => esc_html__('Select Layout','cleaninganything'),
                        'htopt_box' => esc_html__('Box Layout','cleaninganything'),
                        'htopt_boxi' => esc_html__('Box Inner Layout','cleaninganything'),
                        'htopt_full' => esc_html__('Full Layout','cleaninganything'),
                    ),
                    'default'   => 'htops_box'
                ),				
                array(
                    'id'        => 'cleaninganything_top_right_layout',
                    'type'      => 'select',
                    'title'     => esc_html__('Select Top Header Style', 'cleaninganything'),
                    'customizer_only'   => false,
                    'options'   => array(
                        'h_top_l11' => esc_html__('Select Top Menu','cleaninganything'),
                        'h_top_l1' => esc_html__('Left Address and Right Icon','cleaninganything'),
                        'h_top_l3' => esc_html__('Left Icon and Right Address','cleaninganything'),
                        'h_top_l2' => esc_html__('Left Address,Middle Welcome and Right Icon','cleaninganything'),
                        'h_top_l4' => esc_html__('Left Icon,Middle Welcome and Right Address','cleaninganything'),
                        'h_top_l5' => esc_html__('Left Address and Right Side Menu','cleaninganything'),
                        'h_top_l6' => esc_html__('Left Side Menu and Right Address','cleaninganything'),
                        'h_top_l7' => esc_html__('Left Address, Middle Social & Right Login','cleaninganything'),
                        'h_top_l8' => esc_html__('Left Opening Hours, Middle Social and Right login','cleaninganything'),
                        'h_top_l9' => esc_html__('Left Opening Hours, Middle Social and Right Search','cleaninganything'),
                        'h_top_20' => esc_html__('Left Address Right Search','cleaninganything'),
                        'h_top_21' => esc_html__('Left Address Right Text','cleaninganything'),
                        'h_top_22' => esc_html__('Right Address Left Text','cleaninganything'),
                        'h_top_23' => esc_html__('Left Address, Icon and Right Menu','cleaninganything'),
                    ),
                    'default'   => 'h_top_l1'
                ),				
				array(
                    'id'       => 'cleaninganything_header_top_i1',
                    'type'     => 'text',
                    'title'    => esc_html__('Set Icon 1', 'cleaninganything'),
                    'desc' => esc_html__('insert your icon here. ex - <i class="fas fa-home"></i> icofont,font-awesome,themify ', 'cleaninganything'),
					'default'	=> esc_html__('<i class="fas fa-home"></i>', 'cleaninganything'),
                ),
				array(
                    'id'       => 'cleaninganything_header_top_road',
                    'type'     => 'text',
                    'title'    => esc_html__('Text Name 1', 'cleaninganything'),
                    'desc' => esc_html__('Insert Your Text', 'cleaninganything'),
					'default'	=> esc_html__('1st Floor New World.', 'cleaninganything'),
                ),
				array(
                    'id'       => 'cleaninganything_header_top_i3',
                    'type'     => 'text',
                    'title'    => esc_html__('Set Icon 2', 'cleaninganything'),
                    'desc' => esc_html__('insert your icon here. ex - <i class="fas fa-envelope"></i> icofont,font-awesome,themify', 'cleaninganything'),
					'default'	=> esc_html__('<i class="fas fa-envelope"></i>', 'cleaninganything'),
                ),				
                array(
                    'id'       => 'cleaninganything_header_top_email',
                    'type'     => 'text',
                    'title'    => esc_html__('Text Name 2', 'cleaninganything'),
                    'desc' => esc_html__('Insert Your Text', 'cleaninganything'),
					'default'	=> esc_html__('demo@example.com', 'cleaninganything'),					
                ),
				array(
                    'id'       => 'cleaninganything_header_top_i2',
                    'type'     => 'text',
                    'title'    => esc_html__('Set Icon 3', 'cleaninganything'),
                    'desc' => esc_html__('insert your Phone icon here. ex - <i class="fas fa-phone-alt"></i> icofont,font-awesome,themify', 'cleaninganything'),
					'default'	=> esc_html__('<i class="fas fa-phone-alt"></i>', 'cleaninganything'),
                ),				
                array(
                    'id'       => 'cleaninganything_header_top_mobile',
                    'type'     => 'text',
                    'title'    => esc_html__('Text Name 3', 'cleaninganything'),
                    'desc' => esc_html__('Insert Your Phone Number Text', 'cleaninganything'),
					'default'	=> esc_html__('+998556778345', 'cleaninganything'),					
                ),
				array(
                    'id'       => 'cleaninganything_header_top_i4',
                    'type'     => 'text',
                    'title'    => esc_html__('Set Message Icon', 'cleaninganything'),
                    'desc' => esc_html__('insert your icon here. ex - <i class="fas fa-heartbeat"></i> icofont,font-awesome,themify', 'cleaninganything'),
					'default'	=> esc_html__('<i class="fas fa-heartbeat"></i>', 'cleaninganything'),
                ),				
                array(
                    'id'       => 'cleaninganything_header_top_wellcome',
                    'type'     => 'textarea',
                    'title'    => esc_html__('Text Message', 'cleaninganything'),
                    'desc' => esc_html__('Insert text support - span,a,br,strong,b,em and h2 html tag', 'cleaninganything'),
					'default'	=> esc_html__('welcome visit our site', 'cleaninganything'),					
                ),
				array(
                    'id'       => 'cleaninganything_header_top_i5',
                    'type'     => 'text',
                    'title'    => esc_html__('Set Icon', 'cleaninganything'),
                    'desc' => esc_html__('insert your icon here. ex - <i class="far fa-clock"></i> icofont,font-awesome,themify', 'cleaninganything'),
					'default'	=> esc_html__('<i class="far fa-clock"></i>', 'cleaninganything'),
                ),					
                array(
                    'id'       => 'cleaninganything_header_top_opening',
                    'type'     => 'text',
                    'title'    => esc_html__('Opening Text', 'cleaninganything'),
                    'desc' => esc_html__('Insert Text', 'cleaninganything'),
					'default'	=> esc_html__('Open hours: 9.00-24.00 Mon-Sat', 'cleaninganything'),					
                ),				
                array(								
                    'id'        => 'cleaninganything_header_top_icon_color',
                    'type'      => 'color',
                    'title'     => esc_html__('Top Icon Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
						'color' => '.top-address p span i, .top-address p a i
					')
                ),				
                array(								
                    'id'        => 'cleaninganything_header_top_color',
                    'type'      => 'color',
                    'title'     => esc_html__('All Text Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
						'color' => '.top-address p a,
								.top-right-menu ul.social-icons li a,
								.top-address p span,
								.top-address.menu_18 span
					')
                ),
                array(								
                    'id'        => 'cleaninganything_header_top_hover_color',
                    'type'      => 'color',
                    'title'     => esc_html__('All Icon Hover Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
					'color' => '.top-right-menu .social-icons li a:hover,
								.top-right-menu .social-icons li a i:hover,
								.top-address p a i,
								.top-address p span i
					')
                ),
                array(								
                    'id'        => 'cleaninganything_header_top_well_color',
                    'type'      => 'color',
                    'title'     => esc_html__('Text Message Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
					'color' => '.top-welcome p'
					)
                ),
				array(								
                    'id'        => 'cleaninganything_header_top_wella_color',
                    'type'      => 'color',
                    'title'     => esc_html__('Text Message Link Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
					'color' => '.top-welcome p a'
					)
                ),
				array(								
                    'id'        => 'cleaninganything_header_hover_Link_color',
                    'type'      => 'color',
                    'title'     => esc_html__('Text Message Link Hover Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
					'color' => '.top-welcome p a:hover,.top-welcomet p a:hover'
					)
                ),
				
                array(								
                    'id'        => 'cleaninganything_header_opening_bg_color',
                    'type'      => 'color',
                    'title'     => esc_html__('Opening BG Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
					'background-color' => '.top-address.menu_18 span,.em-quearys-menu i',
					'border-color' => '.em-quearys-form'
					)
                ),				
                array(								
                    'id'        => 'cleaninganything_hoeder_top_bg_color11',
                    'type'      => 'background',
                    'title'     => esc_html__('Header Top Section BG Color', 'cleaninganything'),
                    'default'  => '',
                    'output'    => array('
						.cleaninganything-header-top
					'),
					'default'  => array(
						'background-color' => '',
					)					
                ),

				 array( 
					'id'       => 'top_header_border',
					'type'     => 'border',
					'title'    => __('Header Border Option', 'cleaninganything'),
					'subtitle' => __('Only color validation can be done on this field type', 'cleaninganything'),
					'output'   => array('.cleaninganything-header-top'),
					'desc'     => __('This is the description field, again good for additional info.', 'cleaninganything'),
					'default'  => array(
						'border-color'  => '', 
						'border-style'  => 'solid', 
						'border-top'    => '', 
						'border-right'  => '', 
						'border-bottom' => '', 
						'border-left'   => ''
					)
				),


				
				array(
					'id'             => 'cleaninganything_header_top_section_spacing',
					'type'           => 'spacing',
					'output'         => array('.cleaninganything-header-top'),
					'mode'           => 'padding',
					'units'          => array('em', 'px'),
					'units_extended' => 'false',
					'title'          => esc_html__('Padding Option', 'cleaninganything'),
					'subtitle'       => esc_html__('Allow your users to choose the spacing padding they want.', 'cleaninganything'),
					'desc'           => esc_html__('You can enable or disable any piece of this field. Top, Right, Bottom, Left, or Units.', 'cleaninganything'),
					'default'            => array(
						'padding-top'     => '', 
						'padding-right'   => '', 
						'padding-bottom'  => '', 
						'padding-left'    => '',
						'units'          => 'px', 
					)
				),							
				
            ),
    ) );



     //Header Top 2
    Redux::setSection( $opt_name, array(
        'title'     => esc_html__('Header Top Section 2', 'cleaninganything'),
        'id'        => 'cleaninganything_header_toptwo',
        'desc'      => esc_html__('Insert header top info', 'cleaninganything'),
		'icon'		=> 'el el-circle-arrow-right',
        'subsection' => true,     
        'fields'    => array(
             array(
                    'id'        => 'cleaninganything_header_top_two_hide',
					'desc'      => esc_html__('If you ON this section. It will show header top style 2 everywhere. But If you want to show header top style 2 your choose page and post. That time, Please don\'t ON the option. For this go to your page or post below, there you can see a Top Menu 2 OFF/ON option. Please select OFF/ON from there.', 'cleaninganything'),					
                    'type'      => 'switch',
                    'title'     => esc_html__('Header Top style 2', 'cleaninganything'),
                    'default'   => false,
                ),
                array(
                    'id'        => 'cleaninganything_box_layouttwo',
                    'type'      => 'select',
                    'title'     => esc_html__('Select Top 2 Header layout', 'cleaninganything'),
                    'customizer_only'   => false,
                    'options'   => array(
						'htops_box' => esc_html__('Select Layout','cleaninganything'),
                        'htopt_box' => esc_html__('Box Layout','cleaninganything'),
                        'htopt_boxi' => esc_html__('Box Inner Layout','cleaninganything'),
                        'htopt_full' => esc_html__('Full Layout','cleaninganything'),
                    ),
                    'default'   => 'htops_box'
                ),				
                array(
                    'id'        => 'cleaninganything_top_two_layout',
                    'type'      => 'select',
                    'title'     => esc_html__('Select Top 2 Header Style', 'cleaninganything'),
                    'customizer_only'   => false,
                    'options'   => array(
                        'h_top_1' => esc_html__('Select Top Menu','cleaninganything'),
                        'h_top_2' => esc_html__('1. Left Logo,Middle Address And Right Button','cleaninganything'),
                        'h_top_3' => esc_html__('2. Left Logo,Middle Address And Right Top Menu','cleaninganything'),
                        'h_top_4' => esc_html__('3. Left Logo,Middle Address And Right Social Icon','cleaninganything'),
                        'h_top_5' => esc_html__('4. Left Social Icon,Middle Logo And Right Address','cleaninganything'),
                        'h_top_6' => esc_html__('5. Left Logo And Right Address','cleaninganything'),
                        'h_top_7' => esc_html__('6. Left Logo,Middle Address And Right Button','cleaninganything'),
                        'h_top_8' => esc_html__('7. Left Logo,Middle Address And Right Mini shop','cleaninganything'),
						'h_top_9' => esc_html__('8. Left Social Icon and Menu,Middle Logo And Right Address','cleaninganything'),
                    ),
                    'default'   => 'h_top_2'
                ),					
				array(
                    'id'       => 'cleaninganything_header_top_ci1',
                    'type'     => 'text',
                    'title'    => esc_html__('Set Icon 1', 'cleaninganything'),
                    'desc' => esc_html__('insert your icon here. ex - icofont,font-awesome,themify', 'cleaninganything'),
					'default'	=> esc_html__('<i class="fas fa-map-marker-alt"></i>', 'cleaninganything'),
                ),				
				array(
                    'id'       => 'cleaninganything_header_top_roadtwot',
                    'type'     => 'text',
                    'title'    => esc_html__('Title 1', 'cleaninganything'),
                    'desc' => esc_html__('Insert Text Here', 'cleaninganything'),
					'default'	=> esc_html__('Location', 'cleaninganything'),
                ),				
				array(
                    'id'       => 'cleaninganything_header_top_roadtwo',
                    'type'     => 'text',
                    'title'    => esc_html__('Sub Title 1', 'cleaninganything'),
                    'desc' => esc_html__('Insert Text Here', 'cleaninganything'),
					'default'	=> esc_html__('1st Floor.', 'cleaninganything'),
                ),
				array(
                    'id'       => 'cleaninganything_header_top_ci2',
                    'type'     => 'text',
                    'title'    => esc_html__('Set Icon 2', 'cleaninganything'),
                    'desc' => esc_html__('insert your icon here. ex - icofont,font-awesome,themify', 'cleaninganything'),
					'default'	=> esc_html__('<i class="fa fa-envelope"></i>', 'cleaninganything'),
                ),					
                array(
                    'id'       => 'cleaninganything_header_top_emailtwot',
                    'type'     => 'text',
                    'title'    => esc_html__('Title 2', 'cleaninganything'),
                    'desc' => esc_html__('insert info', 'cleaninganything'),
					'default'	=> esc_html__(' Email', 'cleaninganything'),					
                ),					
                array(
                    'id'       => 'cleaninganything_header_top_emailtwo',
                    'type'     => 'text',
                    'title'    => esc_html__(' Sub Title 2 ', 'cleaninganything'),
                    'desc' => esc_html__('Iinsert info', 'cleaninganything'),
					'default'	=> esc_html__('demo@example.com', 'cleaninganything'),					
                ),
				array(
                    'id'       => 'cleaninganything_header_top_ci3',
                    'type'     => 'text',
                    'title'    => esc_html__('Set Icon 3', 'cleaninganything'),
                    'desc' => esc_html__('insert your icon here. ex - icofont,font-awesome,themify', 'cleaninganything'),
					'default'	=> esc_html__('<i class="fas fa-phone-volume"></i>', 'cleaninganything'),
                ),					
                array(
                    'id'       => 'cleaninganything_header_top_mobiletwot',
                    'type'     => 'text',
                    'title'    => esc_html__('Title 3', 'cleaninganything'),
                    'desc' => esc_html__('insert info', 'cleaninganything'),
					'default'	=> esc_html__('Phone', 'cleaninganything'),					
                ),					
                array(
                    'id'       => 'cleaninganything_header_top_mobiletwo',
                    'type'     => 'text',
                    'title'    => esc_html__('Sub Title 3', 'cleaninganything'),
                    'desc' => esc_html__('insert info', 'cleaninganything'),
					'default'	=> esc_html__('+998556778345', 'cleaninganything'),					
                ),
                array(
                    'id'       => 'cleaninganything_header_buttonc1',
                    'type'     => 'text',
                    'title'    => esc_html__('Button Text', 'cleaninganything'),
                    'desc' => esc_html__('Insert text', 'cleaninganything'),
					'default'	=> esc_html__('Get a Quote', 'cleaninganything'),					
                ),
                array(
                    'id'       => 'cleaninganything_header_button_urlc1',
                    'type'     => 'text',
                    'title'    => esc_html__('Button URL', 'cleaninganything'),
                    'desc' => esc_html__('Insert url ex: - https://your_site.com/', 'cleaninganything'),
					'default'	=>'#',					
                ),			
                array(								
                    'id'        => 'cleaninganything_header_top_icon_colortwo',
                    'type'      => 'color',
                    'title'     => esc_html__('Top Icon Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
						'color' => '.creative_header_icon i
					')
                ),				
               /* array(								
                    'id'        => 'cleaninganything_header_top_colortwo',
                    'type'      => 'color',
                    'title'     => esc_html__(' Title Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
						'color' => '.creative_header_address_text > h3
					')
                ),*/
				array(
					'id'          => 'cleaninganything_title_typography',
					'type'        => 'typography', 
					'title'       => esc_html__('Title Typography style', 'cleaninganything'),
					'google'      => true, 
					'font-backup' => true,
					'output'      => array('
						.creative_header_address_text > h3
					'),
					'line-height'   => false,
					'units'       =>'px',
					'subtitle'    => esc_html__('Typography option with each property can be called individually.', 'cleaninganything'),
					'default'     => array(
						'color'       => '', 
						'font-style'  => '', 
						'font-family' => '', 
						'google'      => true,
						'font-size'   => '', 
						'line-height' => ''
					),
				),				
				array(
					'id'          => 'cleaninganything_suptitle_typography',
					'type'        => 'typography', 
					'title'       => esc_html__('Sub Title Typography style', 'cleaninganything'),
					'google'      => true, 
					'font-backup' => true,
					'output'      => array('
						.creative_header_address_text > p,.creative_header_address_text > p > a
					'),
					'line-height'   => false,
					'units'       =>'px',
					'subtitle'    => esc_html__('Typography option with each property can be called individually.', 'cleaninganything'),
					'default'     => array(
						'color'       => '', 
						'font-style'  => '', 
						'font-family' => '', 
						'google'      => true,
						'font-size'   => '', 
						'line-height' => ''
					),
				),				
                array(								
                    'id'        => 'cleaninganything_header_opening_bg_colortwo',
                    'type'      => 'color',
                    'title'     => esc_html__('Angle BG Section Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
					'background-color' => '.em_creative_header::before,.creative_header_button::before,.em_creative_header::after',
					)
                ),				
                array(								
                    'id'        => 'cleaninganything_hoeder_top_bg_colortwo',
                    'type'      => 'background',
                    'title'     => esc_html__('Header Top 2 Section BG Color', 'cleaninganything'),
                    'default'  => '',
                    'output'    => array('
						.em_creative_header,.top_crt_style
					'),
					'default'  => array(
						'background-color' => '',
					)					
                ),							
				array(
					'id'             => 'cleaninganything_header_top_section_spacingtwo',
					'type'           => 'spacing',
					'output'         => array('.em_creative_header,.top_crt_style'),
					'mode'           => 'padding',
					'units'          => array('em', 'px'),
					'units_extended' => 'false',
					'title'          => esc_html__('Padding Option', 'cleaninganything'),
					'subtitle'       => esc_html__('Allow your users to choose the spacing padding they want.', 'cleaninganything'),
					'desc'           => esc_html__('You can enable or disable any piece of this field. Top, Right, Bottom, Left, or Units.', 'cleaninganything'),
					'default'            => array(
						'padding-top'     => '', 
						'padding-right'   => '', 
						'padding-bottom'  => '', 
						'padding-left'    => '',
						'units'          => 'px', 
					)
				),							
				
            ),
    ) );		
	







	
	
     //Header Logo
    Redux::setSection( $opt_name, array(
        'title'     => esc_html__('Header Logo', 'cleaninganything'),
        'id'        => 'cleaninganything_header_logo',
        'desc'      => esc_html__('Header Logo', 'cleaninganything'),
		'icon'		=> 'el el-circle-arrow-right',
        'subsection' => true,     
        'fields'    => array( 
                array(
                    'id'        => 'cleaninganything_logo',
                    'type'      => 'media',
                    'title'     => esc_html__('Default Logo', 'cleaninganything'),
                    'compiler'  => 'true',
                    'mode'      => false,
                    'desc'      => esc_html__('Upload logo here.ex: - it is work in default menu.', 'cleaninganything'),
                ),
                array(
                    'id'        => 'cleaninganything_onepage_logo',
                    'type'      => 'media',
                    'title'     => esc_html__('One Page Menu Logo', 'cleaninganything'),
                    'compiler'  => 'true',
                    'mode'      => false,
                    'desc'      => esc_html__('Upload logo here. ex:- it is work in one page menu', 'cleaninganything'),
                ),
                array(
                    'id'        => 'cleaninganything_ts_logo',
                    'type'      => 'media',
                    'title'     => esc_html__('Transparent Menu Logo', 'cleaninganything'),
                    'compiler'  => 'true',
                    'mode'      => false,
                    'desc'      => esc_html__('Upload logo here. ex: - it is work in transparent menu', 'cleaninganything'),
                ),
                array(
                    'id'        => 'cleaninganything_mobile_top_logo',
                    'type'      => 'media',
                    'title'     => esc_html__('Mobile Logo', 'cleaninganything'),
                    'compiler'  => 'true',
                    'mode'      => false,
                    'desc'      => esc_html__('Upload logo here. recommend size:- 1801x48px.', 'cleaninganything'),
                ),				
                array(
                    'id'        => 'cleaninganything_logo_height',
                    'type'      => 'text',
                    'title'     => esc_html__('Logo Height', 'cleaninganything'),
                    'mode'      => false,
                    'desc'      => esc_html__('Set height ex-100px', 'cleaninganything'),
                ),	
                array(
                    'id'        => 'cleaninganything_logo_widget',
                    'type'      => 'text',
                    'title'     => esc_html__('Logo Width', 'cleaninganything'),
                    'mode'      => false,
                    'desc'      => esc_html__('Set Width ex-100px', 'cleaninganything'),
                ),
                array(
                    'id'        => 'cleaninganything_line_height',
                    'type'      => 'text',
                    'title'     => esc_html__('Massing your logo spacing to Menu ', 'cleaninganything'),
                    'mode'      => false,
                    'desc'      => esc_html__('Set number default-15px', 'cleaninganything'),
					'default'   =>'15px',
                ),
                array(
                    'id'       => 'cleaninganything_mobile_image_logo',
                    'type'     => 'text',
					'mode'      => false,
                    'title'    => esc_html__('Mobile Text Logo', 'cleaninganything'),
                    'desc' => esc_html__('Insert text ex: - "cleaninganything", Must be use "" for logo text ', 'cleaninganything'),
					'default'	=> esc_html__('"MENU"', 'cleaninganything'),	
                ),
				array(								
                    'id'        => 'cleaninganything_mobilebg_color',
                    'type'      => 'color',
                    'title'     => esc_html__('Mobile Menu BG Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
						'background-color' => '.mean-container .mean-bar,.mean-container .mean-nav',
					)
                ),
				array(								
                    'id'        => 'cleaninganything_mobileicon_color',
                    'type'      => 'color',
                    'title'     => esc_html__('Mobile Menu Icon Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
						'background-color' => '.mean-container a.meanmenu-reveal span',
						'color' => '.mean-container a.meanmenu-reveal,.mean-container .mean-bar::before,.meanmenu-reveal.meanclose:hover'
					)
                ),					
				
            ),
    ) );

     //Header Menu
    Redux::setSection( $opt_name, array(
        'title'     => esc_html__('Header Menu', 'cleaninganything'),
        'id'        => 'cleaninganything_menu',
		'icon'		=> 'el el-circle-arrow-right',
        'subsection'=> true,      
        'fields'    => array(
                array(
                    'id'        => 'cleaninganything_main_box_layout',
                    'type'      => 'select',
                    'title'     => esc_html__('Select Header Menu layout', 'cleaninganything'),
                    'customizer_only'   => false,
                    'options'   => array(
                        'htops_box' => esc_html__('Select Layout','cleaninganything'),
                        'hmenul_box' => esc_html__('Box Layout','cleaninganything'),
                        'hmenul_boxi' => esc_html__('Box Inner Layout','cleaninganything'),
                        'hmenu_full' => esc_html__('Full Layout','cleaninganything'),
                    ),
                    'default'   => 'htops_box'
                ),				
                array(
                    'id'        => 'cleaninganything_main_menu_layout',
					'desc'      => esc_html__('This option work only, when you select  - 1 and 1-1  style menu', 'cleaninganything'),					
                    'type'      => 'select',
                    'title'     => esc_html__('Logo Position', 'cleaninganything'),
                    'customizer_only'   => false,
                    'options'   => array(
                        'm_menu_1' => esc_html__('Logo Left Style','cleaninganything'),
                        'm_menu_2' => esc_html__('Logo Right Style','cleaninganything'),
                        'm_menu_3' => esc_html__('Logo Top Style','cleaninganything'),
                    ),
                    'default'   => 'm_menu_1'
                ),
				
                array(
                    'id'        => 'cleaninganything_defaulth_menu_layout',
					'desc'      => esc_html__('If you select menu from here. It will be showing everywhere and if you want to show different menu different page or post, that time, please don\'t select menu style from here. For this go to your page or post below, there you can see a menu option. Please select menu style from there and when you set the 3,4,5,1-1,8,9,11,12,13,20 menu that time please open the top menu.', 'cleaninganything'),						
                    'type'      => 'select',
                    'title'     => esc_html__('Select Default Menu For All Single Page', 'cleaninganything'),
                    'customizer_only'   => false,
                    'options'   => array(
						'111' => esc_html__( 'Select Menu Style From Here', 'cleaninganything' ),				
						'1' => esc_html__( '1 Header Default Menu', 'cleaninganything' ),													
						'2' => esc_html__( '2 Header Transparent Menu', 'cleaninganything' ),
						'3' => esc_html__( '3 Header Transparent With Sticky Menu', 'cleaninganything' ),		
						'4' => esc_html__( '4 Header One Page Menu', 'cleaninganything' ),
						'5' => esc_html__( '5 Header One Page Transparent Menu', 'cleaninganything' ),				
						'6' => esc_html__( '6 Header One Page Transparent With Sticky  Menu', 'cleaninganything' ),
						'7' => esc_html__( '1-1 Header Default with Sticky Menu', 'cleaninganything' ),							
						'8' => esc_html__( '8 Header Menu With Search', 'cleaninganything' ),
						'9' => esc_html__( '9 Header Menu With Social Icon', 'cleaninganything' ),
						'10' => esc_html__( '10 Header Menu With Button', 'cleaninganything' ),
						'11' => esc_html__( '11 Header Menu With Button headroom Menu', 'cleaninganything' ),
						'12' => esc_html__( '12 Header Menu With Search and no Logo', 'cleaninganything' ),
						'13' => esc_html__( '13 Header Transparent Sticky No logo Menu', 'cleaninganything' ),					
						'14' => esc_html__( '14 Header One Page With Search Menu', 'cleaninganything' ),
						'15' => esc_html__( '15 Header Mini Shop Menu', 'cleaninganything' ),										
						'16' => esc_html__( '16 Header Hamburgers Menu', 'cleaninganything' ),										
						'17' => esc_html__( '17 Header Box Style Menu', 'cleaninganything' ),
						'18' => esc_html__( '18 No Logo,Search, Mini Shop Button', 'cleaninganything' ),
						'19' => esc_html__( '19 Left Logo,Right Search, Mini Shop Button', 'cleaninganything' ),
						'20' => esc_html__( '20 Left Logo,Right Search,Popup Menu,Button', 'cleaninganything' ),
						'21' => esc_html__( '21 Header Menu Hide', 'cleaninganything' ),						
                    ),
                    'default'   => '111'
                ),	
                array(
                    'id'       => 'cleaninganything_header_button',
                    'type'     => 'text',
                    'title'    => esc_html__('Button Text', 'cleaninganything'),
                    'desc' => esc_html__('Insert text', 'cleaninganything'),
					'default'	=> esc_html__('Buy Now', 'cleaninganything'),					
                ),
                array(
                    'id'       => 'cleaninganything_header_button_url',
                    'type'     => 'text',
                    'title'    => esc_html__('Button URL', 'cleaninganything'),
                    'desc' => esc_html__('Insert url ex: - https://your_site.com/', 'cleaninganything'),
					'default'	=>'#',					
                ),
                array(								
                    'id'        => 'cleaninganything_Button_colorm',
                    'type'      => 'color',
                    'title'     => esc_html__('Menu Button Text Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
					'color' => 'a.dtbtn,.creative_header_button .dtbtn,.em-quearys-menu i,.top-form-control button.top-quearys-style'
					)
                ),
                array(								
                    'id'        => 'cleaninganything_Button_colorurl',
                    'type'      => 'color',
                    'title'     => esc_html__('Menu Button BG Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
					'background-color' => 'a.dtbtn,.creative_header_button .dtbtn,.em-quearys-menu i',
					'border-color' => '.em-quearys-form'
					)
                ),
              array(								
                    'id'        => 'cleaninganything_Buttonht_colorm',
                    'type'      => 'color',
                    'title'     => esc_html__('Menu Hover Button Text Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
					'color' => 'a.dtbtn:hover,.creative_header_button > a:hover'
					)
                ),
                array(								
                    'id'        => 'cleaninganything_Buttonhtb_colorurl',
                    'type'      => 'color',
                    'title'     => esc_html__('Menu Hover Button BG Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
					'background-color' => 'a.dtbtn:hover,.creative_header_button > a:hover'
					)
                ),							
                array(								
                    'id'        => 'cleaninganything_menu_bg_color',
                    'type'      => 'background',
                    'title'     => esc_html__('Main Menu Section BG Color', 'cleaninganything'),
                    'default'  => '',
                    'output'    => array('
						.cleaninganything_nav_area,.transprent-menu .cleaninganything_nav_area,.hmenu_box_style
					'),
					'default'  => array(
						'background-color' => '',
					)					
                ),	
			
				array(
					'id'          => 'cleaninganything_menu_typography',
					'type'        => 'typography', 
					'title'       => esc_html__('Menu Font style', 'cleaninganything'),
					'google'      => true, 
					'font-backup' => true,
					'output'      => array('
						.cleaninganything_menu > ul > li > a,
						.heading_style_2 .cleaninganything_menu > ul > li > a,
						.heading_style_3 .cleaninganything_menu > ul > li > a,
						.heading_style_4 .cleaninganything_menu > ul > li > a,
						.witr_search_wh .em-header-quearys .em-quearys-menu i,
						.right_sideber_menu i ,
						.heading_style_5 .cleaninganything_menu > ul > li > a
					'),
					'line-height'   => false,
					'units'       =>'px',
					'subtitle'    => esc_html__('Typography option with each property can be called individually.', 'cleaninganything'),
					'default'     => array(
						'color'       => '', 
						'font-style'  => '', 
						'font-family' => '', 
						'google'      => true,
						'font-size'   => '', 
						'line-height' => ''
					),
				),
                array(								
                    'id'        => 'cleaninganything_menu_texts_hover_color',
                    'type'      => 'color',
                    'title'     => esc_html__('Main Menu Hover Text Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
					'color' => '.cleaninganything_menu > ul > li:hover > a,.cleaninganything_menu > ul > li.current > a,.right_sideber_menu i:hover,.witr_search_wh .em-header-quearys .em-quearys-menu i:hover',
					'background-color' => '.cleaninganything_menu > ul > li > a::before,.cleaninganything_menu > ul > li.current:hover > a::before,.cleaninganything_menu > ul > li.current > a:before'
					)
                ),
                array(								
                    'id'        => 'cleaninganything_menu_bg_sticky_color',
                    'type'      => 'color_rgba',
                    'title'     => esc_html__('Main Menu Sticky BG Color', 'cleaninganything'),
					'default'   => array(
						'color'     => '#000000',
						'alpha'     => 1
					),
					'output'    => array(
					'background-color' => '
					.cleaninganything_nav_area.prefix,
					.hbg2
					'
					)
                ),					
											
                array(								
                    'id'        => 'cleaninganything_menu_sticky_text_color',
                    'type'      => 'color',
                    'title'     => esc_html__('Main Menu Sticky Text Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
					'color' => '
					.cleaninganything_nav_area.prefix .cleaninganything_menu > ul > li > a,.hmenu_box_style.hbg2 .cleaninganything_menu > ul > li > a,.hbg2 .cleaninganything_menu > ul > li > a,.cleaninganything_nav_area.prefix .right_sideber_menu i,.witr_search_wh .prefix  .em-header-quearys .em-quearys-menu i,.cleaninganything_nav_area.prefix .cleaninganything_menu > ul > li.current > a
					',
					'background-color' => '
					.cleaninganything_nav_area.prefix .cleaninganything_menu > ul > li > a::before,
					.hbg2 .cleaninganything_menu > ul > li > a::before
					
					'
					)
                ),					
                array(								
                    'id'        => 'cleaninganything_menu_text_hover_color',
                    'type'      => 'color',
                    'title'     => esc_html__('Main Menu Sticky Current Text Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
					'color' => '
					.cleaninganything_nav_area.prefix .cleaninganything_menu > ul > li.current > a,
					.hbg2 .cleaninganything_menu > ul > li.current > a
					',
					'background-color' => '
						.cleaninganything_nav_area.prefix .cleaninganything_menu > ul > li.current > a::before					
					'
					)
                ),	
                array(								
                    'id'        => 'cleaninganything_submenu_bg_color',
                    'type'      => 'background',
                    'title'     => esc_html__('Sub Menu BG Color', 'cleaninganything'),
                    'default'  => '',
                    'output'    => array('
						.cleaninganything_menu ul .sub-menu
					'),
					'default'  => array(
						'background-color' => '',
					)					
                ),
				array(
					'id'          => 'cleaninganything_sub_menu_typography',
					'type'        => 'typography', 
					'title'       => esc_html__('Sub Menu Font style', 'cleaninganything'),
					'google'      => true, 
					'font-backup' => true,
					'output'      => array('
						.cleaninganything_menu ul .sub-menu li a
					'),
					'units'       =>'px',
					'subtitle'    => esc_html__('Typography option with each property can be called individually.', 'cleaninganything'),
					'default'     => array(
						'color'       => '', 
						'font-style'  => '', 
						'font-family' => '', 
						'google'      => true,
						'font-size'   => '', 
						'line-height' => ''
					),
				),
				
                array(								
                    'id'        => 'cleaninganything_submenu_hover_text_color',
                    'type'      => 'color',
                    'title'     => esc_html__('Sub Menu Hover Text Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
					'color' => '
						.cleaninganything_menu ul .sub-menu li:hover > a,
						.cleaninganything_menu ul .sub-menu .sub-menu li:hover > a,
						.cleaninganything_menu ul .sub-menu .sub-menu .sub-menu li:hover > a,
						.cleaninganything_menu ul .sub-menu .sub-menu .sub-menu .sub-menu li:hover > a																'
					)
                ),				
				array(
					'id'             => 'menu_spacing',
					'type'           => 'spacing',
					'output'         => array('.cleaninganything_nav_area,.trp_nav_area,.transprent-menu .cleaninganything_nav_area'),
					'mode'           => 'padding',
					'units'          => array('em', 'px'),
					'units_extended' => 'false',
					'title'          => esc_html__('Section Padding Option', 'cleaninganything'),
					'subtitle'       => esc_html__('Allow your users to choose the spacing or padding they want.', 'cleaninganything'),
					'desc'           => esc_html__('You can enable or disable any piece of this field. Top, Right, Bottom, Left, or Units.', 'cleaninganything'),
					'default'            => array(
						'padding-top'     => '', 
						'padding-right'   => '', 
						'padding-bottom'  => '', 
						'padding-left'    => '',
						'units'          => 'px', 
					)
				),
					
            ),
    ) );

/*========================
END cleaninganything HEADER FIELD
=========================*/


/*========================
cleaninganything BREADCRUMB FIELD
=========================*/
    Redux::setSection( $opt_name, array(
         'title'     => esc_html__('Breadcrumb Area', 'cleaninganything'),
        'id'         => 'cleaninganything_bread_page',  
        'icon'       => 'el-icon-picture',
        'fields'    => array(
    array(
     'id'   => 'info_normal',
     'type' => 'info',
     'desc' => esc_html__('Notice:- If you want to more breadcrumb control. Please see every page bottom area. We Added More Field Here','cleaninganything')
    ),    
	array(
		'id'        => 'cleaninganything_breadcrumb_bg',
		'type'      => 'background',
		'output'    => array('.breadcumb-area,.breadcumb-blog-area'),
		'title'     => esc_html__('Breadcrumb Background', 'cleaninganything'),
		'subtitle'  => esc_html__('Breadcrumb background with image, color.', 'cleaninganything'),
		'default'  => array(
			'background-color' => '',
		)
	),
	array(								
		'id'        => 'cleaninganything_brdov_text_color',
		'type'      => 'color_rgba',
		'title'     => esc_html__('Breadcumb Overlay', 'cleaninganything'),
		'default'   => array(
			'color'     => '#000000',
			'alpha'     => 1
		),
		'output'    => array(
		'background-color' => '
		.breadcumb-area::before,
		.breadcumb-blog-area::before
		'
		)
	),		
	array(        
		'id'        => 'cleaninganything_bread_title_page_color',
		'type'      => 'color',
		'title'     => esc_html__('Breadcrumb Title Color', 'cleaninganything'),
		'default'  => '',
		'output'    => array(
			'color' => '.brpt h2,.breadcumb-inner h2'
		)
    ),     
    array(
     'id'          => 'cleaninganything_breadcrumb_typography',
     'type'        => 'typography', 
     'title'       => esc_html__('Breadcrumb Text And Font style', 'cleaninganything'),
     'google'      => true, 
     'font-backup' => true,
     'line-height'   => false,
     'text-align'   => false,
     'output'      => array('
      .breadcumb-inner ul,     
      .breadcumb-inner ul span a,     
      .breadcumb-inner li,
      .breadcumb-inner li a      
     '),
     'units'       =>'px',
     'subtitle'    => esc_html__('Typography option with each property can be called individually.', 'cleaninganything'),
     'default'     => array(
		  'color'       => '', 
		  'font-style'  => '', 
		  'font-family' => '', 
		  'google'      => true,
		  'font-size'   => '', 
		 ),
	),
	array(        
		'id'        => 'cleaninganything_bread_current_page_color',
		'type'      => 'color',
		'title'     => esc_html__('Breadcrumb Current Text Color', 'cleaninganything'),
		'default'  => '',
		'output'    => array(
			'color' => '.breadcumb-inner li:nth-last-child(-n+1)'
		)
	),     
    array(
     'id'             => 'spacing',
     'type'           => 'spacing',
     'output'         => array('.breadcumb-area'),
     'mode'           => 'padding',
     'units'          => array('em', 'px'),
     'units_extended' => 'false',
     'title'          => esc_html__('Padding Option', 'cleaninganything'),
     'subtitle'       => esc_html__('Allow your users to choose the spacing or margin they want.', 'cleaninganything'),
     'desc'           => esc_html__('You can enable or disable any piece of this field. Top, Right, Bottom, Left, or Units.', 'cleaninganything'),
     'default'            => array(
      'padding-top'     => '', 
      'padding-right'   => '', 
      'padding-bottom'  => '', 
      'padding-left'    => '',
      'units'          => 'px', 
     )
    ),    
        
            ),
    ) );
/*========================
END cleaninganything BREADCRUMB FIELD
=========================*/


/*========================
cleaninganything circle FIELD
=========================*/
    Redux::setSection( $opt_name, array(
         'title'     => esc_html__('Default Color', 'cleaninganything'),
        'id'         => 'cleaninganything_tm_defaultpage',  
        'icon'       => 'el el-circle-arrow-right',
        'fields'    => array(
				array(
				 'id'   => 'thdfinfo_normal',
				 'type' => 'info',
				 'desc' => esc_html__('Notice:- we set our all color option in our Element, But only contact button and scroll button color will be change by below option','cleaninganything')
				),  

				array(        
					'id'        => 'thdefhbgctc',
					'type'      => 'color',
					'title'     => esc_html__('Contact Button Text Color', 'cleaninganything'),
					'default'  => '',
					'output'    => array(
						'color' => '.home-2 .sbuton,.sbuton,#scrollUp'
					)
				),
				array(        
					'id'        => 'thdefhbgcbtbgh',
					'type'      => 'color',
					'title'     => esc_html__('Contact Button BG Color', 'cleaninganything'),
					'default'  => '',
					'output'    => array(
						'background' => '.home-2 .sbuton,.sbuton,#scrollUp',
						'border-color' => '.home-2 .sbuton,.sbuton,#scrollUp'
					)
				),				array(        
					'id'        => 'thdefhbgcbth',
					'type'      => 'color',
					'title'     => esc_html__('Contact Button Hover BG Color', 'cleaninganything'),
					'default'  => '',
					'output'    => array(
						'background' => '.home-2 .sbuton:hover,.sbuton:hover',
						'border-color' => '.home-2 .sbuton:hover,.sbuton:hover'
					)
				),
				array(        
					'id'        => 'tmdfhtcbtnht',
					'type'      => 'color',
					'title'     => esc_html__('Contact Button Hover Text Color', 'cleaninganything'),
					'default'  => '',
					'output'    => array(
						'color' => '.home-2 .sbuton:hover,.sbuton:hover'
					)
				),						
				
				

        ),
    ) );
/*========================
END cleaninganything circle FIELD
=========================*/

/*========================
cleaninganything BLOG FIELD
=========================*/
    Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Blog Area', 'cleaninganything' ),
        'id'          => 'cleaninganything_blog_section_area',
		'icon'		=> 'el el-circle-arrow-right',
        'fields'     => array(
                array(
                    'id'        => 'cleaninganything_blog_bgcolor',
                    'type'      => 'background',
                    'output'    => array('.cleaninganything-single-blog'),
                    'title'     => esc_html__('Blog Item BG Color', 'cleaninganything'),
                    'subtitle'  => esc_html__('BG color', 'cleaninganything'),
                    'default'  => array(
                        'background-color' => '',
                    )
                ),

                array(								
                    'id'        => 'cleaninganything_blog_title_color',
                    'type'      => 'color',
                    'title'     => esc_html__('Blog Title Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
					'color' => '
						.blog-content h1, .blog-content h2, .blog-content h3, .blog-content h4, .blog-content h5, .blog-content h6,					
						.single-blog-content h1, .single-blog-content h2, .single-blog-content h3, .single-blog-content h4, .single-blog-content h5, .single-blog-content h6,
						.blog-content h2 a,.blog-left-side .widget h2,.blog-page-title a					
					')
                ),	
                array(								
                    'id'        => 'cleaninganything_blog_title_hover_color',
                    'type'      => 'color',
                    'title'     => esc_html__('Blog Title Hover Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
					'color' => '
					.blog-content h2 a:hover,
					.blog-page-title h2 a:hover
					')
                ),													
                array(
                    'id'        => 'cleaninganything_blog_widget_bgcolor',
                    'type'      => 'background',
                    'output'    => array('.blog-left-side.widget > div'),
                    'title'     => esc_html__('Blog Sidebar BG Color', 'cleaninganything'),
                    'subtitle'  => esc_html__('BG color', 'cleaninganything'),
                    'default'  => array(
                        'background-color' => '',
                    )
                ),
				 array(	
                    'id'        => 'cleaninganything_sidebar_widgett_text_color',
                    'type'      => 'color',
                    'title'     => esc_html__('Sidebar Title Text Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
						'color' => '.blog-left-side .widget h2'
					)
                ),
                array(								
                    'id'        => 'cleaninganything_sidebar_widget_li_color',
                    'type'      => 'color',
                    'title'     => esc_html__('Sidebar Text Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
						'color' => '
							.blog-left-side .widget ul li,
							.blog-left-side .widget ul li a,
							.blog-left-side .widget ul li::before,
							.tagcloud a,
							caption,
							table,
							 table td a,
							cite,
							.rssSummary,
							span.rss-date,
							span.comment-author-link,
							.textwidget p,
							.widget .screen-reader-text
						')
                ),	
                array(								
                    'id'        => 'cleaninganything_sidebar_widget_li_hover_color',
                    'type'      => 'color',
                    'title'     => esc_html__('Sidebar Text Hover Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
						'color' => '
							.blog-left-side .widget ul li a:hover,
							.blog-left-side .widget ul li:hover::before
						')
                ),					
                array(								
                    'id'        => 'cleaninganything_blog_social_icon_color',
                    'type'      => 'color',
                    'title'     => esc_html__('Single Blog Social Icon & Title bar Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
					'color' => '.cleaninganything-single-icon-inner a,.reply_date span.span_right,.cleaninganything_btn',
					'border-color' => '.cleaninganything-single-icon-inner a,.cleaninganything_btn',
					'background' => '.blog-left-side .widget h2::before,.commment_title h3::before,table#wp-calendar td#today,.footer-middle .widget h2::before',
					)
                ),
				array(								
                    'id'        => 'cleaninganything_blog_social_hover_color',
                    'type'      => 'color',
                    'title'     => esc_html__('Single Blog Social Icon Hover Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
					'background-color' => '.cleaninganything-single-icon-inner a:hover,.cleaninganything_btn:hover',
					'border-color' => '.cleaninganything-single-icon-inner a:hover,.cleaninganything_btn:hover',
					)
                ),
				
				array(								
                    'id'        => 'cleaninganything_blog_pagina_color',
                    'type'      => 'color',
                    'title'     => esc_html__('Pagination Text Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
					'color' => '.paginations a',
					'border-color' => '.paginations a',
					)
                ),				
				
				array(								
                    'id'        => 'cleaninganything_blog_pagina_hover_color',
                    'type'      => 'color',
                    'title'     => esc_html__('Pagination Hover Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
					'background-color' => '.paginations a:hover, .paginations a.current, .page-numbers span.current',
					'border-color' => '.paginations a:hover, .paginations a.current, .page-numbers span.current',
					)
                ),					
				array(
                    'id'        => 'cleaninganything_blog_socialsharesh_hide',
                    'type'      => 'switch',
                    'title'     => esc_html__('Blog Social share Show/Hide', 'cleaninganything'),
                    'default'   => true,
                ),												
            )
    ) );		
/*========================
END cleaninganything BLOG FIELD
=========================*/
	 
/*========================
cleaninganything 404 FIELD
=========================*/	 

    Redux::setSection( $opt_name, array(
         'title'     => esc_html__('404 Area', 'cleaninganything'),
        'id'         => 'cleaninganything_error_page',  
        'desc'       => esc_html__('Use this section to upload background images, select background color', 'cleaninganything'),
        'icon'       => 'el-icon-picture',
        'fields'    => array(
                array(
                    'id'        => 'cleaninganything_background_404',
                    'type'      => 'background',
                    'output'    => array('.not-found-area'),
                    'title'     => esc_html__('404 Page Background Color', 'cleaninganything'),
                    'subtitle'  => esc_html__('404 background with image, color.', 'cleaninganything'),
                    'default'  => array(
                        'background-color' => '',
                    )
                ),
                array(								
                    'id'        => 'cleaninganything_not_title',
                    'type'      => 'color',
                    'title'     => esc_html__('Title Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
					'color' => '.not-found-inner h2,.not-found-inner'
					)
                ),	
                array(								
                    'id'        => 'cleaninganything_sub_not_title',
                    'type'      => 'color',
                    'title'     => esc_html__('Sub Title Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
					'color' => '.not-found-inner p,.not-found-inner strong'
					)
                ),
                array(								
                    'id'        => 'cleaninganything_not_link_color',
                    'type'      => 'color',
                    'title'     => esc_html__('Return Link Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
					'color' => '.not-found-inner a'
					)
                ),					
                array(
                    'id'        => '404_info',
                    'type'      => 'editor',
                    'title'     => esc_html__('404 Information', 'cleaninganything'),
                    'subtitle'  => esc_html__('HTML tags allowed: a, br, em, strong', 'cleaninganything'),
                    'default'   => esc_html__('404 Oops! The page you are Looking for does not exist. ', 'cleaninganything'),
					'desc'      => esc_html__('Please use title this way. example- <h2>404</h2> and text <p>your text</p>', 'cleaninganything'),
                ), 
				array(
					'id'             => 'cleaninganything_notfound_spacing',
					'type'           => 'spacing',
					'output'         => array('.not-found-area'),
					'mode'           => 'padding',
					'units'          => array('em', 'px'),
					'units_extended' => 'false',
					'title'          => esc_html__('Section Padding Option', 'cleaninganything'),
					'subtitle'       => esc_html__('Allow your users to choose the spacing or padding they want.', 'cleaninganything'),
					'desc'           => esc_html__('You can enable or disable any piece of this field. Top, Right, Bottom, Left, or Units.', 'cleaninganything'),
					'default'            => array(
						'padding-top'     => '', 
						'padding-right'   => '', 
						'padding-bottom'  => '', 
						'padding-left'    => '',
						'units'          => 'px', 
					)
				),

				
            ),
    ) );


/*========================
END cleaninganything NOT FOUND FIELD
=========================*/	 
/*========================
cleaninganything Shop FIELD
=========================*/
if( class_exists( 'WooCommerce' ) ) {

    Redux::setSection( $opt_name, array(
         'title'     => esc_html__('Shop Area', 'cleaninganything'),
        'id'         => 'cleaninganything_woocom_page',  
        'desc'       => esc_html__('Set your shop style option here', 'cleaninganything'),
        'icon'       => 'el-icon-picture',
        'fields'    => array(
			   /* Title And Price box color area */
                array(								
                    'id'        => 'cleaninganything_woocommerce_count',
                    'type'      => 'color',
                    'title'     => esc_html__('Showing Count Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
					'color' => '.woocommerce .woocommerce-result-count, .nice-select span.current,.nice-select .option'
					)
                ),				   
			   
               array(
                    'id'        => 'cleaninganything_background_woocommerce',
                    'type'      => 'background',
                    'output'    => array('.tbd_product_content'),
                    'title'     => esc_html__('Background Color', 'cleaninganything'),
                    'subtitle'  => esc_html__('background, color.', 'cleaninganything'),
                    'default'  => array(
                        'background-color' => '',
                    )
                ),
                array(								
                    'id'        => 'cleaninganything_woocommerce_title',
                    'type'      => 'color',
                    'title'     => esc_html__('Title Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
					'color' => '.tbd_product_title h2,.woocommerce div.product .product_title'
					)
                ),	
                array(								
                    'id'        => 'cleaninganything_price_woocommerce',
                    'type'      => 'color',
                    'title'     => esc_html__('Price Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
					'color' => '.woocommerce div.product p.price, .woocommerce div.product span.price, .woocommerce div.product p.price, .woocommerce div.product span.price, .woocommerce div.product p.price ins, .woocommerce div.product span.price ins'
					)
                ),					 
				array(
					'id'             => 'cleaninganything_woocommerce_spacing',
					'type'           => 'spacing',
					'output'         => array('.tbd_product_content'),
					'mode'           => 'padding',
					'units'          => array('em', 'px'),
					'units_extended' => 'false',
					'title'          => esc_html__('Title And Price Box Padding Option', 'cleaninganything'),
					'subtitle'       => esc_html__('Allow your users to choose the spacing or padding they want.', 'cleaninganything'),
					'desc'           => esc_html__('You can enable or disable any piece of this field. Top, Right, Bottom, Left, or Units.', 'cleaninganything'),
					'default'            => array(
						'padding-top'     => '', 
						'padding-right'   => '', 
						'padding-bottom'  => '', 
						'padding-left'    => '',
						'units'          => 'px', 
					)
				),
				
				/* Button Text color area*/
				array(
                    'id'       => 'cleaninganything_woocommerce_button',
                    'type'     => 'text',
                    'title'    => esc_html__('Add to cart Text', 'cleaninganything'),
                    'desc' => esc_html__('Change add to cart button text', 'cleaninganything'),
					'default'	=> esc_html__('Add to cart', 'cleaninganything'),					
                ),
                array(								
                    'id'        => 'cleaninganything_Button_color_wooco',
                    'type'      => 'color',
                    'title'     => esc_html__('Button Text Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
					'color' => '.woocommerce .witr_product_cart button.button:disabled, .woocommerce .witr_product_cart button.button:disabled[disabled], .woocommerce .witr_product_cart button, .woocommerce .witr_cart_to_cross a.checkout-button.alt, .woocommerce .witr_checkout_form button.button.alt, .woocommerce a.button.wc-backward, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button,.woocommerce a.added_to_cart,.woocommerce a.added_to_cart:hover,.woocommerce div.product form.cart .button,.woocommerce div.product .woocommerce-tabs ul.tabs li.active a,.cleaninganything_btn,.witr_cart_to_cross .cart_totals > h2,.witr_checkout_form .witr_ck_blling h3, .witr_checkout_form h3#order_review_heading, h2.woocommerce-order-details__title,.woocommerce-column__title,nav.woocommerce-MyAccount-navigation ul li.is-active,.paginations a:hover, .paginations a.current, .page-numbers span.current,.curosel-style .owl-nav div,.curosel-style .owl-nav .owl-prev:hover,.curosel-style .owl-nav .owl-next:hover'
					)
                ),
              array(								
                    'id'        => 'cleaninganything_Buttonht_woocommerce',
                    'type'      => 'color',
                    'title'     => esc_html__('Button Text Hover Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
					'color' => '.woocommerce .witr_cart_to_cross a.checkout-button.alt:hover, .woocommerce .witr_product_cart button:hover, .woocommerce a.button.wc-backward:hover, .woocommerce .witr_checkout_form button.button.alt:hover .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover, .woocommerce a.button:hover,.woocommerce div.product form.cart .button,.cleaninganything_btn:hover'
					)
                ),				
                array(								
                    'id'        => 'cleaninganything_Button_bgw',
                    'type'      => 'color',
                    'title'     => esc_html__('Button BG Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
					'background-color' => '.woocommerce .witr_product_cart button.button:disabled, .woocommerce .witr_product_cart button.button:disabled[disabled], .woocommerce .witr_product_cart button, .woocommerce .witr_cart_to_cross a.checkout-button.alt, .woocommerce .witr_checkout_form button.button.alt, .woocommerce a.button.wc-backward, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button,.woocommerce a.added_to_cart,.woocommerce a.added_to_cart:hover,.woocommerce div.product form.cart .button,.woocommerce div.product .woocommerce-tabs ul.tabs li.active,.cleaninganything_btn,.witr_cart_to_cross .cart_totals > h2,.witr_checkout_form .witr_ck_blling h3, .witr_checkout_form h3#order_review_heading, h2.woocommerce-order-details__title,.woocommerce-column__title,nav.woocommerce-MyAccount-navigation ul li.is-active,.paginations a:hover, .paginations a.current, .page-numbers span.current,.curosel-style .owl-nav div,.curosel-style .owl-nav .owl-prev:hover,.curosel-style .owl-nav .owl-next:hover',
					
					'border-left-color' => 'nav.woocommerce-MyAccount-navigation ul li.is-active:after',
					'border-color' => '.woocommerce .witr_product_cart button.button:disabled, .woocommerce .witr_product_cart button.button:disabled[disabled], .woocommerce .witr_product_cart button, .woocommerce .witr_cart_to_cross a.checkout-button.alt, .woocommerce .witr_checkout_form button.button.alt, .woocommerce a.button.wc-backward, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button,.woocommerce a.added_to_cart,.woocommerce a.added_to_cart:hover,.woocommerce div.product form.cart .button,.cleaninganything_btn,.witr_cart_to_cross .cart_totals > h2,.witr_checkout_form .witr_ck_blling h3, .witr_checkout_form h3#order_review_heading, h2.woocommerce-order-details__title,.woocommerce-column__title,nav.woocommerce-MyAccount-navigation ul li.is-active,.paginations a:hover, .paginations a.current, .page-numbers span.current,.curosel-style .owl-nav div,.curosel-style .owl-nav .owl-prev:hover,.curosel-style .owl-nav .owl-next:hover',
					
					)
                ),

                array(								
                    'id'        => 'cleaninganything_Buttonhtb_bgwh',
                    'type'      => 'color',
                    'title'     => esc_html__('Button BG Hover Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
					
					'background-color' => '.woocommerce .witr_cart_to_cross a.checkout-button.alt:hover, .woocommerce .witr_product_cart button:hover, .woocommerce a.button.wc-backward:hover, .woocommerce .witr_checkout_form button.button.alt:hover .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover, .woocommerce a.button:hover,.woocommerce div.product form.cart .button,.cleaninganything_btn:hover',
					
					'border-color' => '.woocommerce .witr_cart_to_cross a.checkout-button.alt:hover, .woocommerce .witr_product_cart button:hover, .woocommerce a.button.wc-backward:hover, .woocommerce .witr_checkout_form button.button.alt:hover .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover, .woocommerce a.button:hover,.woocommerce div.product form.cart .button,.cleaninganything_btn:hover'
					
					)
                ),							
				array(
					'id'             => 'w_btn_spacing',
					'type'           => 'spacing',
					'output'         => array('.woocommerce .witr_product_cart button.button:disabled, .woocommerce .witr_product_cart button.button:disabled[disabled], .woocommerce .witr_product_cart button, .woocommerce .witr_cart_to_cross a.checkout-button.alt, .woocommerce .witr_checkout_form button.button.alt, .woocommerce a.button.wc-backward, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button,.woocommerce a.added_to_cart'),
					'mode'           => 'padding',
					'units'          => array('em', 'px'),
					'units_extended' => 'false',
					'title'          => esc_html__('Button Padding Option', 'cleaninganything'),
					'subtitle'       => esc_html__('Allow your users to choose the spacing or padding they want.', 'cleaninganything'),
					'desc'           => esc_html__('You can enable or disable any piece of this field. Top, Right, Bottom, Left, or Units.', 'cleaninganything'),
					'default'            => array(
						'padding-top'     => '', 
						'padding-right'   => '', 
						'padding-bottom'  => '', 
						'padding-left'    => '',
						'units'          => 'px', 
					)
				),
				
                array(								
                    'id'        => 'cleaninganything_Button_color_sale',
                    'type'      => 'color',
                    'title'     => esc_html__('Sale Button Text Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
					'color' => '.woocommerce span.tbd_sale_inner,.woocommerce span.onsale.onsingle_sale.tbd_sale_inner '
					)
                ),			
                array(								
                    'id'        => 'cleaninganything_Button_bgsale',
                    'type'      => 'color',
                    'title'     => esc_html__('Sale Button BG Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
					'background-color' =>'.woocommerce span.tbd_sale_inner,.woocommerce span.onsale.onsingle_sale.tbd_sale_inner',
					'border-color' => '.woocommerce span.tbd_sale_inner,.woocommerce span.onsale.onsingle_sale.tbd_sale_inner'
					)
                ),
					
				
				
            ),		
    ) );


	
}	
/*========================
END cleaninganything Shop FIELD
=========================*/	
/*========================
cleaninganything social FIELD
=========================*/	
    //footer social section
    Redux::setSection( $opt_name, array(
        'title'      => esc_html__( ' Social Icon Section', 'cleaninganything' ),
        'id'         => 'cleaninganything_social_icons_sec',
		'icon'		=> 'el el-circle-arrow-right',
        'fields'     => array(
	
                array(
                    'id'       => 'cleaninganything_social_icons',
                    'type'     => 'sortable',
                    'title'    => esc_html__('Insert Social Icons', 'cleaninganything'),
                    'subtitle' => esc_html__('Enter social links', 'cleaninganything'),
                    'desc'     => esc_html__('Drag/drop to re-arrange', 'cleaninganything'),
                    'mode'     => 'text',
					'label'    => true,
                    'options'  => array(        
                        'facebook-f'     => '',
                        'twitter'      => '',
                        'instagram'    => '',
                        'tumblr'       => '',
                        'pinterest-p'    => '',
                        'google-plus-g'  => '',
                        'linkedin-in'     => '',
                        'behance'      => '',
                        'dribbble'     => '',
                        'youtube'      => '',
                        'vimeo-v'        => '',
                        'apple'          => '',
                   
                    ),
					'default' => array(
						'facebook-f'     => esc_url('#'),
						'twitter'     => esc_url('#'),
						'instagram'	=> esc_url('#'),
						'tumblr'     => '',
						'pinterest-p'     => '',
						'google-plus-g'     => esc_url('#'),
						'linkedin-in'     => '',
						'behance'     => '',
						'dribbble'     => esc_url('#'),
						'youtube'     => '',
						'vimeo-v'     => '',
						'apple'     => '',
					
					),
                ),			
                array(								
                    'id'        => 'cleaninganything_social_icon_color',
                    'type'      => 'color',
                    'title'     => esc_html__('Social Icon Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
					'color' => '.footer-social-icon a i,.footer-social-icon.htop-menu-s a i,.em_slider_social a,.top_crmenu_i_list li a i',
					)
                ),
                array(								
                    'id'        => 'cleaninganything_social_icon_bgcolor',
                    'type'      => 'color',
                    'title'     => esc_html__('Social Icon BG Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
					'border-color' => '.footer-social-icon a i,.footer-social-icon.htop-menu-s a i,.em_slider_social a',
					'background-color' => '.footer-social-icon a i,.footer-social-icon.htop-menu-s a i,.em_slider_social a,.top_crmenu_i_list li a i',
					)
                ),
                array(								
                    'id'        => 'cleaninganything_social_icon_thbgcolor',
                    'type'      => 'color',
                    'title'     => esc_html__('Social Icon hover Text Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
					'color' => '.footer-social-icon a i:hover,.footer-social-icon.htop-menu-s a i:hover,.em_slider_social a:hover,.top_crmenu_i_list li a i:hover',
					)
                ),					
                array(								
                    'id'        => 'cleaninganything_social_icon_hbgcolor',
                    'type'      => 'color',
                    'title'     => esc_html__('Social Icon hover BG Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
					'border-color' => '.footer-social-icon a i:hover,.footer-social-icon.htop-menu-s a i:hover,.em_slider_social a:hover,.em_slider_social a:hover',
					'background-color' => '.footer-social-icon a i:hover,.footer-social-icon.htop-menu-s a i:hover,.em_slider_social a:hover,.em_slider_social a:hover,.top_crmenu_i_list li a i:hover',
					)
                ),					
                /*array(								
                    'id'        => 'cleaninganything_social_bg2_color',
                    'type'      => 'background',
                    'title'     => esc_html__('Social Section BG Color', 'cleaninganything'),
                    'default'  => '',
                    'output'    => array('
						.footer-top
					'),
					'default'  => array(
						'background-color' => '',
					)					
                ),	*/										
				
            )
    ) );

 
/*========================
cleaninganything FOOTER FIELD
=========================*/	 
	
      //Footer area
    Redux::setSection( $opt_name, array(
        'title'     => esc_html__('Footer Area', 'cleaninganything'),
        'id'        => 'footer_area_id',
        'desc'      => esc_html__('Insert style for top address area', 'cleaninganything'),
        'icon'      => 'el-icon-cog',
        'fields'    => array(      
				 array(
                    'id'       => 'cleaninganything_address_hide',
                    'type'     => 'switch',
                    'title'    => esc_html__('Footer Address Section Show/Hide', 'cleaninganything'),
                    'default'  => false,
                ),
				array(
                    'id'       => 'cleaninganything_social_hide',
                    'type'     => 'switch',
                    'title'    => esc_html__('Footer Logo Section Show/Hide', 'cleaninganything'),
                    'default'  => false,
                ),
                 array(
                    'id'       => 'cleaninganything_widget_hide',
                    'type'     => 'switch',
                    'title'    => esc_html__('Widget Section Hide/show', 'cleaninganything'),
                    'default'  => false,
                ),				
				array(
                    'id'       => 'cleaninganything_copyright_hide',
                    'type'     => 'switch',
                    'title'    => esc_html__('Copyright Section Show/Hide', 'cleaninganything'),
					'desc'      => esc_html__('If you not show copyright section true or on. Then It will be show default widget and copyright option', 'cleaninganything'),	
                    'default'  => true,
                ),
                array(
                    'id'        => 'cleaninganything_footer_box_layout',
                    'type'      => 'select',
                    'title'     => esc_html__('Select Footer layout', 'cleaninganything'),
                    'customizer_only'   => false,
                    'options'   => array(
                        'footer_box' => esc_html__('Box Layout','cleaninganything'),
                        'footer_full' => esc_html__('Full Layout','cleaninganything'),
                    ),
                    'default'   => 'footer_box'
                ),							
								
            )
    ) );

	 //footer Address Section 
    Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Footer Address Section', 'cleaninganything' ),
        'id'          => 'cleaninganything_address_section',
        'subsection' => true,
		'icon'		=> 'el el-circle-arrow-right',
        'fields'     => array(
		
                array(
                    'id'        => 'cleaninganything_address_logo_style',
                    'type'      => 'select',
                    'title'     => esc_html__('Select Logo Style', 'cleaninganything'),
                    'customizer_only'   => false,
                    'options'   => array(
                        's_logo_s1' => esc_html__('Show Text Logo','cleaninganything'),
                        's_logo_s2' => esc_html__('Show Image Logo','cleaninganything'),
                    ),
                    'default'   => 's_logo_s1'
                ),				
						
                array(
                    'id'        => 'cleaninganything_address_title_text',
                    'type'      => 'text',
                    'title'     => esc_html__('Address Title Text Logo', 'cleaninganything'),
                    'default'   => esc_html__('cleaninganything', 'cleaninganything'),
                    'desc'      => esc_html__('Please set this way for different color. ex-  A<span>S</span>T<span>U</span>T<span>E</span>', 'cleaninganything'),					
                ),
                array(
                    'id'        => 'cleaninganything_address_logo',
                    'type'      => 'media',
                    'title'     => esc_html__('Address Image Logo', 'cleaninganything'),
                    'compiler'  => 'true',
                    'mode'      => false,
                    'desc'      => esc_html__('Upload logo here. recommend size:- 220x50px. Notice:- If you upload this logo, Title text logo will be hide ', 'cleaninganything'),
                ),			
                array(
                    'id'       => 'cleaninganything_address_road',
                    'type'     => 'text',
                    'title'    => esc_html__('Address Area Name', 'cleaninganything'),
                    'desc' => esc_html__('insert area name ex:- house, road-4.', 'cleaninganything'),
					'default'	=> esc_html__('1st Floor New World Tower Rang.', 'cleaninganything'),
                ),		
                array(
                    'id'       => 'cleaninganything_address_email',
                    'type'     => 'text',
                    'title'    => esc_html__('Email Number', 'cleaninganything'),
                    'desc' => esc_html__('Insert email number', 'cleaninganything'),
					'default'	=> esc_html__('demo@example.com', 'cleaninganything'),					
                ),		
                array(
                    'id'       => 'cleaninganything_address_mobile',
                    'type'     => 'text',
                    'title'    => esc_html__('Phone Number', 'cleaninganything'),
                    'desc' => esc_html__('Insert phone number', 'cleaninganything'),
					'default'	=> esc_html__('+998 556 778 345', 'cleaninganything'),					
                ),			
                array(								
                    'id'        => 'cleaninganything_address_title_text_color',
                    'type'      => 'color',
                    'title'     => esc_html__('Address Title Text Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
					'color' => '.footer-top-address h2'
					)
                ),
                array(								
                    'id'        => 'cleaninganything_address_title2_text_color',
                    'type'      => 'color',
                    'title'     => esc_html__('Address Title Text Color 2', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
					'color' => '.footer-top-address h2 span'
					)
                ),				
                array(								
                    'id'        => 'cleaninganything_address_text_color',
                    'type'      => 'color',
                    'title'     => esc_html__('Address Text Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
					'color' => '.top_address_content a,.top_address_content span'
					)
                ),				
                array(								
                    'id'        => 'cleaninganything_address_bg_color',
                    'type'      => 'background',
                    'title'     => esc_html__('Address Section BG Color', 'cleaninganything'),
                    'default'  => '',
                    'output'    => array('
						.top-address-area
					'),
					'default'  => array(
						'background-color' => '',
					)					
                ),							
				array(
					'id'             => 'cleaninganything_address_section_spacing',
					'type'           => 'spacing',
					'output'         => array('.top-address-area'),
					'mode'           => 'padding',
					'units'          => array('em', 'px'),
					'units_extended' => 'false',
					'title'          => esc_html__('Padding Option', 'cleaninganything'),
					'subtitle'       => esc_html__('Allow your users to choose the spacing padding they want.', 'cleaninganything'),
					'desc'           => esc_html__('You can enable or disable any piece of this field. Top, Right, Bottom, Left, or Units.', 'cleaninganything'),
					'default'            => array(
						'padding-top'     => '', 
						'padding-right'   => '', 
						'padding-bottom'  => '', 
						'padding-left'    => '',
						'units'          => 'px', 
					)
				),						
            )
    ) );
    //footer logo section
    Redux::setSection( $opt_name, array(
        'title'      => esc_html__( ' Footer Logo Section', 'cleaninganything' ),
        'id'         => 'cleaninganything_social_section',
		'icon'		=> 'el el-circle-arrow-right',
        'subsection' => true,
        'fields'     => array(
                array(
                    'id'        => 'cleaninganything_social_logo_style',
                    'type'      => 'select',
                    'title'     => esc_html__('Select Logo Style', 'cleaninganything'),
                    'customizer_only'   => false,
                    'options'   => array(
                        's_logo_s1' => esc_html__('Show Text Logo','cleaninganything'),
                        's_logo_s2' => esc_html__('Show Image Logo','cleaninganything'),
                    ),
                    'default'   => 's_logo_s1'
                ),				
						
                array(
                    'id'        => 'cleaninganything_social_title_text',
                    'type'      => 'text',
                    'title'     => esc_html__('Footer Title Text Logo', 'cleaninganything'),
                    'default'   => esc_html__('cleaninganything', 'cleaninganything'),
                    'desc'      => esc_html__('Please set this way for different color. ex-  A<span>S</span>T<span>U</span>T<span>E</span>', 'cleaninganything'),
                ),
                array(
                    'id'        => 'cleaninganything_social_logo',
                    'type'      => 'media',
                    'title'     => esc_html__('Footer Image Logo', 'cleaninganything'),
                    'compiler'  => 'true',
                    'mode'      => false,
                    'desc'      => esc_html__('Upload logo here. recommend size:- 220x50px. Notice:- If you upload this logo, Title text logo will be hide ', 'cleaninganything'),
                ),				
                array(
                    'id'        => 'cleaninganything_social_text',
                    'type'      => 'editor',
                    'title'     => esc_html__('Footer logo section information', 'cleaninganything'),
                    'default'	=> esc_html__('Lorem ipsum dolor sit amet, consectetur ahkl adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud' , 'cleaninganything'),
                    'args'      => array(
                        'teeny'            => true,
                        'textarea_rows'    => 5,
                        'media_buttons' => false,
                    )
                ),		
                array(								
                    'id'        => 'cleaninganything_social_title_text_color',
                    'type'      => 'color',
                    'title'     => esc_html__('Footer logo section Title Text Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
						'color' => '.footer-top-inner h2'
					)
                ),
                array(								
                    'id'        => 'cleaninganything_social_title2_text_color',
                    'type'      => 'color',
                    'title'     => esc_html__('Footer logo section Title Text Color 2', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
						'color' => '.footer-top-inner h2 span'
					)
                ),				
                array(								
                    'id'        => 'cleaninganything_social_text_color',
                    'type'      => 'color',
                    'title'     => esc_html__('Footer log section Text Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
					'color' => '.footer-top-inner p'
					)
                ),								
                array(								
                    'id'        => 'cleaninganything_social_bg_color',
                    'type'      => 'background',
                    'title'     => esc_html__('Footer logo Section BG Color', 'cleaninganything'),
                    'default'  => '',
                    'output'    => array('
						.footer-top
					'),
					'default'  => array(
						'background-color' => '',
					)					
                ),							
				array(
					'id'             => 'cleaninganything_social_section_spacing',
					'type'           => 'spacing',
					'output'         => array('.footer-top'),
					'mode'           => 'padding',
					'units'          => array('em', 'px'),
					'units_extended' => 'false',
					'title'          => esc_html__('Padding Option', 'cleaninganything'),
					'subtitle'       => esc_html__('Allow your users to choose the spacing padding they want.', 'cleaninganything'),
					'desc'           => esc_html__('You can enable or disable any piece of this field. Top, Right, Bottom, Left, or Units.', 'cleaninganything'),
					'default'            => array(
						'padding-top'     => '', 
						'padding-right'   => '', 
						'padding-bottom'  => '', 
						'padding-left'    => '',
						'units'          => 'px', 
					)
				),					
				
            )
    ) );
	 // footer widget area 
    Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Footer Widget Section', 'cleaninganything' ),
        'id'          => 'cleaninganything_widget_section',
        'subsection' => true,
		'icon'		=> 'el el-circle-arrow-right',
        'fields'     => array(
                array(								
                    'id'        => 'cleaninganything_wmb_bg_color',
                    'type'      => 'background',
                    'title'     => esc_html__('Together Widget and Cppyright Section BG Color', 'cleaninganything'),
                    'default'  => '',
                    'output'    => array('
									.witrfm_area
								'),
					'default'  => array(
						'background-color' => '',
					)					
                ),
				array(								
					'id'        => 'cleaninganything_wmbov_bg_color',
					'type'      => 'color_rgba',
					'title'     => esc_html__('Widget and Cppyright Overlay', 'cleaninganything'),
					'default'   => array(
						'color'     => '#00509f',
						'alpha'     => 0
					),
					'output'    => array(
					'background-color' => '
					.witrfm_area:before
					'
					)
				),				
                array(
                    'id'        => 'cleaninganything_widget_column_count',
                    'type'      => 'select',
                    'title'     => esc_html__('Widget Column Count', 'cleaninganything'),
                    'customizer_only'   => false,
                    'options'   => array(
                        '1' => esc_html__('Column 1','cleaninganything'),
                        '2' => esc_html__('Column 2','cleaninganything'),
                        '3' => esc_html__('Column 3','cleaninganything'),
                        '4' => esc_html__('Column 4','cleaninganything'),
                        '6' => esc_html__('Column 6','cleaninganything'),
                    ),
                    'default'   =>'4'
                ),		
				 array(	
                    'id'        => 'cleaninganything_widgett_text_color',
                    'type'      => 'color',
                    'title'     => esc_html__('Widget Title Text Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
						'color' => '.footer-middle .widget h2'
					)
                ),
                array(								
                    'id'        => 'cleaninganything_copyright_widget_li_color',
                    'type'      => 'color',
                    'title'     => esc_html__('Widget Text Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
						'color' => '
							.footer-middle .widget ul li,
							.footer-middle .widget ul li a,
							.footer-middle .widget ul li::before,
							.footer-middle .tagcloud a,
							.footer-middle caption,
							.footer-middle table,
							.footer-middle table td a,
							.footer-middle cite,
							.footer-middle .rssSummary,
							.footer-middle span.rss-date,
							.footer-middle span.comment-author-link,
							.footer-middle .textwidget p,
							.footer-middle .widget .screen-reader-text,
							mc4wp-form-fields p,
							.mc4wp-form-fields,
							.footer-m-address p,
							.footer-m-address,
							.footer-widget.address,
							.footer-widget.address p,
							.mc4wp-form-fields p,
							.cleaninganything-description-area p, 
							.cleaninganything-description-area .phone a,
							.cleaninganything-description-area .social-icons a,
							.recent-review-content h3,
							.recent-review-content h3 a,
							.recent-review-content p,
							.footer-middle .cleaninganything-description-area p,
							.footer-middle .recent-post-text h4 a,
							.footer-middle .recent-post-text .rcomment,
							.witr_sub_table span
							
						')
                ),	
                array(								
                    'id'        => 'cleaninganything_copyright_widget_li_hover_color',
                    'type'      => 'color',
                    'title'     => esc_html__('Widget Text Hover Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
						'color' => '
							.footer-middle .widget ul li a:hover,
							.footer-middle .widget ul li:hover::before,
							.footer-middle .sub-menu li a:hover, 
							.footer-middle .nav .children li a:hover,
							.footer-middle .tagcloud a:hover,
							#today
						')
                ),		
				array(								
                    'id'        => 'cleaninganything_widget_bg_color',
                    'type'      => 'background',
                    'title'     => esc_html__('Widget Section BG Color', 'cleaninganything'),
                    'default'  => '',
                    'output'    => array('
									.footer-middle
								'),
					'default'  => array(
						'background-color' => '',
					)					
                ),	
				array(
					'id'             => 'cleaninganything_widget_section_spacing',
					'type'           => 'spacing',
					'output'         => array('.footer-middle'),
					'mode'           => 'padding',
					'units'          => array('em', 'px'),
					'units_extended' => 'false',
					'title'          => esc_html__('Padding Option', 'cleaninganything'),
					'subtitle'       => esc_html__('Allow your users to choose the spacing padding they want.', 'cleaninganything'),
					'desc'           => esc_html__('You can enable or disable any piece of this field. Top, Right, Bottom, Left, or Units.', 'cleaninganything'),
					'default'            => array(
						'padding-top'     => '', 
						'padding-right'   => '', 
						'padding-bottom'  => '', 
						'padding-left'    => '',
						'units'          => 'px', 
					)
				),
				
            )
    ) );	

    //footer copyright text
    Redux::setSection( $opt_name, array(
        'title'     => esc_html__('Footer Copyright Info', 'cleaninganything'),
        'id'        => 'cleaninganything_copyright',
        'desc'      => esc_html__('Insert your copyright style', 'cleaninganything'),
		'icon'		=> 'el el-circle-arrow-right',
        'subsection' => true,
        'fields'    => array(
                array(
                    'id'        => 'cleaninganything_footer_copyright_style',
                    'type'      => 'select',
                    'title'     => esc_html__('Copyright Style Layout', 'cleaninganything'),
                    'customizer_only'   => false,
                    'options'   => array(
                        'copy_s1' => esc_html__('Copyright Text Style','cleaninganything'),
                        'copy_s2' => esc_html__('Copyright Text and Right Menu','cleaninganything'),
                        'copy_s3' => esc_html__('Copyright Text and Left Menu','cleaninganything'),
                        'copy_s4' => esc_html__('Copyright Text and Social Icon','cleaninganything'),
                    ),
                    'default'   => 'copy_s2'
                ),
                array(								
                    'id'        => 'cleaninganything_wftp_color',
                    'type'      => 'background',
                    'title'     => esc_html__('Top Boeder Color', 'cleaninganything'),
                    'default'  => '',
                    'output'    => array('
						.footer-bottom:before
					'),
					'default'  => array(
						'background-color' => '',
					)					
                ),	
				
                array(
                    'id'        => 'cleaninganything_copyright_text',
                    'type'      => 'editor',
                    'title'     => esc_html__('Copyright information', 'cleaninganything'),
                    'subtitle'  => esc_html__('HTML tags allowed: a, br, em, strong', 'cleaninganything'),
                    'default'	=> esc_html__('Copyright &copy; cleaninganything all rights reserved.', 'cleaninganything'),
                    'args'      => array(
                        'teeny'            => true,
                        'textarea_rows'    => 5,
                        'media_buttons' => false,
                    )
                ),
                array(								
                    'id'        => 'cleaninganything_copyright_text_color',
                    'type'      => 'color',
                    'title'     => esc_html__('Copyright Text Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
					'color' => '.copy-right-text p,.footer-menu ul li a'
					)
                ),
                array(								
                    'id'        => 'cleaninganything_copyright_text_hover_color',
                    'type'      => 'color',
                    'title'     => esc_html__('Copyright Text Hover Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
					'color' => '.copy-right-text a, .footer-menu ul li a:hover'
					)
                ),				
                array(								
                    'id'        => 'cleaninganything_copyright_bg_color',
                    'type'      => 'background',
                    'title'     => esc_html__('Copyright Section BG Color', 'cleaninganything'),
                    'default'  => '',
                    'output'    => array('
					.footer-bottom
					'),
					'default'  => array(
						'background-color' => '',
					)					
                ),						
				
				array(
					'id'             => 'cleaninganything_copyright_section_spacing',
					'type'           => 'spacing',
					'output'         => array('.footer-bottom'),
					'mode'           => 'padding',
					'units'          => array('em', 'px'),
					'units_extended' => 'false',
					'title'          => esc_html__('Padding Option', 'cleaninganything'),
					'subtitle'       => esc_html__('Allow your users to choose the spacing padding they want.', 'cleaninganything'),
					'desc'           => esc_html__('You can enable or disable any piece of this field. Top, Right, Bottom, Left, or Units.', 'cleaninganything'),
					'default'            => array(
						'padding-top'     => '', 
						'padding-right'   => '', 
						'padding-bottom'  => '', 
						'padding-left'    => '',
						'units'          => 'px', 
					)
				),				

				
				
				
            ),
    ) );


/*========================
cleaninganything Shortcode Option FIELD
=========================*/	 

    Redux::setSection( $opt_name, array(
         'title'     => esc_html__('Shortcode Option', 'cleaninganything'),
        'id'         => 'cleaninganything_shortcode',  
        'desc'       => esc_html__('Use this section to Title,Content,Shortcode  And color Option', 'cleaninganything'),
        'icon'       => 'el-icon-picture',
        'fields'    => array(
				array(
                    'id'       => 'witr_show_hide_shortcode',
                    'type'     => 'switch',
                    'title'    => esc_html__('Shortcode Section Show/Hide', 'cleaninganything'),
                    'default'  => false,
                ),
                array(								
                    'id'        => 'cleaninganything_shortcode_bg_color',
                    'type'      => 'background',
                    'title'     => esc_html__(' Section BG Color', 'cleaninganything'),
                    'default'  => '',
                    'output'    => array('
					.witr_shortcode_inner'
					),
					'default'  => array(
						'background-color' => '',
					)					
                ),										
				array(
					'id'             => 'cleaninganything_shortcode_section_spacing',
					'type'           => 'spacing',
					'output'         => array('.witr_shortcode_inner'),
					'mode'           => 'padding',
					'units'          => array('em', 'px'),
					'units_extended' => 'false',
					'title'          => esc_html__(' Box Padding Option', 'cleaninganything'),
					'subtitle'       => esc_html__('Allow your users to choose the spacing padding they want.', 'cleaninganything'),
					'desc'           => esc_html__('You can enable or disable any piece of this field. Top, Right, Bottom, Left, or Units.', 'cleaninganything'),
					'default'            => array(
						'padding-top'     => '', 
						'padding-right'   => '', 
						'padding-bottom'  => '', 
						'padding-left'    => '',
						'units'          => 'px', 
					)
				),
				array(
					'id'             => 'cleaninganything_shortcode_section_margin',
					'type'           => 'spacing',
					'output'         => array('.witr_shortcode_inner'),
					'mode'           => 'margin',
					'units'          => array('em', 'px'),
					'units_extended' => 'false',
					'title'          => esc_html__(' Box Margin Option', 'cleaninganything'),
					'subtitle'       => esc_html__('Allow your users to choose the spacing margin they want.', 'cleaninganything'),
					'desc'           => esc_html__('You can enable or disable any piece of this field. Top, Right, Bottom, Left, or Units.', 'cleaninganything'),
					'default'            => array(
						'margin-top'     => '', 
						'margin-right'   => '', 
						'margin-bottom'  => '', 
						'margin-left'    => '',
						'units'          => 'px', 
					)
				),				
				
				/* title */	
				array(
					'title'     => esc_html__( 'Title Text', 'cleaninganything' ),
					'subtitle'  => esc_html__('HTML tags allowed: br,span', 'cleaninganything'),
					'id'        => 'witr_title_shortcode',
					'default'   => 'Add your title here',
					'type'      => 'text',
					'desc'       => esc_html__('Please use this way Example ex-<span>Add your text here</span>, <a href="#">text</a>, </br>', 'cleaninganything'),
				),				
				array(
				 'id'          => 'cleaninganything_shortcode_color',
				 'type'        => 'typography', 
				 'title'       => esc_html__('Title Typography', 'cleaninganything'),
				 'google'      => true, 
				 'font-backup' => true,
				 'line-height'   => false,
				 'text-align'   => false,
				 'units'       =>'px',
				 'subtitle'    => esc_html__('Typography option with each property can be called individually.', 'cleaninganything'),
				 'default'     => array(
					  'color'       => '', 
					  'font-style'  => '', 
					  'font-family' => '', 
					  'google'      => true,
					  'font-size'   => '', 
					 ),
				 'output'      => array('
				  .shortcode_content h2'      
				 ),					 
				),				
                array(								
                    'id'        => 'cleaninganything_shortcode_hover_color',
                    'type'      => 'color',
                    'title'     => esc_html__('Title Hover Color', 'cleaninganything'),
                    'default'  => '',
					'output'    => array(
					'color' => '.shortcode_content h2:hover'
					)
                ),				
				
				/* Content */	
                array(
                    'id'        => 'witr_content_shortcode',
                    'type'      => 'textarea',
                    'title'     => esc_html__('Content Text', 'cleaninganything'),
                    'subtitle'  => esc_html__('HTML tags allowed: a, br, em, strong,span,b', 'cleaninganything'),
                    'default'   => esc_html__('Lorem ipsum dolor sit met conjectural ', 'cleaninganything'),
					'desc'       => esc_html__('Please use this way Example ex-<span>text</span>, <a href="#">text</a>, <strong>text</strong>, <em>text</em>, <b>text</b>, </br>', 'cleaninganything'),
                ),
				array(
				 'id'          => 'cleaninganything_short_typo_content',
				 'type'        => 'typography', 
				 'title'       => esc_html__('Content Typography', 'cleaninganything'),
				 'google'      => true, 
				 'font-backup' => true,
				 'line-height'   => false,
				 'text-align'   => false,
				 'units'       =>'px',
				 'subtitle'    => esc_html__('Typography option with each property can be called individually.', 'cleaninganything'),
				 'default'     => array(
					  'color'       => '', 
					  'font-style'  => '', 
					  'font-family' => '', 
					  'google'      => true,
					  'font-size'   => '', 
					 ),
				 'output'      => array('
				  .shortcode_content p'      
				 ),					 
				),


				/* Shortcode */
				array(
					'title'     => esc_html__( 'Shortcode', 'cleaninganything' ),
					'subtitle'  => esc_html__( 'Add your shortcode form field here.', 'cleaninganything' ),
					'id'        => 'witr_footre_shortcode',
					'type'      => 'text',
					'desc'       => esc_html__('Please use this way Example ex-[mc4wp_form id="831"]', 'cleaninganything'),
				),
				array(
					'id'             => 'cleaninganything_shortcode_form_margin',
					'type'           => 'spacing',
					'output'         => array('.witr_shortcode_form'),
					'mode'           => 'margin',
					'units'          => array('em', 'px'),
					'units_extended' => 'false',
					'title'          => esc_html__(' shortcode Form Margin', 'cleaninganything'),
					'subtitle'       => esc_html__('Allow your users to choose the spacing margin they want.', 'cleaninganything'),
					'desc'           => esc_html__('You can enable or disable any piece of this field. Top, Right, Bottom, Left, or Units.', 'cleaninganything'),
					'default'            => array(
						'margin-top'     => '', 
						'margin-right'   => '', 
						'margin-bottom'  => '', 
						'margin-left'    => '',
						'units'          => 'px', 
					)
				),


				
            ),
    ) );




	
	
			
/* ========================
END cleaninganything FOOTER FIELD
=========================*/	

    Redux::setSection( $opt_name, array(
        'icon'            => 'el el-list-alt',
        'title'           => esc_html__( 'Customizer Only', 'cleaninganything' ),
        'desc'            => esc_html__( 'This Section should be visible only in Customizer', 'cleaninganything' ),
        'customizer_only' => true,
        'fields'          => array(
            array(
                'id'              => 'opt-customizer-only',
                'type'            => 'select',
                'title'           => esc_html__( 'Customizer Only Option', 'cleaninganything' ),
                'subtitle'        => esc_html__( 'The subtitle is NOT visible in customizer', 'cleaninganything' ),
                'desc'            => esc_html__( 'The field desc is NOT visible in customizer.', 'cleaninganything' ),
                'customizer_only' => true,
                //Must provide key => value pairs for select options
                'options'         => array(
                    '1' => esc_html__('Opt 1','cleaninganything'),
                    '2' => esc_html__('Opt 2','cleaninganything'),
                    '3' => esc_html__('Opt 3','cleaninganything')
                ),
                'default'         => '2'
            ),
        )
    ) );   	 
	 
	 
	 

    /*
     * <--- END SECTIONS
     */
