<?php
/**
 * The Template for displaying all single Give Forms.
 *
 * @package       cleaninganything
 * 
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

get_header();
get_template_part( 'includes/header' , 'page-title' );
/**
 * Fires in single form template, before the main content.
 *
 * Allows you to add elements before the main content.
 *
 * @since 1.0
 */

do_action( 'give_before_main_content' );
?>
<div class="cleaninganything_give_area">
<?php 
while ( have_posts() ) :
	the_post();

	give_get_template_part( 'single-give-form/content', 'single-give-form' );

endwhile; // end of the loop.
?>
</div>
<?php 
/**
 * Fires in single form template, after the main content.
 *
 * Allows you to add elements after the main content.
 *
 * @since 1.0
 */
do_action( 'give_after_main_content' );

/**
 * Fires in single form template, on the sidebar.
 *
 * Allows you to add elements to the sidebar.
 *
 * @since 1.0
 */
do_action( 'give_sidebar' );

get_footer();
