<?php
 /**
  * Title: Works Process
  * Slug: cleaninglight/works-process
  * Categories: cleaninglight
  * Keywords: works process, working process, process area, works process section, process
  */
?>
<!-- wp:group {"tagName":"section","metadata":{"name":"Works Process","categories":["cleaninglight"],"patternName":"cleaninglight/works-process"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|lg","bottom":"var:preset|spacing|lg"}}},"layout":{"type":"constrained"}} -->
<section class="wp-block-group alignfull" style="padding-top:var(--wp--preset--spacing--lg);padding-bottom:var(--wp--preset--spacing--lg)">

<!-- wp:group {"metadata":{"name":"Section Title"},"align":"wide","style":{"spacing":{"blockGap":"15px","padding":{"bottom":"var:preset|spacing|40"}}},"layout":{"type":"constrained","justifyContent":"left"}} -->
<div class="wp-block-group alignwide" style="padding-bottom:var(--wp--preset--spacing--40)">
  <!-- wp:group {"align":"wide","style":{"spacing":{"blockGap":"var:preset|spacing|20"}},"className":"section-title-wrapper","layout":{"type":"flex","orientation":"vertical","justifyContent":"center"}} -->
  <div class="wp-block-group alignwide section-title-wrapper">  
    <!-- wp:paragraph {"align":"left","style":{"typography":{"fontStyle":"normal","fontWeight":"600"}},"className":"super-title"} -->
    <p class="has-text-align-left super-title" style="font-style:normal;font-weight:600">
      <?php esc_html_e('Fully Customization Theme','cleaning-light'); ?>
    </p>
    <!-- /wp:paragraph -->

    <!-- wp:heading {"textAlign":"center","align":"full"} -->
    <h2 class="wp-block-heading alignfull has-text-align-center">
      <?php esc_html_e('We Are A Professional Best WordPress Theme Agenc','cleaning-light'); ?>
    </h2>
    <!-- /wp:heading -->

    <!-- wp:group {"layout":{"type":"constrained","wideSize":"1020px"}} -->
      <div class="wp-block-group">
        <!-- wp:paragraph {"align":"center"} -->
        <p class="has-text-align-center">
          <?php esc_html_e('Welcome and thank you for installing the free WordPress theme. Cleaning is a clean, beautiful, and fully customizable responsive modern free WordPress cleaning theme, especially for App-related landing pages.','cleaning-light'); ?>
        </p>
        <!-- /wp:paragraph -->
      </div>
    <!-- /wp:group -->
  </div>
  <!-- /wp:group -->
</div>
<!-- /wp:group -->

<!-- wp:group {"metadata":{"name":"Works Process Area"},"align":"full","className":"how_it_works","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull how_it_works"><!-- wp:group {"align":"wide","className":"step_block","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignwide step_block"><!-- wp:columns {"align":"wide","className":"step_item"} -->
<div class="wp-block-columns alignwide step_item"><!-- wp:column {"verticalAlignment":"center","layout":{"type":"constrained"}} -->
<div class="wp-block-column is-vertically-aligned-center"><!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|lg","bottom":"var:preset|spacing|lg","left":"var:preset|spacing|sm","right":"var:preset|spacing|sm"}},"border":{"radius":"5px"},"color":{"background":"#fafafa"},"shadow":"var:preset|shadow|soft"},"layout":{"type":"constrained"}} -->
<div class="wp-block-group has-background" style="border-radius:5px;background-color:#fafafa;padding-top:var(--wp--preset--spacing--lg);padding-right:var(--wp--preset--spacing--sm);padding-bottom:var(--wp--preset--spacing--lg);padding-left:var(--wp--preset--spacing--sm);box-shadow:var(--wp--preset--shadow--soft)"><!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|sm"}},"layout":{"type":"flex","orientation":"vertical","justifyContent":"right"}} -->
<div class="wp-block-group"><!-- wp:image {"id":1431,"width":"100px","sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full is-resized"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/service/web-development.png" alt="" class="wp-image-1431" style="width:100px"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"textAlign":"right","level":3} -->
<h3 class="wp-block-heading has-text-align-right"><a href="#"><?php esc_html_e('Easy Online Booking','cleaning-light'); ?></a></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"right"} -->
<p class="has-text-align-right"><?php esc_html_e('WordPress theme is a clean, beautiful, and fully customizable responsive modern free WordPress cleaning theme, especially for App-related landing pages.','cleaning-light'); ?></p>
<!-- /wp:paragraph -->

<!-- wp:buttons -->
<div class="wp-block-buttons"><!-- wp:button {"className":"is-style-no-border"} -->
<div class="wp-block-button is-style-no-border"><a class="wp-block-button__link wp-element-button" href="#"><?php esc_html_e('Read More','cleaning-light'); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","width":"15%","className":"hide-on-mobile","layout":{"type":"constrained"}} -->
<div class="wp-block-column is-vertically-aligned-center hide-on-mobile" style="flex-basis:15%"><!-- wp:group {"className":"step_number","layout":{"type":"constrained"}} -->
<div id="step_number" class="wp-block-group step_number"><!-- wp:heading {"textAlign":"center","textColor":"foreground"} -->
<h2 class="wp-block-heading has-text-align-center has-foreground-color has-text-color">01</h2>
<!-- /wp:heading --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"layout":{"type":"constrained"}} -->
<div class="wp-block-column"><!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:image {"id":861,"sizeSlug":"large","linkDestination":"none","align":"center","style":{"border":{"radius":"5px"}}} -->
<figure class="wp-block-image aligncenter size-large has-custom-border"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/gallery/gallery-img-2.webp" alt="" class="wp-image-861" style="border-radius:5px"/></figure>
<!-- /wp:image --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:columns {"align":"wide","className":"step_item"} -->
<div class="wp-block-columns alignwide step_item"><!-- wp:column {"verticalAlignment":"center","layout":{"type":"constrained"}} -->
<div class="wp-block-column is-vertically-aligned-center"><!-- wp:group {"className":"box-shadow  ","style":{"spacing":{"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60","left":"var:preset|spacing|40","right":"var:preset|spacing|40"}},"border":{"radius":"5px"},"shadow":"var:preset|shadow|soft"},"layout":{"type":"constrained"}} -->
<div class="wp-block-group box-shadow" style="border-radius:5px;padding-top:var(--wp--preset--spacing--60);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--60);padding-left:var(--wp--preset--spacing--40);box-shadow:var(--wp--preset--shadow--soft)"><!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|sm"}},"layout":{"type":"flex","orientation":"vertical","justifyContent":"left"}} -->
<div class="wp-block-group"><!-- wp:image {"id":1431,"width":"100px","sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full is-resized"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/service/ux.png" alt="" class="wp-image-1431" style="width:100px"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"textAlign":"left","level":4,"style":{"typography":{"fontSize":"24px","fontStyle":"normal","fontWeight":"600"}}} -->
<h4 class="wp-block-heading has-text-align-left" style="font-size:24px;font-style:normal;font-weight:600"><a href="#"><?php esc_html_e('Work Processing','cleaning-light'); ?></a></h4>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"left"} -->
<p class="has-text-align-left"><?php esc_html_e('Leverage framework agile to provide a robust synopsis for overviews. Corporate strategy fosters thinking to further the overall value proposition.','cleaning-light'); ?></p>
<!-- /wp:paragraph -->

<!-- wp:buttons -->
<div class="wp-block-buttons"><!-- wp:button {"className":"is-style-no-border"} -->
<div class="wp-block-button is-style-no-border"><a class="wp-block-button__link wp-element-button" href="#"><?php esc_html_e('Read More','cleaning-light'); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","width":"15%","className":"hide-on-mobile","layout":{"type":"constrained"}} -->
<div class="wp-block-column is-vertically-aligned-center hide-on-mobile" style="flex-basis:15%"><!-- wp:group {"className":"step_number","layout":{"type":"constrained"}} -->
<div id="step_number" class="wp-block-group step_number"><!-- wp:heading {"textAlign":"center","textColor":"foreground"} -->
<h2 class="wp-block-heading has-text-align-center has-foreground-color has-text-color">02</h2>
<!-- /wp:heading --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"layout":{"type":"constrained"}} -->
<div class="wp-block-column"><!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:image {"id":861,"scale":"cover","sizeSlug":"large","linkDestination":"none","align":"center","style":{"border":{"radius":"5px"}}} -->
<figure class="wp-block-image aligncenter size-large has-custom-border"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/gallery/gallery-img-3.webp" alt="" class="wp-image-861" style="border-radius:5px;object-fit:cover"/></figure>
<!-- /wp:image --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:columns {"align":"wide","className":"step_item"} -->
<div class="wp-block-columns alignwide step_item"><!-- wp:column {"verticalAlignment":"center","layout":{"type":"constrained"}} -->
<div class="wp-block-column is-vertically-aligned-center"><!-- wp:group {"className":"box-shadow  ","style":{"spacing":{"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60","left":"var:preset|spacing|40","right":"var:preset|spacing|40"}},"border":{"radius":"5px"},"shadow":"var:preset|shadow|soft"},"backgroundColor":"background","layout":{"type":"constrained"}} -->
<div class="wp-block-group box-shadow has-background-background-color has-background" style="border-radius:5px;padding-top:var(--wp--preset--spacing--60);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--60);padding-left:var(--wp--preset--spacing--40);box-shadow:var(--wp--preset--shadow--soft)"><!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|sm"}},"layout":{"type":"flex","orientation":"vertical","justifyContent":"right"}} -->
<div class="wp-block-group"><!-- wp:image {"id":1431,"width":"100px","sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full is-resized"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/service/product-design.png" alt="" class="wp-image-1431" style="width:100px"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"textAlign":"right","level":4,"style":{"typography":{"fontSize":"24px","fontStyle":"normal","fontWeight":"600"}}} -->
<h4 class="wp-block-heading has-text-align-right" style="font-size:24px;font-style:normal;font-weight:600"><a href="#"><?php esc_html_e('Success Project','cleaning-light'); ?></a></h4>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"right"} -->
<p class="has-text-align-right"><?php esc_html_e('Have a question? Our professional support is ready to answer your questions. All our team member support requests will be replied in 24 hours or less.','cleaning-light'); ?></p>
<!-- /wp:paragraph -->

<!-- wp:buttons -->
<div class="wp-block-buttons"><!-- wp:button {"className":"is-style-no-border"} -->
<div class="wp-block-button is-style-no-border"><a class="wp-block-button__link wp-element-button" href="#"><?php esc_html_e('Read More','cleaning-light'); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","width":"15%","className":"hide-on-mobile","layout":{"type":"constrained"}} -->
<div class="wp-block-column is-vertically-aligned-center hide-on-mobile" style="flex-basis:15%"><!-- wp:group {"className":"step_number","layout":{"type":"constrained"}} -->
<div id="step_number" class="wp-block-group step_number"><!-- wp:heading {"textAlign":"center","textColor":"foreground"} -->
<h2 class="wp-block-heading has-text-align-center has-foreground-color has-text-color">03</h2>
<!-- /wp:heading --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"layout":{"type":"constrained"}} -->
<div class="wp-block-column"><!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:image {"id":861,"scale":"cover","sizeSlug":"large","linkDestination":"none","align":"center","style":{"border":{"radius":"5px"}}} -->
<figure class="wp-block-image aligncenter size-large has-custom-border"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/gallery/gallery-img-5.webp" alt="" class="wp-image-861" style="border-radius:5px;object-fit:cover"/></figure>
<!-- /wp:image --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></section>
<!-- /wp:group -->