<?php
 /**
  * Title: Quick Contact Area
  * Slug: cleaninglight/quick-contact
  * Categories: cleaninglight
  * Keywords: contact, quick contact, contact section
  */
?>
<!-- wp:group {"metadata":{"name":"Quick Contact Area","categories":["cleaninglight"],"patternName":"cleaninglight/quick-contact"},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:cover {"url":"<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/service/portfolio-8.jpg","id":549,"dimRatio":60,"overlayColor":"shadowopacity","isUserOverlayColor":true,"minHeight":512,"minHeightUnit":"px","align":"wide","style":{"border":{"radius":"10px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-cover alignwide" style="border-radius:10px;min-height:512px"><img class="wp-block-cover__image-background wp-image-549" alt="" src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/service/portfolio-8.jpg" data-object-fit="cover"/><span aria-hidden="true" class="wp-block-cover__background has-shadowopacity-background-color has-background-dim-60 has-background-dim"></span><div class="wp-block-cover__inner-container"><!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:heading {"textAlign":"center","textColor":"white"} -->
<h2 class="wp-block-heading has-text-align-center has-white-color has-text-color"><?php esc_html_e('Start your journey','cleaning-light'); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","textColor":"white","fontSize":"medium"} -->
<p class="has-text-align-center has-white-color has-text-color has-medium-font-size"><?php esc_html_e('Molestie ac feugiat sed lectus vestibulum mattis ullamcorper Amet nulla facilisi morbi tempus iaculis urna id volutpat. Tempor commodo ullamcorper a lacus','cleaning-light'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"padding":{"top":"30px","bottom":"30px"},"margin":{"top":"50px"}},"border":{"radius":"8px"}},"backgroundColor":"white","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-white-background-color has-background" style="border-radius:8px;margin-top:50px;padding-top:30px;padding-bottom:30px"><!-- wp:group {"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between"}} -->
<div class="wp-block-group"><!-- wp:heading {"level":5,"textColor":"black"} -->
<h5 class="wp-block-heading has-black-color has-text-color"><?php esc_html_e('Start exploring the world today!','cleaning-light'); ?></h5>
<!-- /wp:heading -->

<!-- wp:buttons -->
<div class="wp-block-buttons"><!-- wp:button {"className":"is-style-fill"} -->
<div class="wp-block-button is-style-fill"><a class="wp-block-button__link wp-element-button" href="#"><?php esc_html_e('Contact us','cleaning-light'); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div></div>
<!-- /wp:cover -->

<!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"left":"var:preset|spacing|sm"}}}} -->
<div class="wp-block-columns alignwide"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"border":{"radius":"8px"},"spacing":{"padding":{"top":"var:preset|spacing|80","bottom":"var:preset|spacing|80","left":"var:preset|spacing|60","right":"var:preset|spacing|60"}},"dimensions":{"minHeight":""}},"backgroundColor":"primary","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-primary-background-color has-background" style="border-radius:8px;padding-top:var(--wp--preset--spacing--80);padding-right:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--80);padding-left:var(--wp--preset--spacing--60)"><!-- wp:image {"id":871,"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/service/sonoran-article-1.png" alt="" class="wp-image-871"/></figure>
<!-- /wp:image -->

<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|30"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:heading {"textAlign":"left","level":3,"textColor":"white"} -->
<h3 class="wp-block-heading has-text-align-left has-white-color has-text-color"><?php esc_html_e('Read our travel blog','cleaning-light'); ?></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"textColor":"white"} -->
<p class="has-white-color has-text-color"><?php esc_html_e('A wonderful serenity has taken possession of my entire, like these sweet mornings of spring which I enjoy with my heart.','cleaning-light'); ?></p>
<!-- /wp:paragraph -->

<!-- wp:group {"className":"has-icon","style":{"elements":{"link":{"color":{"text":"var:preset|color|secondary"}}}},"textColor":"link","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-icon has-link-color has-text-color"><!-- wp:buttons -->
<div class="wp-block-buttons"><!-- wp:button {"textColor":"white","className":"is-style-no-border","style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}}}} -->
<div class="wp-block-button is-style-no-border"><a class="wp-block-button__link has-white-color has-text-color has-link-color wp-element-button" href="#"><?php esc_html_e('Read More','cleaning-light'); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"border":{"radius":"8px"},"spacing":{"padding":{"top":"var:preset|spacing|80","bottom":"var:preset|spacing|80","left":"var:preset|spacing|60","right":"var:preset|spacing|60"}},"dimensions":{"minHeight":""},"color":{"background":"#f8fafc"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group has-background" style="border-radius:8px;background-color:#f8fafc;padding-top:var(--wp--preset--spacing--80);padding-right:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--80);padding-left:var(--wp--preset--spacing--60)"><!-- wp:image {"id":878,"sizeSlug":"full","linkDestination":"none","style":{"color":{"duotone":"unset"}}} -->
<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/service/sonoran-wechat-logo.png" alt="" class="wp-image-878"/></figure>
<!-- /wp:image -->

<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|30"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:heading {"textAlign":"left","level":3} -->
<h3 class="wp-block-heading has-text-align-left"><?php esc_html_e('Quick Contact support','cleaning-light'); ?></h3>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p><?php esc_html_e('Have a question? the professional support team is ready to answer your questions. which I enjoy with my whole heart.','cleaning-light'); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"elements":{"link":{":hover":{"color":{"text":"var:preset|color|primary"}},"color":{"text":"var:preset|color|secondary"}}}}} -->
<p class="has-link-color"><a href="mailto:example@example.com"><strong><?php esc_html_e('example@example.com','cleaning-light'); ?></strong></a></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->