<?php
/**
 * @author  RadiusTheme
 * @since   1.0.0
 * @version 1.0.0
 */

$date = get_comment_date( '', $comment );
$time = get_comment_time();
// phpcs:ignore WordPress.DateTime.CurrentTimeTimestamp.Requested
$human_time = human_time_diff( get_comment_time( 'U' ), current_time( 'timestamp' ) );
?>
<?php
// phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
$tag = ( 'div' === $args['style'] ) ? 'div' : 'li';
?>
<<?php echo esc_html( $tag ); ?> id="comment-<?php comment_ID(); ?>" <?php comment_class( $args['has_children'] ? 'parent main-comments' : 'main-comments', $comment ); ?>>

<div id="respond-<?php comment_ID(); ?>" class="each-comment d-flex">

	<?php if ( get_option( 'show_avatars' ) ) : ?>
		<div class="flex-shrink-0 imgholder">
			<?php
			if ( 0 != $args['avatar_size'] ) {
				echo get_avatar( $comment, $args['avatar_size'], '', false, [ 'class' => 'media-object' ] );}
			?>
		</div>
	<?php endif; ?>

	<div class="flex-grow-1 comments-body">
		<div class="comment-meta clearfix">
			<div class="comment-meta-left">
				<h3 class="comment-author"><?php echo get_comment_author_link( $comment ); ?></h3>
				<div class="comment-time">
					<?php
					/* translators: %1$s: human readable time, %2$s: date, %3$s: time */
					echo wp_kses_post( sprintf( __( ' %1$s ago / %2$s @ %3$s', 'cl-classified' ), $human_time, $date, $time ) );
					?>
				</div>
			</div>
			<?php
			comment_reply_link(
				array_merge(
					$args,
					[
						'add_below' => 'respond',
						'depth'     => $depth,
						'max_depth' => $args['max_depth'],
						'before'    => '<div class="reply-area">',
						'after'     => '</div>',
					]
				)
			);
			?>
		</div>
		<div class="comment-text">
			<?php if ( '0' == $comment->comment_approved ) : ?>
				<p class="comment-awaiting-moderation"><?php esc_html_e( 'Your comment is awaiting moderation.', 'cl-classified' ); ?></p>
			<?php endif; ?>
			<?php comment_text(); ?>
		</div>
	</div>
	<div class="clear"></div>
</div>