<?php
/**
 * @author  RadiusTheme
 * @since   1.0.0
 * @version 1.0.0
 */

namespace RadiusTheme\ClassifiedLite\Customizer;

/**
 * Adds the individual sections, settings, and controls to the theme customizer
 */
class Customizer {

	// Get our default values
	protected $defaults;
	protected static $instance = null;
	/**
	 * Create a constructor.
	 * Register the sections and controls.
	 *
	 * @return void
	 */
	public function __construct() {
		// Register Panels
		add_action( 'customize_register', [ $this, 'add_customizer_panels' ] );
		// Register sections
		add_action( 'customize_register', [ $this, 'add_customizer_sections' ] );
	}
	/**
	 * @return self|null
	 */
	public static function instance() {
		if ( null == self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}
	/**
	 * @return void
	 */
	public function populated_default_data() {
		$this->defaults = Default_Data::default_values();
	}

	/**
	 * Add customizer panels.
	 *
	 * Adds panels for layout and color settings to the WordPress Customizer.
	 *
	 * @param \WP_Customize_Manager $wp_customize The Customizer object.
	 *
	 * @return void
	 */
	public function add_customizer_panels( $wp_customize ) {
		// Layout Panel
		$wp_customize->add_panel(
			'rttheme_layouts_defaults',
			[
				'title'       => esc_html__( 'Layout Settings', 'cl-classified' ),
				'description' => esc_html__( 'Adjust the overall layout for your site.', 'cl-classified' ),
				'priority'    => 17,
			]
		);
		// Color Panel
		$wp_customize->add_panel(
			'rttheme_color_panel',
			[
				'title'       => esc_html__( 'Color', 'cl-classified' ),
				'description' => esc_html__( 'Change site color', 'cl-classified' ),
				'priority'    => 17,
			]
		);
	}

	/**
	 * Add customizer section.
	 *
	 * @param \WP_Customize_Manager $wp_customize The Customizer object.
	 *
	 * @return void
	 */
	public function add_customizer_sections( $wp_customize ) {
		// Rename the default Colors section
		$wp_customize->get_section( 'colors' )->title = 'Background';
		// Move the default Colors section to our new Colors Panel
		$wp_customize->get_section( 'colors' )->panel = 'colors_panel';
		// Change the Priority of the default Colors section so it's at the top of our Panel
		$wp_customize->get_section( 'colors' )->priority = 10;
		// Add General Section
		$wp_customize->add_section(
			'general_section',
			[
				'title'    => esc_html__( 'General', 'cl-classified' ),
				'priority' => 10,
			]
		);
		// Add Header Main Section
		$wp_customize->add_section(
			'header_main_section',
			[
				'title'    => esc_html__( 'Header', 'cl-classified' ),
				'priority' => 11,
			]
		);
		// Add Footer Section
		$wp_customize->add_section(
			'footer_section',
			[
				'title'    => esc_html__( 'Footer', 'cl-classified' ),
				'priority' => 12,
			]
		);
		// Add Color Section
		$wp_customize->add_section(
			'site_color_section',
			[
				'title'    => esc_html__( 'Site Color', 'cl-classified' ),
				'panel'    => 'rttheme_color_panel',
				'priority' => 10,
			]
		);
		$wp_customize->add_section(
			'header_color_section',
			[
				'title'    => esc_html__( 'Header Color', 'cl-classified' ),
				'panel'    => 'rttheme_color_panel',
				'priority' => 12,
			]
		);
		$wp_customize->add_section(
			'breadcrumb_color_section',
			[
				'title'    => esc_html__( 'Breadcrumb Color', 'cl-classified' ),
				'panel'    => 'rttheme_color_panel',
				'priority' => 13,
			]
		);
		$wp_customize->add_section(
			'footer_color_section',
			[
				'title'    => esc_html__( 'Footer Color', 'cl-classified' ),
				'panel'    => 'rttheme_color_panel',
				'priority' => 14,
			]
		);
		// Add Blog Layout Section
		$wp_customize->add_section(
			'blog_layout_section',
			[
				'title'    => esc_html__( 'Blog Layout', 'cl-classified' ),
				'priority' => 10,
				'panel'    => 'rttheme_layouts_defaults',
			]
		);
		// Add Single Post Layout Section
		$wp_customize->add_section(
			'single_post_layout_section',
			[
				'title'    => esc_html__( 'Single Post Layout', 'cl-classified' ),
				'priority' => 10,
				'panel'    => 'rttheme_layouts_defaults',
			]
		);
		// Add Pages Layout Section
		$wp_customize->add_section(
			'page_layout_section',
			[
				'title'    => esc_html__( 'Pages Layout', 'cl-classified' ),
				'priority' => 15,
				'panel'    => 'rttheme_layouts_defaults',
			]
		);
		// Add Error Layout Section
		$wp_customize->add_section(
			'error_layout_section',
			[
				'title'    => esc_html__( 'Error Layout', 'cl-classified' ),
				'priority' => 15,
				'panel'    => 'rttheme_layouts_defaults',
			]
		);
		// Add Listing Layout Section
		$wp_customize->add_section(
			'listing_archive_layout_section',
			[
				'title'    => esc_html__( 'Listing Archive Layout', 'cl-classified' ),
				'priority' => 20,
				'panel'    => 'rttheme_layouts_defaults',
			]
		);
		// Add Listing Single Layout Section
		$wp_customize->add_section(
			'listing_single_layout_section',
			[
				'title'    => esc_html__( 'Listing Single Layout', 'cl-classified' ),
				'priority' => 21,
				'panel'    => 'rttheme_layouts_defaults',
			]
		);
		// Add Blog Archive Section
		$wp_customize->add_section(
			'blog_archive_section',
			[
				'title'    => esc_html__( 'Blog', 'cl-classified' ),
				'priority' => 15,
			]
		);
		// Add Single Post Section
		$wp_customize->add_section(
			'single_post_section',
			[
				'title'    => esc_html__( 'Post Details', 'cl-classified' ),
				'priority' => 16,
			]
		);
		// Add Listing Settings Section
		$wp_customize->add_section(
			'listings_section',
			[
				'title'    => esc_html__( 'Listing Settings', 'cl-classified' ),
				'priority' => 17,
			]
		);
		// Contact Info
		$wp_customize->add_section(
			'contact_info_section',
			[
				'title'    => esc_html__( 'Contact & Social', 'cl-classified' ),
				'priority' => 17,
			]
		);
		// Add Error Page Section
		$wp_customize->add_section(
			'error_section',
			[
				'title'    => esc_html__( 'Error Page', 'cl-classified' ),
				'priority' => 19,
			]
		);
	}
}
