<?php
/**
 * Theme functions and definitions
 *
 * @package Chromica
 */

/**
 * After setup theme hook
 */
function chromica_theme_setup(){
    /*
     * Make child theme available for translation.
     * Translations can be filed in the /languages/ directory.
     */
    load_child_theme_textdomain( 'chromica' );	
}
add_action( 'after_setup_theme', 'chromica_theme_setup' );

/**
 * Load assets.
 */

function chromica_theme_css() {
	wp_enqueue_style( 'chromica-parent-theme-style', get_template_directory_uri() . '/style.css' );
}
add_action( 'wp_enqueue_scripts', 'chromica_theme_css', 99);

require get_stylesheet_directory() . '/theme-functions/controls/class-customize.php';

/**
 * Import Options From Parent Theme
 *
 */
function chromica_parent_theme_options() {
	$chromax_mods = get_option( 'theme_mods_chromax' );
	if ( ! empty( $chromax_mods ) ) {
		foreach ( $chromax_mods as $chromax_mod_k => $chromax_mod_v ) {
			set_theme_mod( $chromax_mod_k, $chromax_mod_v );
		}
	}
}
add_action( 'after_switch_theme', 'chromica_parent_theme_options' );