<?php
/**
 * Functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package chicera
 * @since 1.0
 */

/**
 * Enqueue the CSS files.
 *
 * @since 1.0
 *
 * @return void
 */
function chicera_styles() {
	wp_enqueue_style(
		'chicera-style',
		get_stylesheet_uri(),
		[],
		wp_get_theme()->get( 'Version' )
	);
}
add_action( 'wp_enqueue_scripts', 'chicera_styles' );


function chicera_setup() {
    add_theme_support('post-formats', array(
        'aside', 'gallery', 'link', 'image', 'quote', 'status', 'video', 'audio', 'chat'
    ));
	load_theme_textdomain('chicera', get_template_directory() . '/languages');
}
add_action('after_setup_theme', 'chicera_setup');

/**
 * Register custom block styles.
 */
function chicera_register_block_styles() {
    // Check if function exists to avoid errors.
    if (function_exists('register_block_style')) {
        // Register a custom block style for the paragraph block.
        register_block_style(
            'core/paragraph',
            array(
                'name'  => 'chicera-custom-style',
                'label' => __('ChicEra Custom Style', 'chicera'),
            )
        );

        // Register another custom block style for the image block as an example.
        register_block_style(
            'core/image',
            array(
                'name'  => 'chicera-custom-image-style',
                'label' => __('ChicEra Custom Image Style', 'chicera'),
            )
        );
    }
}
add_action('init', 'chicera_register_block_styles');

/**
 * Register custom block patterns.
 */
function chicera_register_block_patterns() {
    // Check if function exists to avoid errors.
    if (function_exists('register_block_pattern')) {
        // Register a custom block pattern.
        register_block_pattern(
            'chicera/custom-pattern',
            array(
                'title'       => __('ChicEra Custom Pattern', 'chicera'),
                'description' => _x('A custom block pattern by ChicEra.', 'Block pattern description', 'chicera'),
                'content'     => "<!-- wp:paragraph -->
                <p>" . __('This is a custom block pattern created by ChicEra.', 'chicera') . "</p>
                <!-- /wp:paragraph -->
                <!-- wp:image -->
                <figure class=\"wp-block-image\"><img src=\"/path/to/image.jpg\" alt=\"" . __('Sample image', 'chicera') . "\"/></figure>
                <!-- /wp:image -->",
            )
        );

        // Add more patterns as needed.
    }
}
add_action('init', 'chicera_register_block_patterns');
