<?php
if ( ! get_theme_mod( 'magnific_blog_enable_banner_section', false ) ) {
	return;
}

$slider_content_ids  = $editor_content_ids = array();
$slider_content_type = get_theme_mod( 'magnific_blog_banner_slider_content_type', 'post' );
$editor_content_type = get_theme_mod( 'magnific_blog_banner_editor_choice_content_type', 'post' );

if ( $slider_content_type === 'post' ) {
	for ( $i = 1; $i <= 3; $i++ ) {
		$slider_content_ids[] = get_theme_mod( 'magnific_blog_banner_slider_content_post_' . $i );
	}
	$slider_args = array(
		'post_type'           => 'post',
		'posts_per_page'      => absint( 3 ),
		'ignore_sticky_posts' => true,
	);
	if ( ! empty( array_filter( $slider_content_ids ) ) ) {
		$slider_args['post__in'] = array_filter( $slider_content_ids );
		$slider_args['orderby']  = 'post__in';
	} else {
		$slider_args['orderby'] = 'date';
	}
} else {
	$cat_content_id = get_theme_mod( 'magnific_blog_banner_slider_content_category' );
	$slider_args    = array(
		'cat'            => $cat_content_id,
		'posts_per_page' => absint( 3 ),
	);
}
$slider_args = apply_filters( 'magnific_blog_slider_section_args', $slider_args );

if ( $editor_content_type === 'post' ) {
	for ( $i = 1; $i <= 4; $i++ ) {
		$editor_content_ids[] = get_theme_mod( 'magnific_blog_banner_editor_choice_content_post_' . $i );
	}
	$editor_args = array(
		'post__in'            => array_filter( $editor_content_ids ),
		'post_type'           => 'post',
		'posts_per_page'      => absint( 4 ),
		'ignore_sticky_posts' => true,
	);
	if ( ! empty( array_filter( $editor_content_ids ) ) ) {
		$editor_args['orderby'] = 'post__in';
	} else {
		$editor_args['orderby'] = 'date';
	}
} else {
	$cat_content_id = get_theme_mod( 'magnific_blog_banner_editor_choice_content_category' );
	$editor_args    = array(
		'cat'            => $cat_content_id,
		'posts_per_page' => absint( 4 ),
	);
}
$editor_args = apply_filters( 'magnific_blog_editor_choice_section_args', $editor_args );

magnific_blog_render_slider_section( $slider_args, $editor_args );

/**
 * Render Banner Section.
 */
function magnific_blog_render_slider_section( $slider_args, $editor_args ) {
	?>
	<section id="magnific_blog_banner_section" class="banner-section no-background section-splitter banner-style-4">
		<?php
		if ( is_customize_preview() ) :
			magnific_blog_section_link( 'magnific_blog_banner_section' );
		endif;
		?>
		<div class="section-wrapper">
			<div class="banner-container-wrapper">
				<div class="banner-slider-part">
					<?php
					$slider_query = new WP_Query( $slider_args );
					if ( $slider_query->have_posts() ) {
						?>
						<div class="banner-wrapper">
							<div class="banner-slider slick-button">
								<?php
								while ( $slider_query->have_posts() ) :
									$slider_query->the_post();
									?>
									<div class="blog-post-container tile-layout">
										<div class="blog-post-inner <?php echo esc_attr( has_post_thumbnail() ? 'has-thumbnail' : 'no-thumbnail' ); ?>">
											<?php if ( has_post_thumbnail() ) : ?>
												<div class="blog-post-image">
													<a href="<?php the_permalink(); ?>">
														<?php the_post_thumbnail( 'post-thumbnail' ); ?>
													</a>
												</div>
											<?php endif; ?>
											<div class="blog-post-detail">
												<ul class="post-categories">
													<?php the_category( '', '', get_the_ID() ); ?>
												</ul>
												<h3 class="post-main-title">
													<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
												</h3>
												<p class="post-excerpt">
													<?php echo esc_html( wp_trim_words( get_the_excerpt(), 20 ) ); ?>
												</p>
												<div class="post-meta-button">
													<div class="post-meta">
														<span class="post-author">
															<a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>"><?php echo esc_html( get_the_author() ); ?></a>
														</span>
														<span class="post-date">
															<a href="<?php the_permalink(); ?>"><?php echo esc_html( get_the_date() ); ?></a>
														</span>
													</div>
												</div>
											</div>
										</div>
									</div>
									<?php
								endwhile;
								wp_reset_postdata();
								?>
							</div>
						</div>
					<?php } ?>
				</div>

				<?php
				$editor_query = new WP_Query( $editor_args );
				if ( $editor_query->have_posts() ) {
					$section_title = get_theme_mod( 'magnific_blog_banner_editor_choice_title', __( 'Editor Choice', 'charm-blog' ) );
					?>
					<div class="editors-choice">
						<?php if ( ! empty( $section_title ) ) : ?>
							<div class="title-heading">
								<h3 class="main-title">
									<span><?php echo esc_html( $section_title ); ?></span>
								</h3>
							</div>
						<?php endif ?>
						<div class="post-wrapper">
							<?php
							while ( $editor_query->have_posts() ) :
								$editor_query->the_post();
								?>
								<div class="blog-post-container tile-layout">
									<div class="blog-post-inner <?php echo esc_attr( has_post_thumbnail() ? 'has-thumbnail' : 'no-thumbnail' ); ?>">
										<?php if ( has_post_thumbnail() ) : ?>
											<div class="blog-post-image">
												<a href="<?php the_permalink(); ?>">
													<?php the_post_thumbnail( 'post-thumbnail' ); ?>
												</a>
											</div>
										<?php endif; ?>
										<div class="blog-post-detail">
											<ul class="post-categories">
												<?php the_category( '', '', get_the_ID() ); ?>
											</ul>
											<h3 class="post-main-title">
												<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
											</h3>
											<div class="post-meta-button">
												<div class="post-meta">
													<span class="post-author">
														<a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>"><?php echo esc_html( get_the_author() ); ?></a>
													</span>
													<span class="post-date">
														<a href="<?php the_permalink(); ?>"><?php echo esc_html( get_the_date() ); ?></a>
													</span>
												</div>
											</div>
										</div>
									</div>
								</div>
								<?php
							endwhile;
							wp_reset_postdata();
							?>
						</div>
					</div>
				<?php } ?>
			</div>
		</div>
	</section>
	<?php
}

