<?php
/**
 * Theme Customizer
 *
 * @package Charm Blog
 */

function charm_blog_customize_register( $wp_customize ) {

	require get_theme_file_path() . '/inc/customizer/banner.php';

	// Upsell Section.
	$wp_customize->add_section(
		new Charm_Blog_Upsell_Section(
			$wp_customize,
			'upsell_sections',
			array(
				'title'            => __( 'Charm Blog', 'charm-blog' ),
				'button_text'      => __( 'Buy Pro', 'charm-blog' ),
				'url'              => 'https://ascendoor.com/themes/charm-blog-pro/',
				'background_color' => '#6638aa',
				'text_color'       => '#fff',
				'priority'         => 0,
			)
		)
	);

}
add_action( 'customize_register', 'charm_blog_customize_register' );

function charm_blog_custom_control_scripts() {
	// Append .min if SCRIPT_DEBUG is false.
	$min = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

	wp_enqueue_style( 'charm-blog-custom-controls-css', get_stylesheet_directory_uri() . '/assets/css/custom-controls' . $min . '.css', array( 'magnific-blog-custom-controls-css' ), '1.0.0', 'all' );
	wp_enqueue_script( 'charm-blog-custom-controls-js', get_stylesheet_directory_uri() . '/assets/js/custom-controls' . $min . '.js', array( 'magnific-blog-custom-controls-js', 'jquery', 'jquery-ui-core' ), '1.0.0', true );
}
add_action( 'customize_controls_enqueue_scripts', 'charm_blog_custom_control_scripts' );
