<?php
/**
 * Charm Blog functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Charm Blog
 */

if ( ! function_exists( 'charm_blog_setup' ) ) :
	function charm_blog_setup() {
		/*
		* Make child theme available for translation.
		* Translations can be filed in the /languages/ directory.
		*/
		load_child_theme_textdomain( 'charm-blog', get_stylesheet_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		add_theme_support( 'title-tag' );

		add_theme_support( 'register_block_pattern' );

		add_theme_support( 'register_block_style' );

		add_theme_support( 'wp-block-styles' );

		add_theme_support( 'align-wide' );

		add_theme_support( 'responsive-embeds' );
	}
endif;
add_action( 'after_setup_theme', 'charm_blog_setup' );

if ( ! function_exists( 'charm_blog_enqueue_styles' ) ) :
	/**
	 * Enqueue scripts and styles.
	 */
	function charm_blog_enqueue_styles() {
		$parenthandle = 'magnific-blog-style';
		$theme        = wp_get_theme();

		// Append .min if SCRIPT_DEBUG is false.
		$min = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

		wp_enqueue_style(
			$parenthandle,
			get_template_directory_uri() . '/style.css',
			array(
				'magnific-blog-slick-css',
				'magnific-blog-font-awesome-css',
				'magnific-blog-google-fonts',
			),
			$theme->parent()->get( 'Version' )
		);

		wp_enqueue_style(
			'charm-blog-style',
			get_stylesheet_uri(),
			array( $parenthandle ),
			$theme->get( 'Version' )
		);

	}

endif;

add_action( 'wp_enqueue_scripts', 'charm_blog_enqueue_styles' );

// Custom Controls.
require get_theme_file_path() . '/inc/custom-controls.php';

// Customizer Section.
require get_theme_file_path() . '/inc/customizer.php';

// Customizer Section.
require get_theme_file_path() . '/inc/widgets/widgets.php';

/**
 * One Click Demo Import after import setup.
 */
if ( class_exists( 'OCDI_Plugin' ) ) {
	require get_theme_file_path() . '/inc/ocdi.php';
}

/**
 * Set up the WordPress core custom header feature.
 *
 * @uses charm_blog_header_style()
 */
function charm_blog_custom_header_setup() {
	add_theme_support(
		'custom-header',
		apply_filters(
			'magnific_blog_custom_header_args',
			array(
				'default-image'      => '',
				'default-text-color' => '6638aa',
				'width'              => 1000,
				'height'             => 250,
				'flex-height'        => true,
				'wp-head-callback'   => 'magnific_blog_header_style',
			)
		)
	);
}
add_action( 'after_setup_theme', 'charm_blog_custom_header_setup' );

function admin_style() {
	?>
	<style type="text/css">
		.notice.notice-info.magnific-blog-demo-data {
			display: none !important;
		}
	</style>
	<?php
}
add_action( 'admin_enqueue_scripts', 'admin_style' );
