<?php
if ( ! get_theme_mod( 'charity_zen_enable_team_section', false ) ) {
	return;
}

$content_id = $designation = $social_links = $section_content = array();

for ( $i = 1; $i <= 4; $i++ ) {
	$team_id                 = get_theme_mod( 'charity_zen_team_content_page_' . $i );
	$content_id[]            = $team_id;
	$designation[ $team_id ] = get_theme_mod( 'charity_zen_team_position_' . $i );
	$social_links_str        = get_theme_mod( 'charity_zen_team_social_links_' . $i );
	if ( ! empty( $social_links_str ) ) {
		$social_links[ $team_id ] = explode( ',', get_theme_mod( 'charity_zen_team_social_links_' . $i ) );
	}
}

$args = array(
	'post_type'           => 'page',
	'post__in'            => $content_id,
	'orderby'             => 'post__in',
	'posts_per_page'      => absint( 4 ),
	'ignore_sticky_posts' => true,
);

$query = new WP_Query( $args );
if ( $query->have_posts() ) :
	while ( $query->have_posts() ) :
		$query->the_post();
		$data['id']            = get_the_ID();
		$data['title']         = get_the_title();
		$data['content']       = get_the_content();
		$data['permalink']     = get_the_permalink();
		$data['thumbnail_url'] = get_the_post_thumbnail_url( get_the_ID(), 'full' );
		array_push( $section_content, $data );
	endwhile;
	wp_reset_postdata();
endif;

$section_content = apply_filters( 'charity_zen_team_section_content', $section_content );

charity_zen_render_team_section( $section_content, $designation, $social_links );

/**
 * Render Team Section.
 */
function charity_zen_render_team_section( $section_content, $designation, $social_links ) {
	$section_subtitle  = get_theme_mod( 'charity_zen_team_section_subtitle', __( 'Our Team', 'charity-zen' ) );
	$section_title     = get_theme_mod( 'charity_zen_team_section_title', __( 'Experienced People', 'charity-zen' ) );
	$team_button_label = get_theme_mod( 'charity_zen_team_button_label' );
	$team_button_link  = get_theme_mod( 'charity_zen_team_button_link' );
	$team_button_link  = ! empty( $team_button_link ) ? $team_button_link : '#';
	?>
	<section id="charity_zen_team_section" class="thumbnail-list thumbnail-list--artist team-volunteers">
		<?php
		if ( is_customize_preview() ) :
			charity_zen_section_link( 'charity_zen_team_section' );
		endif;
		?>
			<div class="container">
				<div class="heading text-center  pb-5">
					<div class="heading-sub-title"><?php echo esc_html( $section_subtitle ); ?></div>
					<h2 class="heading-title fw-normal"><?php echo esc_html( $section_title ); ?></h2>
				</div>
				<?php if ( ! empty( $section_content ) ) { ?>
					<div class="team-volunteers-wrapper">
						<?php
						foreach ( $section_content as $content ) {
							$team_id = $content['id'];
							?>
							<div class="team-volunteers-single">
								<div class="media-box">
									<div class="media-img">
										<img src="<?php echo esc_url( $content['thumbnail_url'] ); ?>" alt="<?php echo esc_attr( $content['title'] ); ?>">
									</div>
									<h3><a href="<?php echo esc_url( $content['permalink'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h3>
									<p><?php echo esc_html( $designation[ $team_id ] ); ?></p>
									<?php if ( ! empty( $social_links[ $team_id ] ) ) : ?>
										<div class="social-links">
											<?php foreach ( $social_links[ $team_id ] as $link ) : ?>
												<a href="<?php echo esc_url( $link ); ?>" target="_blank"></a>
											<?php endforeach; ?>
										</div>
									<?php endif; ?>
								</div>
							</div>
							<?php
						}
						?>
					</div>
					<?php if ( ! empty( $team_button_label ) ) : ?>
						<div class="btn-wrap text-center">
							<a href="<?php echo esc_url( $team_button_link ); ?>" class="btn btn-outline-secondary btn-lg"><?php echo esc_html( $team_button_label ); ?> <em class="bi bi-arrow-right ms-2"></em></a>
						</div>
					<?php endif; ?>
				<?php } ?>
			</div>
		</section>

	<?php

}
