<?php
if ( ! get_theme_mod( 'charity_zen_enable_service_section', false ) ) {
	return;
}

$content_ids = $section_content = array();

for ( $i = 1; $i <= 3; $i++ ) {
	$content_ids[] = get_theme_mod( 'charity_zen_service_content_post_' . $i );
}

$args = array(
	'post_type'           => 'post',
	'post__in'            => (array) $content_ids,
	'orderby'             => 'post__in',
	'posts_per_page'      => absint( 3 ),
	'ignore_sticky_posts' => true,
);

$query = new WP_Query( $args );
if ( $query->have_posts() ) :
	while ( $query->have_posts() ) :
		$query->the_post();
		$data['id']            = get_the_ID();
		$data['title']         = get_the_title();
		$data['excerpt']       = wp_trim_words( get_the_content(), 9 );
		$data['permalink']     = get_the_permalink();
		$data['thumbnail_url'] = get_the_post_thumbnail_url( get_the_ID(), 'full' );
		array_push( $section_content, $data );
	endwhile;
	wp_reset_postdata();
endif;

$section_content = apply_filters( 'charity_zen_service_section_content', $section_content );

charity_zen_render_service_section( $section_content );

/**
 * Render Service Section.
 */
function charity_zen_render_service_section( $section_content ) {
	$section_subtitle     = get_theme_mod( 'charity_zen_service_subtitle', __( 'Need Our Help', 'charity-zen' ) );
	$section_title        = get_theme_mod( 'charity_zen_service_title', __( 'How Can You help?', 'charity-zen' ) );
	$service_button_label = get_theme_mod( 'charity_zen_service_button_label' );
	$service_button_link  = get_theme_mod( 'charity_zen_service_button_link' );
	$service_button_link  = ! empty( $service_button_link ) ? $service_button_link : '#';
	?>

	<section id="charity_zen_service_section" class="thumbnail-list gallery-section style-2">
		<?php
		if ( is_customize_preview() ) :
			charity_zen_section_link( 'charity_zen_service_section' );
		endif;
		?>
		<div class="container">
			<div class="heading text-center  pb-5">
				<div class="heading-sub-title"><?php echo esc_html( $section_subtitle ); ?></div>
				<h2 class="heading-title fw-normal"><?php echo esc_html( $section_title ); ?></h2>
			</div>
			<?php if ( ! empty( $section_content ) ) { ?>
				<div class="row">
					<?php
					foreach ( $section_content as $content ) {
						?>
						<div class="col-lg-4 col-md-6 mb-5">
							<a href="<?php echo esc_url( $content['permalink'] ); ?>" class="media-box">
								<div class="media-img">
									<img src="<?php echo esc_url( $content['thumbnail_url'] ); ?>" alt="<?php echo esc_attr( $content['title'] ); ?>">
								</div>
								<h4><?php echo esc_html( $content['title'] ); ?></h4>
								<p><?php echo esc_html( $content['excerpt'] ); ?></p>
							</a>
						</div>
						<?php
					}
					?>
				</div>
				<?php if ( ! empty( $service_button_label ) ) : ?>
					<div class="btn-wrapper text-center">
						<a href="<?php echo esc_url( $service_button_link ); ?>" class="btn btn-outline-primary btn-lg"><?php echo esc_html( $service_button_label ); ?> <em class="bi bi-arrow-right ms-2"></em></a>
					</div>
				<?php endif; ?>
			<?php } ?>
		</div>
	</section>
	<?php
}
