<?php
if ( ! get_theme_mod( 'travellable_enable_newsletter_section', false ) ) {
	return;
}

$section_content                   = array();
$section_content['title']          = get_theme_mod( 'travellable_newsletter_title', __( 'Stay Updated', 'charity-zen' ) );
$section_content['content']        = get_theme_mod( 'travellable_newsletter_content', __( 'Sign up for newsletter and get latest news and updates.', 'charity-zen' ) );
$section_content['background_url'] = get_theme_mod( 'travellable_newsletter_background_image' );

$section_content = apply_filters( 'travellable_newsletter_section_content', $section_content );

travellable_render_newsletter_section( $section_content );

/**
 * Render newsletter section
 */
function travellable_render_newsletter_section( $section_content ) {
	?>
	<section id="travellable_newsletter_section" class="newsletter-callout style-2">
		<?php
		if ( is_customize_preview() ) :
			travellable_section_link( 'travellable_newsletter_section' );
		endif;
		?>
		<div class="container">
			<div class="row">
				<div class="image-part">
					<div class="newsletter-background-img">
						<img src="<?php echo esc_url( $section_content['background_url'] ); ?>" alt="">
					</div>
				</div>
				<div class="form-part">
					<div class="heading">
						<h2 class="title mb-3"><?php echo esc_html( $section_content['title'] ); ?></h2>
						<p class="fw-light">
							<?php echo wp_kses_post( $section_content['content'] ); ?>
						</p>
					</div>
					<div class="newsletter">
						<?php
						$subscription_shortcode = '[jetpack_subscription_form title="" subscribe_text="" subscribe_button=""]';
						echo do_shortcode( wp_kses_post( $subscription_shortcode ) );
						?>
					</div>
				</div>
			</div>
		</div>
	</section>
	<?php
}
