<?php
if ( ! get_theme_mod( 'travellable_enable_counter_section', false ) ) {
	return;
}

$section_content               = array();
$section_content['title']      = get_theme_mod( 'travellable_counter_section_title', __( 'Why choose us?', 'charity-zen' ) );
$section_content['background'] = get_theme_mod( 'travellable_counter_background' );
$section_content['count']      = get_theme_mod( 'travellable_counter_count', 4 );

$section_content = apply_filters( 'travellable_counter_section_content', $section_content );

charity_zen_render_counter_section( $section_content );

/**
 * Render counter section
 */
function charity_zen_render_counter_section( $section_content ) {
	?>
	<section id="travellable_counter_section" class="why-callout counter-style-2">
		<?php
		if ( is_customize_preview() ) :
			travellable_section_link( 'travellable_counter_section' );
		endif;
		?>
		<div class="counter-background-img">
			<img src="<?php echo esc_url( $section_content['background'] ); ?>" alt="">
		</div>
		<div class="container">
			<div class="row align-items-center">
				<div class="heading col-lg-6 ">
					<h2 class=""><?php echo esc_html( $section_content['title'] ); ?></h2>
				</div>
				<div class="col-lg-6 ms-auto">
					<ul class="row list-unstyled why-callout-list text-center">
						<?php
						for ( $i = 1; $i <= $section_content['count']; $i++ ) {
							$label        = get_theme_mod( 'travellable_counter_label_' . $i );
							$value        = get_theme_mod( 'travellable_counter_value_' . $i );
							$value_suffix = get_theme_mod( 'travellable_counter_value_suffix_' . $i );
							?>
							<li class="col-sm-6 p-0">
								<div class="why-callout-list-item">
									<h3><span class="count" data-count="<?php echo esc_attr( $value ); ?>"></span><?php echo esc_html( $value_suffix ); ?></h3>
									<p><?php echo esc_html( $label ); ?></p>
								</div>
							</li>
							<?php
						}
						?>
					</ul>
				</div>
			</div>
		</div>
	</section>
	<?php
}
