<?php

if ( ! get_theme_mod( 'travellable_enable_blog_section', false ) ) {
	return;
}

$content_ids = $section_content = array();

for ( $i = 1; $i <= 3; $i++ ) {
	$content_ids[] = get_theme_mod( 'travellable_blog_content_post_' . $i );
}

$args = array(
	'post_type'      => 'post',
	'post__in'       => $content_ids,
	'orderby'        => 'post__in',
	'posts_per_page' => absint( 3 ),
);

$query = new WP_Query( $args );
if ( $query->have_posts() ) :
	while ( $query->have_posts() ) :
		$query->the_post();
		$data['id']            = get_the_ID();
		$data['title']         = get_the_title();
		$data['excerpt']       = get_the_excerpt();
		$data['permalink']     = get_the_permalink();
		$data['thumbnail_url'] = get_the_post_thumbnail_url( get_the_ID(), 'full' );
		array_push( $section_content, $data );
	endwhile;
	wp_reset_postdata();

	$section_content = apply_filters( 'travellable_blog_section_content', $section_content );

	travellable_render_blog_section( $section_content );
endif;

/**
 * Render blog section
 */
function travellable_render_blog_section( $section_content ) {
	if ( empty( $section_content ) ) {
		return;
	}
	$blog_title        = get_theme_mod( 'travellable_blog_title', __( 'Blog', 'charity-zen' ) );
	$blog_button_label = get_theme_mod( 'travellable_blog_button_label', __( 'View All', 'charity-zen' ) );
	$blog_button_link  = get_theme_mod( 'travellable_blog_button_link' );
	$blog_button_link  = ! empty( $blog_button_link ) ? $blog_button_link : '#';
	?>
	<section id="travellable_blog_section" class="blog-callout style-2">
		<?php
		if ( is_customize_preview() ) :
			travellable_section_link( 'travellable_blog_section' );
		endif;
		?>
		<div class="container">
			<div class="d-md-flex  justify-content-md-between align-items-center mb-5">
				<h2 class="mb-4 text-center text-md-start"><?php echo esc_html( $blog_title ); ?></h2>
				<?php if ( ! empty( $blog_button_label ) ) : ?>
					<div class="text-center text-md-end">
						<a href="<?php echo esc_url( $blog_button_link ); ?>" class="btn btn-outline-primary btn-lg text-uppercase"><?php echo esc_html( $blog_button_label ); ?></a>
					</div>
				<?php endif; ?>
			</div>
			<div class="blog-callout-wrap">
				<?php foreach ( $section_content as $content ) { ?>
					<div class="blog-single">
						<div class="blog-img">
							<a class="media-img" href="<?php echo esc_url( $content['permalink'] ); ?>">
								<img src="<?php echo esc_url( $content['thumbnail_url'] ); ?>" class="card-img-top" alt="<?php echo esc_attr( $content['title'] ); ?>">
							</a>
						</div>
						<div class="blog-details">
							<h5 class="blog-title">
								<a href="<?php echo esc_url( $content['permalink'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a>
							</h5>
							<p><?php echo esc_html( $content['excerpt'] ); ?></p>
							<div class="blog-info card-info d-flex justify-content-between">
								<div> <em class="bi bi-grid"></em> <?php echo get_the_category_list( ', ', '', $content['id'] ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></div>
								<div> <em class="bi bi-clock"></em> <?php echo get_the_date( 'M d. Y', $content['id'] ); ?></div>
							</div>
						</div>
					</div>
				<?php } ?>
			</div>
		</div>
	</section>
	<?php
}
