<?php

if ( ! get_theme_mod( 'charity_zen_enable_associate_section', false ) ) {
	return;
}

$section_content          = array();
$section_content['title'] = get_theme_mod( 'charity_zen_associate_title', __( 'Our Partners', 'charity-zen' ) );

$section_content = apply_filters( 'charity_zen_associate_section_content', $section_content );

charity_zen_render_associate_section( $section_content );

/**
 * Render associate section
 */
function charity_zen_render_associate_section( $section_content ) {
	?>
	<section id="charity_zen_associate_section" class="associate_section style-2 bg-light">
		<?php
		if ( is_customize_preview() ) :
			charity_zen_section_link( 'charity_zen_associate_section' );
		endif;
		?>
		<div class="container text-center">
			<?php if ( ! empty( $section_content['title'] ) ) { ?>
				<h2 class="mb-5"><?php echo esc_html( $section_content['title'] ); ?></h2>
			<?php } ?>
			<div class="associate_section-slider associate_section-slider-wrap">
				<?php
				for ( $i = 1; $i <= 5; $i++ ) :
					$logo_url = get_theme_mod( 'charity_zen_associate_logo_' . $i );
					if ( ! empty( $logo_url ) ) :
						?>
						<div class="associate-item">
							<img src="<?php echo esc_url( $logo_url ); ?>" alt="<?php echo esc_attr__( 'associate-logo', 'charity-zen' ); ?>">
						</div>
						<?php
					endif;
				endfor;
				?>
			</div>
		</div>
	</section>
	<?php
}
