<?php
/**
 * Team Section
 *
 * @package Charity_Zen
 */

$wp_customize->add_section(
	'charity_zen_team_section',
	array(
		'panel' => 'travellable_front_page_options',
		'title' => esc_html__( 'Team Section', 'charity-zen' ),
	)
);

// Team Section - Enable Section.
$wp_customize->add_setting(
	'charity_zen_enable_team_section',
	array(
		'default'           => false,
		'sanitize_callback' => 'travellable_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Travellable_Toggle_Switch_Custom_Control(
		$wp_customize,
		'charity_zen_enable_team_section',
		array(
			'label'    => esc_html__( 'Enable Team Section', 'charity-zen' ),
			'section'  => 'charity_zen_team_section',
			'settings' => 'charity_zen_enable_team_section',
		)
	)
);

if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'charity_zen_enable_team_section',
		array(
			'selector' => '#charity_zen_team_section .section-link',
			'settings' => 'charity_zen_enable_team_section',
		)
	);
}

// Team Section - Section Subtitle.
$wp_customize->add_setting(
	'charity_zen_team_section_subtitle',
	array(
		'default'           => __( 'Our Team', 'charity-zen' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'charity_zen_team_section_subtitle',
	array(
		'label'           => esc_html__( 'Section Subtitle', 'charity-zen' ),
		'section'         => 'charity_zen_team_section',
		'settings'        => 'charity_zen_team_section_subtitle',
		'type'            => 'text',
		'active_callback' => 'charity_zen_is_team_section_enabled',
	)
);

// Team Section - Section Title.
$wp_customize->add_setting(
	'charity_zen_team_section_title',
	array(
		'default'           => __( 'Experienced People', 'charity-zen' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'charity_zen_team_section_title',
	array(
		'label'           => esc_html__( 'Section Title', 'charity-zen' ),
		'section'         => 'charity_zen_team_section',
		'settings'        => 'charity_zen_team_section_title',
		'type'            => 'text',
		'active_callback' => 'charity_zen_is_team_section_enabled',
	)
);

for ( $i = 1; $i <= 4; $i++ ) {

	// Team Section - Select Page.
	$wp_customize->add_setting(
		'charity_zen_team_content_page_' . $i,
		array(
			'sanitize_callback' => 'absint',
		)
	);

	$wp_customize->add_control(
		'charity_zen_team_content_page_' . $i,
		array(
			'label'           => esc_html__( 'Select Page ', 'charity-zen' ) . $i,
			'section'         => 'charity_zen_team_section',
			'settings'        => 'charity_zen_team_content_page_' . $i,
			'active_callback' => 'charity_zen_is_team_section_enabled',
			'type'            => 'select',
			'choices'         => travellable_get_page_choices(),
		)
	);

	$wp_customize->add_setting(
		'charity_zen_team_position_' . $i,
		array(
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'charity_zen_team_position_' . $i,
		array(
			'section'         => 'charity_zen_team_section',
			'settings'        => 'charity_zen_team_position_' . $i,
			'label'           => esc_html__( 'Designation ', 'charity-zen' ) . $i,
			'active_callback' => 'charity_zen_is_team_section_enabled',

		)
	);

	// Team Section - Social Links.
	$wp_customize->add_setting(
		'charity_zen_team_social_links_' . $i,
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_url_raw',
		)
	);
	$wp_customize->add_control(
		new Charity_Zen_Sortable_Repeater_Custom_Control(
			$wp_customize,
			'charity_zen_team_social_links_' . $i,
			array(
				'label'           => __( 'Social Links ', 'charity-zen' ) . $i,
				'section'         => 'charity_zen_team_section',
				'button_labels'   => array(
					'add' => __( 'Add', 'charity-zen' ),
				),
				'active_callback' => 'charity_zen_is_team_section_enabled',
			)
		)
	);
}

// Team Section - Button Label.
$wp_customize->add_setting(
	'charity_zen_team_button_label',
	array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'charity_zen_team_button_label',
	array(
		'label'           => esc_html__( 'Button Label', 'charity-zen' ),
		'section'         => 'charity_zen_team_section',
		'settings'        => 'charity_zen_team_button_label',
		'type'            => 'text',
		'active_callback' => 'charity_zen_is_team_section_enabled',
	)
);

// Team Section - Button Link.
$wp_customize->add_setting(
	'charity_zen_team_button_link',
	array(
		'default'           => '',
		'sanitize_callback' => 'esc_url_raw',
	)
);

$wp_customize->add_control(
	'charity_zen_team_button_link',
	array(
		'label'           => esc_html__( 'Button Link', 'charity-zen' ),
		'section'         => 'charity_zen_team_section',
		'settings'        => 'charity_zen_team_button_link',
		'type'            => 'url',
		'active_callback' => 'charity_zen_is_team_section_enabled',
	)
);
