<?php
/**
 * Service Section
 *
 * @package Charity_Zen
 */

$wp_customize->add_section(
	'charity_zen_service_section',
	array(
		'panel' => 'travellable_front_page_options',
		'title' => esc_html__( 'Service Section', 'charity-zen' ),
	)
);

// Service Section - Enable Section.
$wp_customize->add_setting(
	'charity_zen_enable_service_section',
	array(
		'default'           => false,
		'sanitize_callback' => 'travellable_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Travellable_Toggle_Switch_Custom_Control(
		$wp_customize,
		'charity_zen_enable_service_section',
		array(
			'label'    => esc_html__( 'Enable Service Section', 'charity-zen' ),
			'section'  => 'charity_zen_service_section',
			'settings' => 'charity_zen_enable_service_section',
		)
	)
);

if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'charity_zen_enable_service_section',
		array(
			'selector' => '#charity_zen_service_section .section-link',
			'settings' => 'charity_zen_enable_service_section',
		)
	);
}

// Service Section - Section Subtitle.
$wp_customize->add_setting(
	'charity_zen_service_subtitle',
	array(
		'default'           => __( 'Need Our Help', 'charity-zen' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'charity_zen_service_subtitle',
	array(
		'label'           => esc_html__( 'Section Subtitle', 'charity-zen' ),
		'section'         => 'charity_zen_service_section',
		'settings'        => 'charity_zen_service_subtitle',
		'type'            => 'text',
		'active_callback' => 'charity_zen_is_service_section_enabled',
	)
);

// Service Section - Section Title.
$wp_customize->add_setting(
	'charity_zen_service_title',
	array(
		'default'           => __( 'How Can You help?', 'charity-zen' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'charity_zen_service_title',
	array(
		'label'           => esc_html__( 'Section Title', 'charity-zen' ),
		'section'         => 'charity_zen_service_section',
		'settings'        => 'charity_zen_service_title',
		'type'            => 'text',
		'active_callback' => 'charity_zen_is_service_section_enabled',
	)
);

for ( $i = 1; $i <= 3; $i++ ) {
	// Service Section - Select Post.
	$wp_customize->add_setting(
		'charity_zen_service_content_post_' . $i,
		array(
			'sanitize_callback' => 'absint',
		)
	);

	$wp_customize->add_control(
		'charity_zen_service_content_post_' . $i,
		array(
			'label'           => esc_html__( 'Select Post ', 'charity-zen' ) . $i,
			'section'         => 'charity_zen_service_section',
			'settings'        => 'charity_zen_service_content_post_' . $i,
			'active_callback' => 'charity_zen_is_service_section_enabled',
			'type'            => 'select',
			'choices'         => travellable_get_post_choices(),
		)
	);
}

// Service Section - Button Label.
$wp_customize->add_setting(
	'charity_zen_service_button_label',
	array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'charity_zen_service_button_label',
	array(
		'label'           => esc_html__( 'Button Label', 'charity-zen' ),
		'section'         => 'charity_zen_service_section',
		'settings'        => 'charity_zen_service_button_label',
		'type'            => 'text',
		'active_callback' => 'charity_zen_is_service_section_enabled',
	)
);

// Service Section - Button Link.
$wp_customize->add_setting(
	'charity_zen_service_button_link',
	array(
		'default'           => '',
		'sanitize_callback' => 'esc_url_raw',
	)
);

$wp_customize->add_control(
	'charity_zen_service_button_link',
	array(
		'label'           => esc_html__( 'Button Link', 'charity-zen' ),
		'section'         => 'charity_zen_service_section',
		'settings'        => 'charity_zen_service_button_link',
		'type'            => 'url',
		'active_callback' => 'charity_zen_is_service_section_enabled',
	)
);
