<?php
/**
 * Associate Section
 *
 * @package Charity_Zen
 */

$wp_customize->add_section(
	'charity_zen_associate_section',
	array(
		'panel' => 'travellable_front_page_options',
		'title' => esc_html__( 'Associate Section', 'charity-zen' ),
	)
);

// Associate Section - Enable Section.
$wp_customize->add_setting(
	'charity_zen_enable_associate_section',
	array(
		'default'           => false,
		'sanitize_callback' => 'travellable_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Travellable_Toggle_Switch_Custom_Control(
		$wp_customize,
		'charity_zen_enable_associate_section',
		array(
			'label'    => esc_html__( 'Enable Associate Section', 'charity-zen' ),
			'section'  => 'charity_zen_associate_section',
			'settings' => 'charity_zen_enable_associate_section',
		)
	)
);

if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'charity_zen_enable_associate_section',
		array(
			'selector' => '#charity_zen_associate_section .section-link',
			'settings' => 'charity_zen_enable_associate_section',
		)
	);
}

// Associate Section - Section Title.
$wp_customize->add_setting(
	'charity_zen_associate_title',
	array(
		'default'           => __( 'Our Partners', 'charity-zen' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'charity_zen_associate_title',
	array(
		'label'           => esc_html__( 'Section Title', 'charity-zen' ),
		'section'         => 'charity_zen_associate_section',
		'settings'        => 'charity_zen_associate_title',
		'type'            => 'text',
		'active_callback' => 'charity_zen_is_associate_section_enabled',
	)
);

for ( $i = 1; $i <= 5; $i++ ) {

	$wp_customize->add_setting(
		'charity_zen_associate_logo_' . $i,
		array(
			'sanitize_callback' => 'travellable_sanitize_image',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Image_Control(
			$wp_customize,
			'charity_zen_associate_logo_' . $i,
			array(
				'label'           => esc_html__( 'Logo ', 'charity-zen' ) . $i,
				'section'         => 'charity_zen_associate_section',
				'settings'        => 'charity_zen_associate_logo_' . $i,
				'active_callback' => 'charity_zen_is_associate_section_enabled',
			)
		)
	);

}
