<?php
/**
 * Theme Customizer
 *
 * @package Charity_Zen
 */

if ( class_exists( 'WP_Customize_Control' ) ) {

	/**
	 * Sortable Repeater Custom Control
	 */
	class Charity_Zen_Sortable_Repeater_Custom_Control extends WP_Customize_Control {
		/**
		 * The type of control being rendered
		 */
		public $type = 'sortable_repeater';

		/**
		 * Button labels
		 */
		public $button_labels = array();

		/**
		 * Constructor
		 */
		public function __construct( $manager, $id, $args = array(), $options = array() ) {
			parent::__construct( $manager, $id, $args );
			// Merge the passed button labels with our default labels
			$this->button_labels = wp_parse_args(
				$this->button_labels,
				array(
					'add' => __( 'Add', 'charity-zen' ),
				)
			);
		}

		/**
		 * Render the control in the customizer
		 */
		public function render_content() {
			?>
			<div class="sortable_repeater_control">
				<?php if ( ! empty( $this->label ) ) { ?>
					<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
				<?php } ?>
				<?php if ( ! empty( $this->description ) ) { ?>
					<span class="customize-control-description"><?php echo esc_html( $this->description ); ?></span>
				<?php } ?>
				<input type="hidden" id="<?php echo esc_attr( $this->id ); ?>" name="<?php echo esc_attr( $this->id ); ?>" value="<?php echo esc_attr( $this->value() ); ?>" class="customize-control-sortable-repeater" <?php $this->link(); ?> />
				<div class="sortable_repeater sortable">
					<div class="repeater">
						<input type="text" value="" class="repeater-input" placeholder="https://" /><span class="dashicons dashicons-sort"></span><a class="customize-control-sortable-repeater-delete" href="#"><span class="dashicons dashicons-no-alt"></span></a>
					</div>
				</div>
				<button class="button customize-control-sortable-repeater-add" type="button"><?php echo esc_html( $this->button_labels['add'] ); ?></button>
			</div>
			<?php
		}
	}

}

function charity_zen_customize_register( $wp_customize ) {
	require get_theme_file_path() . '/inc/customizer/service.php';

	require get_theme_file_path() . '/inc/customizer/team.php';

	require get_theme_file_path() . '/inc/customizer/associate.php';
}
add_action( 'customize_register', 'charity_zen_customize_register' );

function charity_zen_customize_preview_js() {
	// Append .min if SCRIPT_DEBUG is false.
	$min = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';
	wp_enqueue_script( 'charity-zen-customizer', get_stylesheet_directory_uri() . '/assets/js/customizer' . $min . '.js', array( 'customize-preview', 'travellable-customizer' ), '1.0', true );
}
add_action( 'customize_preview_init', 'charity_zen_customize_preview_js' );

function charity_zen_custom_control_scripts() {
	// Append .min if SCRIPT_DEBUG is false.
	$min = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';
	wp_enqueue_style( 'charity-zen-custom-controls-css', get_stylesheet_directory_uri() . '/assets/css/custom-controls' . $min . '.css', array( 'travellable-custom-controls-css' ), '1.0', 'all' );
	wp_enqueue_script( 'charity-zen-custom-controls-js', get_stylesheet_directory_uri() . '/assets/js/custom-controls' . $min . '.js', array( 'jquery', 'jquery-ui-core', 'jquery-ui-sortable', 'travellable-custom-controls-js' ), '1.0', true );
}
add_action( 'customize_controls_enqueue_scripts', 'charity_zen_custom_control_scripts' );

/*=====================Active Callback=================*/

// Service section.
function charity_zen_is_service_section_enabled( $control ) {
	return ( $control->manager->get_setting( 'charity_zen_enable_service_section' )->value() );
}

// Team section.
function charity_zen_is_team_section_enabled( $control ) {
	return ( $control->manager->get_setting( 'charity_zen_enable_team_section' )->value() );
}

// Associate section.
function charity_zen_is_associate_section_enabled( $control ) {
	return ( $control->manager->get_setting( 'charity_zen_enable_associate_section' )->value() );
}
