<?php
/**
 * Charity Zen functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Charity_Zen
 */

if ( ! function_exists( 'charity_zen_setup' ) ) :
	function charity_zen_setup() {
		/*
		* Make child theme available for translation.
		* Translations can be filed in the /languages/ directory.
		*/
		load_child_theme_textdomain( 'charity-zen', get_stylesheet_directory() . '/languages' );
	}
endif;
add_action( 'after_setup_theme', 'charity_zen_setup' );

if ( ! function_exists( 'charity_zen_enqueue_styles' ) ) :
	/**
	 * Enqueue scripts and styles.
	 */
	function charity_zen_enqueue_styles() {
		$parenthandle = 'travellable-style';
		$theme        = wp_get_theme();
		
		// Append .min if SCRIPT_DEBUG is false.
		$min = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';
		wp_enqueue_style(
			$parenthandle,
			get_template_directory_uri() . '/style.css',
			array(
				'travellable-slick',
				'travellable-slick-theme',
				'travellable-bootstrap-style',
				'travellable-bootstrap-icon-style',
				'travellable-google-fonts',
			),
			$theme->parent()->get( 'Version' )
		);

		wp_enqueue_style(
			'charity-zen-style',
			get_stylesheet_uri(),
			array( $parenthandle ),
			$theme->get( 'Version' )
		);

		wp_enqueue_script( 'charity-zen-script', get_stylesheet_directory_uri() . '/assets/js/custom' . $min . '.js', array( 'jquery', 'travellable-custom' ), $theme->get( 'Version' ), true );
	}

endif;

add_action( 'wp_enqueue_scripts', 'charity_zen_enqueue_styles' );

/**
 * Add section link on customizer preview.
 */
function charity_zen_section_link( $section_id ) {
	$section_name      = str_replace( 'charity_zen_', ' ', $section_id );
	$section_name      = str_replace( '_', ' ', $section_name );
	$starting_notation = '#';
	?>
	<span class="section-link">
		<span class="section-link-title"><?php echo esc_html( $section_name ); ?></span>
	</span>
	<style type="text/css">
		<?php echo $starting_notation . $section_id; ?>:hover .section-link {
			visibility: visible;
		}
	</style>
	<?php
}

if ( ! function_exists( 'travellable_get_default_color' ) ) {
	/**
	 * Returns default colors.
	 */
	function travellable_get_default_color() {
		$color['primary']   = '#6dbc1e';
		$color['secondary'] = '#eddb2d';
		return $color;
	}
}

/**
 * Dynamic CSS
 */
function charity_zen_dynamic_css() {
	$default_color = travellable_get_default_color();

	$primary_color   = get_theme_mod( 'primary_color', $default_color['primary'] );
	$secondary_color = get_theme_mod( 'secondary_color', $default_color['secondary'] );

	$custom_css = '
	.explore-callout .btn-link:hover,
	.explore-callout .btn-link:focus {
		color: ' . esc_attr( $primary_color ) . ';
	}

	.newsletter button[type="submit"]:hover,
	.newsletter button[type="submit"]:focus {
		background-color: ' . esc_attr( $primary_color ) . ';
	}

    .site-info a:hover, .site-info a:focus,
    .thumbnail-list.gallery-section.style-2 .media-box h4:hover,
	.team-volunteers .team-volunteers-wrapper .team-volunteers-single a:hover,
	.team-volunteers .team-volunteers-wrapper .team-volunteers-single a:focus {
    	color: ' . esc_attr( $secondary_color ) . ';
    }

	.main-slider .slick-dots li button,
    .newsletter-callout.style-2,
    .counter-style-2 .why-callout-list {
    	background-color: ' . esc_attr( $secondary_color ) . ';
    }
    ';

	if ( ! has_custom_logo() ) {
		$custom_css .= '
		.header-top-left {
			padding-left: 15px;
		}
		';
	}

	wp_add_inline_style( 'charity-zen-style', $custom_css );
}
add_action( 'wp_enqueue_scripts', 'charity_zen_dynamic_css', 99 );

require get_theme_file_path() . '/inc/customizer.php';
