
// Creta Testimonial Showcase plugin activation
document.addEventListener('DOMContentLoaded', function () {
    const charity_organization_button = document.getElementById('install-activate-button');

    if (!charity_organization_button) return;

    charity_organization_button.addEventListener('click', function (e) {
        e.preventDefault();

        const charity_organization_redirectUrl = charity_organization_button.getAttribute('data-redirect');

        // Step 1: Check if plugin is already active
        const charity_organization_checkData = new FormData();
        charity_organization_checkData.append('action', 'check_creta_testimonial_activation');

        fetch(installcretatestimonialData.ajaxurl, {
            method: 'POST',
            body: charity_organization_checkData,
        })
        .then(res => res.json())
        .then(res => {
            if (res.success && res.data.active) {
                // Plugin is already active → just redirect
                window.location.href = charity_organization_redirectUrl;
            } else {
                // Not active → proceed with install + activate
                charity_organization_button.textContent = 'Nevigate Getstart';

                const charity_organization_installData = new FormData();
                charity_organization_installData.append('action', 'install_and_activate_creta_testimonial_plugin');
                charity_organization_installData.append('_ajax_nonce', installcretatestimonialData.nonce);

                fetch(installcretatestimonialData.ajaxurl, {
                    method: 'POST',
                    body: charity_organization_installData,
                })
                .then(res => res.json())
                .then(res => {
                    if (res.success) {
                        window.location.href = charity_organization_redirectUrl;
                    } else {
                        alert('Activation error: ' + (res.data?.message || 'Unknown error'));
                        charity_organization_button.textContent = 'Try Again';
                    }
                })
                .catch(error => {
                    alert('Request failed: ' + error.message);
                    charity_organization_button.textContent = 'Try Again';
                });
            }
        })
        .catch(error => {
            alert('Check request failed: ' + error.message);
        });
    });
});
