<?php
add_action( 'admin_menu', 'charity_organization_getting_started' );
function charity_organization_getting_started() {
	add_theme_page( esc_html__('Get Started', 'charity-organization'), esc_html__('Get Started', 'charity-organization'), 'edit_theme_options', 'charity-organization-guide-page', 'charity_organization_test_guide');
}

// Add a Custom CSS file to WP Admin Area
function charity_organization_admin_theme_style() {
   wp_enqueue_style('custom-admin-style', esc_url(get_template_directory_uri()) . '/inc/get-started/get-started.css');
}
add_action('admin_enqueue_scripts', 'charity_organization_admin_theme_style');

//guidline for about theme
function charity_organization_test_guide() { 
	//custom function about theme customizer
	$return = add_query_arg( array()) ;
	$theme = wp_get_theme( 'charity-organization' );
?>
	<div class="wrapper-outer">
		<div class="left-main-box">
			<div class="intro"><h3><?php echo esc_html( $theme->Name ); ?></h3></div>
			<div class="left-inner">
				<div class="about-wrapper">
					<div class="col-left">
						<p><?php echo esc_html( $theme->get( 'Description' ) ); ?></p>
					</div>
					<div class="col-right">
						<img role="img" src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/get-started/images/screenshot.png" alt="" />
					</div>
				</div>
				<div class="link-wrapper">
					<h4><?php esc_html_e('Important Links', 'charity-organization'); ?></h4>
					<div class="link-buttons">
						<a href="<?php echo esc_url( CHARITY_ORGANIZATION_THEME_DOC ); ?>" target="_blank"><?php esc_html_e('Free Setup Guide', 'charity-organization'); ?></a>
						<a href="<?php echo esc_url( CHARITY_ORGANIZATION_SUPPORT ); ?>" target="_blank"><?php esc_html_e('Support Forum', 'charity-organization'); ?></a>
						<a href="<?php echo esc_url( CHARITY_ORGANIZATION_PRO_DEMO ); ?>" target="_blank"><?php esc_html_e('Live Demo', 'charity-organization'); ?></a>
						<a href="<?php echo esc_url( CHARITY_ORGANIZATION_PRO_THEME_DOC ); ?>" target="_blank"><?php esc_html_e('Pro Setup Guide', 'charity-organization'); ?></a>
					</div>
				</div>
				<div class="support-wrapper">
					<div class="editor-box">
						<i class="dashicons dashicons-admin-appearance"></i>
						<h4><?php esc_html_e('Theme Customization', 'charity-organization'); ?></h4>
						<p><?php esc_html_e('Effortlessly modify & maintain your site using editor.', 'charity-organization'); ?></p>
						<div class="support-button">
							<a class="button button-primary" href="<?php echo esc_url( admin_url( 'site-editor.php' ) ); ?>" target="_blank"><?php esc_html_e('Site Editor', 'charity-organization'); ?></a>
						</div>
					</div>
					<div class="support-box">
						<i class="dashicons dashicons-microphone"></i>
						<h4><?php esc_html_e('Need Support?', 'charity-organization'); ?></h4>
						<p><?php esc_html_e('Go to our support forum to help you in case of queries.', 'charity-organization'); ?></p>
						<div class="support-button">
							<a class="button button-primary" href="<?php echo esc_url( CHARITY_ORGANIZATION_SUPPORT ); ?>" target="_blank"><?php esc_html_e('Get Support', 'charity-organization'); ?></a>
						</div>
					</div>
					<div class="review-box">
						<i class="dashicons dashicons-star-filled"></i>
						<h4><?php esc_html_e('Leave Us A Review', 'charity-organization'); ?></h4>
						<p><?php esc_html_e('Are you enjoying Our Theme? We would Love to hear your Feedback.', 'charity-organization'); ?></p>
						<div class="support-button">
							<a class="button button-primary" href="<?php echo esc_url( CHARITY_ORGANIZATION_REVIEW ); ?>" target="_blank"><?php esc_html_e('Rate Us', 'charity-organization'); ?></a>
						</div>
					</div>
				</div>
			</div>
			<div class="go-premium-box">
				<h4><?php esc_html_e('Why Go For Premium?', 'charity-organization'); ?></h4>
				<ul class="pro-list">
					<li><?php esc_html_e('Advanced Customization Options', 'charity-organization');?></li>
					<li><?php esc_html_e('One-Click Demo Import', 'charity-organization');?></li>
					<li><?php esc_html_e('WooCommerce Integration & Enhanced Features', 'charity-organization');?></li>
					<li><?php esc_html_e('Performance Optimization & SEO-Ready', 'charity-organization');?></li>
					<li><?php esc_html_e('Premium Support & Regular Updates', 'charity-organization');?></li>
				</ul>
			</div>
		</div>
		<div class="right-main-box">
			<div class="right-inner">
				<div class="pro-boxes">
					<h4><?php esc_html_e('Get Theme Bundle', 'charity-organization'); ?></h4>
					<p><?php esc_html_e('60+ Premium WordPress Themes', 'charity-organization'); ?></p>
					<p class="main-bundle-price" ><strong class="cancel-bundle-price"><?php esc_html_e('$2340', 'charity-organization'); ?></strong><span class="bundle-price"><?php esc_html_e('$86', 'charity-organization'); ?></span></p>
					<img role="img" src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/get-started/images/bundle.png" alt="bundle image" />
					<p><?php esc_html_e('SUMMER SALE: ', 'charity-organization'); ?><strong><?php esc_html_e('Extra 20%', 'charity-organization'); ?></strong><?php esc_html_e(' OFF on WordPress Theme Bundle Use Code: ', 'charity-organization'); ?><strong><?php esc_html_e('“HEAT20”', 'charity-organization'); ?></strong></p>
					<a href="<?php echo esc_url( CHARITY_ORGANIZATION_PRO_THEME_BUNDLE ); ?>" target="_blank"><?php esc_html_e('Get Theme Bundle For $86', 'charity-organization'); ?></a>
				</div>
				<div class="pro-boxes pro-theme-container">
					<h4><?php esc_html_e('Charity Organization Pro', 'charity-organization'); ?></h4>
					<p class="pro-theme-price" ><?php esc_html_e('$39', 'charity-organization'); ?></p>
					<img role="img" src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/get-started/images/premium.png" alt="premium image" />
					<p><?php esc_html_e('SUMMER SALE: ', 'charity-organization'); ?><strong><?php esc_html_e('Extra 25%', 'charity-organization'); ?></strong><?php esc_html_e(' OFF on WordPress Block Themes! Use Code: ', 'charity-organization'); ?><strong><?php esc_html_e('“SUMMER25”', 'charity-organization'); ?></strong></p>
					<a href="<?php echo esc_url( CHARITY_ORGANIZATION_BUY_NOW ); ?>" target="_blank"><?php esc_html_e('Upgrade To Pro', 'charity-organization'); ?></a>
				</div>
				<div class="pro-boxes last-pro-box">
					<h4><?php esc_html_e('View All Our Themes', 'charity-organization'); ?></h4>
					<img role="img" src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/get-started/images/all-themes.png" alt="all themes image" />
					<a href="<?php echo esc_url( CHARITY_ORGANIZATION_PRO_ALL_THEMES ); ?>" target="_blank"><?php esc_html_e('View All Our Premium Themes', 'charity-organization'); ?></a>
				</div>
			</div>
		</div>
	</div>
<?php } ?>