<?php
/**
 * Charity Organization functions and definitions
 *
 * @package charity_organization
 * @since 1.0
 */

if ( ! function_exists( 'charity_organization_support' ) ) :
	function charity_organization_support() {

		load_theme_textdomain( 'charity-organization', get_template_directory() . '/languages' );

		// Add support for block styles.
		add_theme_support( 'wp-block-styles' );

		add_theme_support('woocommerce');

		// Enqueue editor styles.
		add_editor_style(get_stylesheet_directory_uri() . '/assets/css/editor-style.css');

		/* Theme Credit link */
		define('CHARITY_ORGANIZATION_BUY_NOW',__('https://www.cretathemes.com/products/charity-wordpress-theme','charity-organization'));
		define('CHARITY_ORGANIZATION_PRO_DEMO',__('https://pattern.cretathemes.com/charity-organization/','charity-organization'));
		define('CHARITY_ORGANIZATION_THEME_DOC',__('https://pattern.cretathemes.com/free-guide/charity-organization/','charity-organization'));
		define('CHARITY_ORGANIZATION_PRO_THEME_DOC',__('https://pattern.cretathemes.com/pro-guide/charity-organization/','charity-organization'));
		define('CHARITY_ORGANIZATION_SUPPORT',__('https://wordpress.org/support/theme/charity-organization/','charity-organization'));
		define('CHARITY_ORGANIZATION_REVIEW',__('https://wordpress.org/support/theme/charity-organization/reviews/#new-post','charity-organization'));
		define('CHARITY_ORGANIZATION_PRO_THEME_BUNDLE',__('https://www.cretathemes.com/products/wordpress-theme-bundle','charity-organization'));
		define('CHARITY_ORGANIZATION_PRO_ALL_THEMES',__('https://www.cretathemes.com/collections/wordpress-block-themes','charity-organization'));

	}
endif;

add_action( 'after_setup_theme', 'charity_organization_support' );

if ( ! function_exists( 'charity_organization_styles' ) ) :
	function charity_organization_styles() {
		// Register theme stylesheet.
		$charity_organization_theme_version = wp_get_theme()->get( 'Version' );

		$charity_organization_version_string = is_string( $charity_organization_theme_version ) ? $charity_organization_theme_version : false;
		wp_enqueue_style(
			'charity-organization-style',
			get_template_directory_uri() . '/style.css',
			array(),
			$charity_organization_version_string
		);

		wp_enqueue_style( 'animate-css', esc_url(get_template_directory_uri()).'/assets/css/animate.css' );

		wp_enqueue_script( 'jquery-wow', esc_url(get_template_directory_uri()) . '/assets/js/wow.js', array('jquery') );

		wp_enqueue_script( 'charity-organization-custom-script', get_theme_file_uri( '/assets/js/custom-script.js' ), array( 'jquery' ), true );

		wp_enqueue_style( 'dashicons' );

		wp_style_add_data( 'charity-organization-style', 'rtl', 'replace' );

		//font-awesome
		wp_enqueue_style( 'fontawesome', get_template_directory_uri() . '/inc/fontawesome/css/all.css'
			, array(), '6.7.0' );

		//homepage slider
		wp_enqueue_style('charity-organization-swiper-bundle-style', get_template_directory_uri() . '/assets/css/swiper-bundle.css', array(), $charity_organization_version_string);

		wp_enqueue_script('charity-organization-swiper-bundle-scripts', get_template_directory_uri() . '/assets/js/swiper-bundle.js', array(), $charity_organization_version_string, true);
	}
endif;

add_action( 'wp_enqueue_scripts', 'charity_organization_styles' );

/* Enqueue admin-notice-script js */
add_action('admin_enqueue_scripts', function ($hook) {
    if ($hook !== 'appearance_page_charity-organization') return;

    wp_enqueue_script('admin-notice-script', get_template_directory_uri() . '/get-started/js/admin-notice-script.js', ['jquery'], null, true);
    wp_localize_script('admin-notice-script', 'pluginInstallerData', [
        'ajaxurl'     => admin_url('admin-ajax.php'),
        'nonce'       => wp_create_nonce('install_cretatestimonial_nonce'), // Match this with PHP nonce check
        'redirectUrl' => admin_url('themes.php?page=charity-organization-guide-page'),
    ]);
});

add_action('wp_ajax_check_creta_testimonial_activation', function () {
    include_once ABSPATH . 'wp-admin/includes/plugin.php';
    $charity_organization_plugin_file = 'creta-testimonial-showcase/creta-testimonial-showcase.php';

    if (is_plugin_active($charity_organization_plugin_file)) {
        wp_send_json_success(['active' => true]);
    } else {
        wp_send_json_success(['active' => false]);
    }
});


// Add block patterns
require get_template_directory() . '/inc/block-patterns.php';

// Add block styles
require get_template_directory() . '/inc/block-styles.php';

// Block Filters
require get_template_directory() . '/inc/block-filters.php';

// Svg icons
require get_template_directory() . '/inc/icon-function.php';

// TGM plugin
require get_template_directory() . '/inc/tgm-plugin/plugin-activation.php';

// Customizer
require get_template_directory() . '/inc/customizer.php';

// Get Started.
require get_template_directory() . '/inc/get-started/get-started.php';

// Add Getstart admin notice
function charity_organization_admin_notice() { 
    global $pagenow;
    $theme_args      = wp_get_theme();
    $meta            = get_option( 'charity_organization_admin_notice' );
    $name            = $theme_args->__get( 'Name' );
    $current_screen  = get_current_screen();

    if( !$meta ){
	    if( is_network_admin() ){
	        return;
	    }

	    if( ! current_user_can( 'manage_options' ) ){
	        return;
	    } if($current_screen->base != 'appearance_page_charity-organization-guide-page' && $current_screen->base != 'toplevel_page_cretats-theme-showcase' ) { ?>

	    <div class="notice notice-success dash-notice">
	        <h1><?php esc_html_e('Hey, Thank you for installing Charity Organization Theme!', 'charity-organization'); ?></h1>
	        <p><a href="javascript:void(0);" id="install-activate-button" class="button admin-button info-button get-start-btn">
				   <?php echo __('Nevigate Getstart', 'charity-organization'); ?>
				</a>

				<script type="text/javascript">
				document.getElementById('install-activate-button').addEventListener('click', function () {
				    const charity_organization_button = this;
				    const charity_organization_redirectUrl = '<?php echo esc_url(admin_url("themes.php?page=charity-organization-guide-page")); ?>';
				    // First, check if plugin is already active
				    jQuery.post(ajaxurl, { action: 'check_creta_testimonial_activation' }, function (response) {
				        if (response.success && response.data.active) {
				            // Plugin already active — just redirect
				            window.location.href = charity_organization_redirectUrl;
				        } else {
				            // Show Installing & Activating only if not already active
				            charity_organization_button.textContent = 'Nevigate Getstart';

				            jQuery.post(ajaxurl, {
				                action: 'install_and_activate_creta_testimonial_plugin',
				                nonce: '<?php echo wp_create_nonce("install_activate_nonce"); ?>'
				            }, function (response) {
				                if (response.success) {
				                    window.location.href = charity_organization_redirectUrl;
				                } else {
				                    alert('Failed to activate the plugin.');
				                    charity_organization_button.textContent = 'Try Again';
				                }
				            });
				        }
				    });
				});
				</script>
				
	        	<a class="button button-primary site-edit" href="<?php echo esc_url( admin_url( 'site-editor.php' ) ); ?>"><?php esc_html_e('Site Editor', 'charity-organization'); ?></a> 
				<a class="button button-primary buy-now-btn" href="<?php echo esc_url( CHARITY_ORGANIZATION_BUY_NOW ); ?>" target="_blank"><?php esc_html_e('Buy Pro', 'charity-organization'); ?></a>
				<a class="button button-primary bundle-btn" href="<?php echo esc_url( CHARITY_ORGANIZATION_PRO_THEME_BUNDLE ); ?>" target="_blank"><?php esc_html_e('Get Bundle', 'charity-organization'); ?></a>
	        </p>
	        <p class="dismiss-link"><strong><a href="?charity_organization_admin_notice=1"><?php esc_html_e( 'Dismiss', 'charity-organization' ); ?></a></strong></p>
	    </div>
	    <?php

	}?>
	    <?php

	}
}

add_action( 'admin_notices', 'charity_organization_admin_notice' );

if( ! function_exists( 'charity_organization_update_admin_notice' ) ) :
/**
 * Updating admin notice on dismiss
*/
function charity_organization_update_admin_notice(){
    if ( isset( $_GET['charity_organization_admin_notice'] ) && $_GET['charity_organization_admin_notice'] = '1' ) {
        update_option( 'charity_organization_admin_notice', true );
    }
}
endif;
add_action( 'admin_init', 'charity_organization_update_admin_notice' );

//After Switch theme function
add_action('after_switch_theme', 'charity_organization_getstart_setup_options');
function charity_organization_getstart_setup_options () {
    update_option('charity_organization_admin_notice', FALSE );
}
add_action('admin_bar_menu', 'your_plugin_adminbar_link', 100);
function your_plugin_adminbar_link($wp_admin_bar) {
    $wp_admin_bar->add_node([
        'id'    => 'yourplugin_upgrade',
        'title' => ' Upgrade to Pro',
        'href'  => 'https://www.cretathemes.com/products/charity-wordpress-theme',
        'meta'  => array(
            'target' => '_blank',
        )
    ]);
}