<?php
/**
 * Header data
 *
 * @package WordPress
 * @subpackage Charitas Lite
 * @since Charitas Lite 1.0
 */


/*-----------------------------------------------------------------------------------*/
/*	Include CSS
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'wpl_css_include' ) ) {

	function wpl_css_include () {

		/*-----------------------------------------------------------
			Vendors
		-----------------------------------------------------------*/
		wp_enqueue_style( 'charitas-vendors', get_template_directory_uri() . '/assets/styles/vendors.min.css', array(), wp_get_theme()->get('Version') );

		/*-----------------------------------------------------------------------------------*/
		/*	Google Fonts
		/*-----------------------------------------------------------------------------------*/
		wp_enqueue_style( 'google-fonts', 'https://fonts.googleapis.com/css?family=Arimo:400,700,400italic,700italic|Archivo Narrow:400,400italic,700italic,700:latin,cyrillic-ext,greek-ext,vietnamese,greek,latin-ext,cyrillic' );

		/*-----------------------------------------------------------
			Loads our main stylesheet.
		-----------------------------------------------------------*/

		wp_enqueue_style( 'charitaslite-style', get_stylesheet_uri(), array(), wp_get_theme()->get('Version') );

	}

	add_action( 'wp_enqueue_scripts', 'wpl_css_include' );
}

/*-----------------------------------------------------------------------------------*/
/*	Include Java Scripts
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'wpl_scripts_include' ) ) {

	function wpl_scripts_include() {

		/*-----------------------------------------------------------
			Include jQuery
		-----------------------------------------------------------*/

		wp_enqueue_script('jquery');


		if ( is_singular() && comments_open() ) {
			wp_enqueue_script( 'comment-reply' );
		}


		/*-----------------------------------------------------------
			Base custom scripts
		-----------------------------------------------------------*/

		wp_enqueue_script( 'base', get_template_directory_uri().'/assets/javascripts/base.min.js', '', '', 'footer' );


		/*-----------------------------------------------------------
			FlexSlider
		-----------------------------------------------------------*/

		wp_enqueue_script( 'flexslider', get_template_directory_uri().'/assets/javascripts/jquery.flexslider.min.js', '', '', 'footer' );

		/*-----------------------------------------------------------
			meanMenu
		-----------------------------------------------------------*/

		wp_enqueue_script( 'meanmenu', get_template_directory_uri().'/assets/javascripts/jquery.meanmenu.min.js', '', '', 'footer' );

		/*-----------------------------------------------------------
			Fitvids
		-----------------------------------------------------------*/

		wp_enqueue_script( 'fitvids', get_template_directory_uri().'/assets/javascripts/jquery.fitvids.min.js', '', '', 'footer' );

	}
	add_action('wp_enqueue_scripts', 'wpl_scripts_include');
}


/*-----------------------------------------------------------------------------------*/
/*	Doctitle
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'wplook_doctitle' ) ) {

	function wplook_doctitle() {

		if ( is_search() ) {
		  $content = __('Search Results for:', 'charitas-lite');
		  $content .= ' ' . esc_html(stripslashes(get_search_query()));
		}

		elseif ( is_category() ) {
		  $content = __('', 'charitas-lite');
		  $content .= ' ' . single_cat_title("", false);
		}

		elseif ( is_day() ) {
			$content = __( '', 'charitas-lite');
			$content .= ' ' . esc_html(stripslashes( get_the_date()));
		}

		elseif ( is_month() ) {
			$content = __( '', 'charitas-lite');
			$content .= ' ' . esc_html(stripslashes( get_the_date( 'F Y' )));
		}
		elseif ( is_year()  ) {
			$content = __( '', 'charitas-lite');
			$content .= ' ' . esc_html(stripslashes( get_the_date( 'Y' ) ));
		}

		elseif ( is_tag() ) {
		  $content = __('', 'charitas-lite');
		  $content .= ' ' . single_tag_title( '', false );
		}

		elseif ( is_author() ) {
		  $content = __("", 'charitas-lite');

		}

		elseif ( is_404() ) {
		  $content = __('Not Found', 'charitas-lite');
		}

		else {
			$content = '';
		}

		$elements = array("content" => $content);

		// Filters should return an array
		$elements = apply_filters('wplook_doctitle', $elements);

		// But if they don't, it won't try to implode
			if(is_array($elements)) {
			  $doctitle = implode(' ', $elements);
			} else {
			  $doctitle = $elements;
			}

			if ( is_search() || is_category() || is_day() || is_month() || is_year() || is_404() || is_tag() || is_author() ) {
				$doctitle = "<header class=\"page-header\"><h1 class=\"page-title\">" . $doctitle . "</h1><div class=\"left-corner\"></div></header>";
			}

		echo $doctitle;

	}
} ?>
