<?php if ( get_header_image() ) : ?>
	<a href="<?php echo esc_url( home_url( '/' ) ); ?>" id="custom-header" rel="home">
		<img src="<?php echo esc_url( header_image() ); ?>" width="<?php echo esc_attr( get_custom_header()->width ); ?>" height="<?php echo esc_attr( get_custom_header()->height ); ?>" alt="<?php echo esc_attr( get_bloginfo( 'title' ) ); ?>">
	</a>
<?php endif; ?>

<?php
// Header values with translations
$tophead_btntext        = esc_attr( get_theme_mod( 'tophead_btntext', __( 'INITIALIZE', 'cctv-security-camera' ) ) );
$tophead_btnlink        = esc_attr( get_theme_mod( 'tophead_btnlink', '#' ) );

$stickyheader           = esc_attr( cctvsecuritycamera_sticky_menu() );
?>
<div class="main">
    <header class="main-header site-header <?php echo esc_attr( $stickyheader ); ?>">
        <div class="header-section">
            <div class="container">
                <div class="bthead">
                    <div class="btmmhead">
                        <div class="row mr-0">
                            <div class="m-box">
                                <div class="menus">
                                    <nav class="navbar navbar-expand-lg navbaroffcanvase">
                                        <div class="navbar-menubar">
                                            <!-- Small Device Menu -->
                                            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target=".navbar-menu" aria-label="<?php echo esc_attr__( 'Toggle navigation', 'cctv-security-camera' ); ?>">
                                                <i class="fa fa-bars"></i>
                                            </button>
                                            <div class="collapse navbar-collapse navbar-menu">
                                                <button class="navbar-toggler navbar-toggler-close" type="button" data-bs-toggle="collapse" data-bs-target=".navbar-menu" aria-label="<?php echo esc_attr__( 'Toggle navigation', 'cctv-security-camera' ); ?>">
                                                    <i class="fa fa-times"></i>
                                                </button>
                                                <?php
                                                wp_nav_menu( array(
                                                    'theme_location' => 'primary_menu',
                                                    'container'      => '',
                                                    'menu_class'     => 'navbar-nav main-nav',
                                                    'fallback_cb'    => 'WP_Bootstrap_Navwalker::fallback',
                                                    'walker'         => new WP_Bootstrap_Navwalker(),
                                                ) );
                                                ?>
                                            </div>
                                        </div>
                                    </nav>
                                </div>
                                <div class="clearfix"></div>
                            </div>
                            <div class="logobxout">
                                <div class="logobx">
                                    <div class="site-logo">
                                        <?php if ( has_custom_logo() ) : ?>
                                            <?php the_custom_logo(); ?>
                                        <?php else : ?>
                                            <a class="site-title" href="<?php echo esc_url( home_url( '/' ) ); ?>">
                                                <?php echo esc_html( get_bloginfo( 'name' ) ); ?>
                                            </a>
                                            <div class="box-info">
                                                <?php
                                                $cctvsecuritycamera_site_desc = get_bloginfo( 'description' );
                                                if ( $cctvsecuritycamera_site_desc ) :
                                                    ?>
                                                    <p class="site-description"><?php echo esc_html( $cctvsecuritycamera_site_desc ); ?></p>
                                                <?php endif; ?>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="iconbx">
                                <div class="icons">
                                    <?php if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) { ?>
                                        <div class="wcbox">
                                            <div class="row">
                                                <div class="col-4 icbx"> 
                                                    <div class="top-form">
                                                        <button type="button" id="formButton" ></button>        
                                                        <form id="form1">                   
                                                            <?php get_search_form(); ?>
                                                        </form>
                                                    </div>                                 
                                                </div>

                                                <div class="col-4 icbx">
                                                    <a class="h-cart" href="<?php if(function_exists('wc_get_cart_url')){ echo esc_url(wc_get_cart_url()); } ?>" >
                                                        <i class="fa fa-shopping-bag" ></i>
                                                        <?php 
                                                            
                                                            $count = WC()->cart->cart_contents_count;
                                                            $cart_url = wc_get_cart_url();
                                                            if ( $count > 0 ) {
                                                            ?>
                                                                <span><?php echo esc_html( $count ); ?></span>
                                                            <?php 
                                                            }
                                                            else {
                                                                ?>
                                                                <span><?php echo esc_html_e('0','cctv-security-camera'); ?></span>
                                                                <?php 
                                                            }
                                                            
                                                        ?>
                                                    </a>
                                                </div>

                                                <div class="col-4 icbx">
                                                    <a class="acc" href="<?php echo get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>">
                                                        <i class="fa-regular fa-user"></i>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    <?php } ?>
                                </div>
                            </div>
                            <div class="bttnbx">
                                <a href="<?php echo esc_url( apply_filters( 'cctvsecuritycamera_header', $tophead_btnlink ) ); ?>">
                                    <i class="fa-solid fa-bolt"></i>
                                    <?php echo esc_html( apply_filters( 'cctvsecuritycamera_header', $tophead_btntext ) ); ?>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>
    <div class="clearfix"></div>
</div>
