<?php
/**
 * The template for displaying search form.
 *
 * @package     Cctv Security Camera
 * @since       0.1
 */
?>

<form method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
	<label>
		<span class="screen-reader-text"><?php esc_html_e( 'Search for:', 'cctv-security-camera' ); ?></span>
		<input type="search" class="search-field" placeholder="<?php esc_attr_e( 'Search …', 'cctv-security-camera' ); ?>" value="" name="s">
	</label>
	<button type="submit" class="search-submit" value="<?php esc_attr_e( 'Search', 'cctv-security-camera' ); ?>">
		<i class="fa fa-search"></i>
	</button>
</form>