<?php
/**
 * Cctv Security Camera Theme Customizer.
 *
 * @package Cctv Security Camera
 */

 if ( ! class_exists( 'cctvsecuritycamera_Customizer' ) ) {

	/**
	 * Customizer Loader
	 *
	 * @since 1.0.0
	 */
	class cctvsecuritycamera_Customizer {

		/**
		 * Instance
		 *
		 * @access private
		 * @var object
		 */
		private static $instance;

		/**
		 * Initiator
		 */
		public static function get_instance() {
			if ( ! isset( self::$instance ) ) {
				self::$instance = new self;
			}
			return self::$instance;
		}

		/**
		 * Constructor
		 */
		public function __construct() {
			/**
			 * Customizer
			 */
			add_action( 'customize_preview_init',                  array( $this, 'cctvsecuritycamera_customize_preview_js' ) );
			add_action( 'customize_controls_enqueue_scripts', 	   array( $this, 'cctvsecuritycamera_customizer_script' ) );
			add_action( 'customize_register',                      array( $this, 'cctvsecuritycamera_customizer_register' ) );
			add_action( 'after_setup_theme',                       array( $this, 'cctvsecuritycamera_customizer_settings' ) );
		}
		
		/**
		 * Add postMessage support for site title and description for the Theme Customizer.
		 *
		 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
		 */
		function cctvsecuritycamera_customizer_register( $wp_customize ) {
			
			$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
			$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
			$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';
			$wp_customize->get_setting( 'background_color' )->transport = 'postMessage';
			$wp_customize->get_setting('custom_logo')->transport = 'refresh';			
			
			/**
			 * Helper files
			 */
			require CCTV_SECURITY_CAMERA_PARENT_INC_DIR . '/customizer/sanitization.php';
		}


	
		
		/**
		 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
		 */
		function cctvsecuritycamera_customize_preview_js() {
			wp_enqueue_script( 'cctvsecuritycamera-customizer', CCTV_SECURITY_CAMERA_PARENT_INC_URI . '/customizer/assets/js/customizer-preview.js', array( 'customize-preview' ), '20151215', true );
		}
		
		
		function cctvsecuritycamera_customizer_script() {
			 wp_enqueue_script( 'cctvsecuritycamera-customizer-section', CCTV_SECURITY_CAMERA_PARENT_INC_URI .'/customizer/assets/js/customizer-section.js', array("jquery"),'', true  );	
		}

		// Include customizer customizer settings.
			
		function cctvsecuritycamera_customizer_settings() {	
			   require CCTV_SECURITY_CAMERA_PARENT_INC_DIR . '/customizer/customizer-options/cctvsecuritycamera-header.php';
			   require CCTV_SECURITY_CAMERA_PARENT_INC_DIR . '/customizer/customizer-options/cctvsecuritycamera-frontpage.php';
			   require CCTV_SECURITY_CAMERA_PARENT_INC_DIR . '/customizer/customizer-options/cctvsecuritycamera-footer.php';
			   require CCTV_SECURITY_CAMERA_PARENT_INC_DIR . '/customizer/customizer-pro/class-customize.php';
		}

	}
}// End if().

/**
 *  Kicking this off by calling 'get_instance()' method
 */
cctvsecuritycamera_Customizer::get_instance();